/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.PhreakFromNode;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;

public abstract class ReactiveObject {
    private final List<LeftTuple> lts = new ArrayList<LeftTuple>();

    public void addLeftTuple(LeftTuple leftTuple) {
        this.lts.add(leftTuple);
    }

    protected void notifyModification() {
        this.notifyModification(this);
    }

    protected void notifyModification(Object object) {
        for (LeftTuple leftTuple : this.lts) {
            PropagationContext propagationContext = leftTuple.getPropagationContext();
            ReactiveFromNode node = (ReactiveFromNode)leftTuple.getSink();
            LeftTupleSinkNode sink = node.getSinkPropagator().getFirstLeftTupleSink();
            InternalWorkingMemory wm = this.getInternalWorkingMemory(propagationContext);
            wm.addPropagation(new ReactivePropagation(object, leftTuple, propagationContext, node, sink));
        }
    }

    private InternalWorkingMemory getInternalWorkingMemory(PropagationContext propagationContext) {
        InternalFactHandle fh = (InternalFactHandle)propagationContext.getFactHandleOrigin();
        return fh.getEntryPoint().getInternalWorkingMemory();
    }

    class ReactivePropagation
    extends PropagationEntry.AbstractPropagationEntry {
        private final Object object;
        private final LeftTuple leftTuple;
        private final PropagationContext propagationContext;
        private final ReactiveFromNode node;
        private final LeftTupleSinkNode sink;

        ReactivePropagation(Object object, LeftTuple leftTuple, PropagationContext propagationContext, ReactiveFromNode node, LeftTupleSinkNode sink) {
            this.object = object;
            this.leftTuple = leftTuple;
            this.propagationContext = propagationContext;
            this.node = node;
            this.sink = sink;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            ReactiveFromNode.ReactiveFromMemory mem = wm.getNodeMemory(this.node);
            InternalFactHandle factHandle = this.node.createFactHandle(this.leftTuple, this.propagationContext, wm, this.object);
            if (PhreakFromNode.isAllowed(factHandle, this.node.getAlphaConstraints(), wm, mem)) {
                ContextEntry[] context = mem.getBetaMemory().getContext();
                BetaConstraints betaConstraints = this.node.getBetaConstraints();
                betaConstraints.updateFromTuple(context, wm, this.leftTuple);
                PhreakFromNode.propagate(this.sink, this.leftTuple, new RightTuple(factHandle), betaConstraints, this.propagationContext, context, RuleNetworkEvaluator.useLeftMemory(this.node, this.leftTuple), mem.getStagedLeftTuples(), null);
            } else {
                LeftTuple childLeftTuple = this.leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple next = childLeftTuple.getLeftParentNext();
                    if (this.object == childLeftTuple.getHandle().getObject()) {
                        PhreakFromNode.deleteChildLeftTuple(this.propagationContext, mem.getStagedLeftTuples(), null, childLeftTuple);
                    }
                    childLeftTuple = next;
                }
            }
            mem.getBetaMemory().setNodeDirty(wm);
        }
    }
}

