/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.base.ValueType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AbstractObjectSinkAdapter;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSinkNodeList;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.ObjectHashMap;

public class CompositeObjectSinkAdapter
extends AbstractObjectSinkAdapter {
    private static final long serialVersionUID = 510L;
    ObjectSinkNodeList otherSinks;
    ObjectSinkNodeList hashableSinks;
    LinkedList<FieldIndex> hashedFieldIndexes;
    ObjectHashMap hashedSinkMap;
    private int alphaNodeHashingThreshold;
    private ObjectSink[] sinks;

    public CompositeObjectSinkAdapter() {
        this(null, 3);
    }

    public CompositeObjectSinkAdapter(RuleBasePartitionId partitionId, int alphaNodeHashingThreshold) {
        super(partitionId);
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.otherSinks = (ObjectSinkNodeList)in.readObject();
        this.hashableSinks = (ObjectSinkNodeList)in.readObject();
        this.hashedFieldIndexes = (LinkedList)in.readObject();
        this.hashedSinkMap = (ObjectHashMap)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.otherSinks);
        out.writeObject(this.hashableSinks);
        out.writeObject(this.hashedFieldIndexes);
        out.writeObject(this.hashedSinkMap);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSinkNodeList getOthers() {
        return this.otherSinks;
    }

    public ObjectSinkNodeList getHashableSinks() {
        return this.hashableSinks;
    }

    public ObjectHashMap getHashedSinkMap() {
        return this.hashedSinkMap;
    }

    public void addObjectSink(ObjectSink sink) {
        IndexableConstraint indexableConstraint;
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        this.sinks = null;
        if (sink.getType() == 40 && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof IndexableConstraint && this.isHashable(indexableConstraint = (IndexableConstraint)((Object)fieldConstraint))) {
            InternalReadAccessor readAccessor = indexableConstraint.getFieldExtractor();
            int index = readAccessor.getIndex();
            FieldIndex fieldIndex = this.registerFieldIndex(index, readAccessor);
            FieldValue value = indexableConstraint.getField();
            if (fieldIndex.getCount() >= this.alphaNodeHashingThreshold && this.alphaNodeHashingThreshold != 0 && !value.isNull()) {
                if (!fieldIndex.isHashed()) {
                    this.hashSinks(fieldIndex);
                }
                this.hashedSinkMap.put(new HashKey(index, value, fieldIndex.getFieldExtractor()), alphaNode, false);
            } else {
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add(alphaNode);
            }
            return;
        }
        if (this.otherSinks == null) {
            this.otherSinks = new ObjectSinkNodeList();
        }
        this.otherSinks.add((ObjectSinkNode)sink);
    }

    private boolean isHashable(IndexableConstraint indexableConstraint) {
        return indexableConstraint.isIndexable((short)40) && indexableConstraint.getField() != null && indexableConstraint.getFieldExtractor().getValueType() != ValueType.OBJECT_TYPE && indexableConstraint.getFieldExtractor().getIndex() >= 0;
    }

    public void removeObjectSink(ObjectSink sink) {
        AlphaNode alphaNode;
        AlphaNodeFieldConstraint fieldConstraint;
        this.sinks = null;
        if (sink.getType() == 40 && (fieldConstraint = (alphaNode = (AlphaNode)sink).getConstraint()) instanceof IndexableConstraint) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            FieldValue value = indexableConstraint.getField();
            if (this.isHashable(indexableConstraint)) {
                InternalReadAccessor fieldAccessor = indexableConstraint.getFieldExtractor();
                int index = fieldAccessor.getIndex();
                FieldIndex fieldIndex = this.unregisterFieldIndex(index);
                if (fieldIndex.isHashed()) {
                    HashKey hashKey = new HashKey(index, value, fieldAccessor);
                    this.hashedSinkMap.remove(hashKey);
                    if (fieldIndex.getCount() <= this.alphaNodeHashingThreshold - 1) {
                        this.unHashSinks(fieldIndex);
                    }
                } else {
                    this.hashableSinks.remove(alphaNode);
                }
                if (this.hashableSinks != null && this.hashableSinks.isEmpty()) {
                    this.hashableSinks = null;
                }
                return;
            }
        }
        this.otherSinks.remove((ObjectSinkNode)sink);
        if (this.otherSinks.isEmpty()) {
            this.otherSinks = null;
        }
    }

    void hashSinks(FieldIndex fieldIndex) {
        if (this.hashedSinkMap == null) {
            this.hashedSinkMap = new ObjectHashMap();
        }
        int index = fieldIndex.getIndex();
        InternalReadAccessor fieldReader = fieldIndex.getFieldExtractor();
        for (ObjectSinkNode currentSink = this.hashableSinks.getFirst(); currentSink != null; currentSink = currentSink.getNextObjectSinkNode()) {
            AlphaNode alphaNode = (AlphaNode)currentSink;
            AlphaNodeFieldConstraint fieldConstraint = alphaNode.getConstraint();
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)fieldConstraint);
            if (index != indexableConstraint.getFieldExtractor().getIndex()) continue;
            FieldValue value = indexableConstraint.getField();
            this.hashedSinkMap.put(new HashKey(index, value, fieldReader), alphaNode);
            this.hashableSinks.remove(alphaNode);
        }
        if (this.hashableSinks.isEmpty()) {
            this.hashableSinks = null;
        }
        fieldIndex.setHashed(true);
    }

    void unHashSinks(FieldIndex fieldIndex) {
        int index = fieldIndex.getIndex();
        ArrayList<HashKey> unhashedSinks = new ArrayList<HashKey>();
        Iterator iter = this.hashedSinkMap.newIterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)iter.next();
        while (entry != null) {
            AlphaNode alphaNode = (AlphaNode)entry.getValue();
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)alphaNode.getConstraint());
            if (index == indexableConstraint.getFieldExtractor().getIndex()) {
                FieldValue value = indexableConstraint.getField();
                if (this.hashableSinks == null) {
                    this.hashableSinks = new ObjectSinkNodeList();
                }
                this.hashableSinks.add(alphaNode);
                unhashedSinks.add(new HashKey(index, value, fieldIndex.getFieldExtractor()));
            }
            entry = (ObjectHashMap.ObjectEntry)iter.next();
        }
        for (HashKey hashKey : unhashedSinks) {
            this.hashedSinkMap.remove(hashKey);
        }
        if (this.hashedSinkMap.isEmpty()) {
            this.hashedSinkMap = null;
        }
        fieldIndex.setHashed(false);
    }

    private FieldIndex registerFieldIndex(int index, InternalReadAccessor fieldExtractor) {
        FieldIndex fieldIndex = null;
        if (this.hashedFieldIndexes == null) {
            this.hashedFieldIndexes = new LinkedList();
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        if (fieldIndex == null) {
            fieldIndex = this.findFieldIndex(index);
        }
        if (fieldIndex == null) {
            fieldIndex = new FieldIndex(index, fieldExtractor);
            this.hashedFieldIndexes.add(fieldIndex);
        }
        fieldIndex.increaseCounter();
        return fieldIndex;
    }

    private FieldIndex unregisterFieldIndex(int index) {
        FieldIndex fieldIndex = this.findFieldIndex(index);
        fieldIndex.decreaseCounter();
        if (fieldIndex.getCount() == 0) {
            this.hashedFieldIndexes.remove(fieldIndex);
            if (this.hashedFieldIndexes.isEmpty()) {
                this.hashedFieldIndexes = null;
            }
        }
        return fieldIndex;
    }

    private FieldIndex findFieldIndex(int index) {
        for (FieldIndex node = this.hashedFieldIndexes.getFirst(); node != null; node = node.getNext()) {
            if (node.getIndex() != index) continue;
            return node;
        }
        return null;
    }

    @Override
    public void propagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                int index;
                HashKey hashKey;
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(hashKey = new HashKey(index = fieldIndex.getIndex(), object, fieldIndex.getFieldExtractor()))) == null) continue;
                sink2.getSinkPropagator().propagateAssertObject(factHandle, context, workingMemory);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateAssertObject(factHandle, context, workingMemory, sink);
            }
        }
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                int index;
                HashKey hashKey;
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(hashKey = new HashKey(index = fieldIndex.getIndex(), object, fieldIndex.getFieldExtractor()))) == null) continue;
                sink2.getSinkPropagator().propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
            }
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectSinkNode sink;
        Object object = factHandle.getObject();
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                int index;
                HashKey hashKey;
                AlphaNode sink2;
                if (!fieldIndex.isHashed() || (sink2 = (AlphaNode)this.hashedSinkMap.get(hashKey = new HashKey(index = fieldIndex.getIndex(), object, fieldIndex.getFieldExtractor()))) == null) continue;
                sink2.getSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                ((AlphaNode)sink).getSinkPropagator().byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
            }
        }
    }

    protected void doPropagateAssertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.assertObject(factHandle, context, workingMemory);
    }

    protected void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, ObjectSink sink) {
        sink.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        ObjectSinkNode sink;
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                if (!candidate.equals(sink)) continue;
                return (BaseNode)((Object)sink);
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                if (!candidate.equals(sink)) continue;
                return (BaseNode)((Object)sink);
            }
        }
        if (this.hashedSinkMap != null) {
            Iterator it = this.hashedSinkMap.newIterator();
            ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
            while (entry != null) {
                ObjectSink sink2 = (ObjectSink)entry.getValue();
                if (candidate.equals(sink2)) {
                    return (BaseNode)((Object)sink2);
                }
                entry = (ObjectHashMap.ObjectEntry)it.next();
            }
        }
        return null;
    }

    @Override
    public ObjectSink[] getSinks() {
        ObjectSinkNode sink;
        if (this.sinks != null) {
            return this.sinks;
        }
        ObjectSink[] sinks = new ObjectSink[this.size()];
        int at = 0;
        if (this.hashedFieldIndexes != null) {
            for (FieldIndex fieldIndex = this.hashedFieldIndexes.getFirst(); fieldIndex != null; fieldIndex = fieldIndex.getNext()) {
                if (!fieldIndex.isHashed()) continue;
                int index = fieldIndex.getIndex();
                Iterator it = this.hashedSinkMap.newIterator();
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    HashKey hashKey = (HashKey)entry.getKey();
                    if (hashKey.getIndex() == index) {
                        sinks[at++] = (ObjectSink)entry.getValue();
                    }
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
            }
        }
        if (this.hashableSinks != null) {
            for (sink = this.hashableSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sinks[at++] = sink;
            }
        }
        if (this.otherSinks != null) {
            for (sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                sinks[at++] = sink;
            }
        }
        this.sinks = sinks;
        return sinks;
    }

    @Override
    public void doLinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                SingleObjectSinkAdapter.staticDoLinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public void doUnlinkRiaNode(InternalWorkingMemory wm) {
        if (this.otherSinks != null) {
            for (ObjectSinkNode sink = this.otherSinks.getFirst(); sink != null; sink = sink.getNextObjectSinkNode()) {
                SingleObjectSinkAdapter.staticDoUnlinkRiaNode(sink, wm);
            }
        }
    }

    @Override
    public int size() {
        return (this.otherSinks != null ? this.otherSinks.size() : 0) + (this.hashableSinks != null ? this.hashableSinks.size() : 0) + (this.hashedSinkMap != null ? this.hashedSinkMap.size() : 0);
    }

    public static class FieldIndex
    implements LinkedListNode<FieldIndex>,
    Externalizable {
        private static final long serialVersionUID = 510L;
        private int index;
        private InternalReadAccessor fieldExtactor;
        private int count;
        private boolean hashed;
        private FieldIndex previous;
        private FieldIndex next;

        public FieldIndex() {
        }

        public FieldIndex(int index, InternalReadAccessor fieldExtractor) {
            this.index = index;
            this.fieldExtactor = fieldExtractor;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.fieldExtactor = (InternalReadAccessor)in.readObject();
            this.count = in.readInt();
            this.hashed = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeObject(this.fieldExtactor);
            out.writeInt(this.count);
            out.writeBoolean(this.hashed);
        }

        public InternalReadAccessor getFieldExtractor() {
            return this.fieldExtactor;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public ReadAccessor getFieldExtactor() {
            return this.fieldExtactor;
        }

        public boolean isHashed() {
            return this.hashed;
        }

        public void setHashed(boolean hashed) {
            this.hashed = hashed;
        }

        public void increaseCounter() {
            ++this.count;
        }

        public void decreaseCounter() {
            --this.count;
        }

        @Override
        public FieldIndex getNext() {
            return this.next;
        }

        @Override
        public FieldIndex getPrevious() {
            return this.previous;
        }

        @Override
        public void setNext(FieldIndex next) {
            this.next = next;
        }

        @Override
        public void setPrevious(FieldIndex previous) {
            this.previous = previous;
        }

        @Override
        public void nullPrevNext() {
            this.previous = null;
            this.next = null;
        }
    }

    public static class HashKey
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private static final byte OBJECT = 1;
        private static final byte LONG = 2;
        private static final byte DOUBLE = 3;
        private static final byte BOOL = 4;
        private int index;
        private byte type;
        private Object ovalue;
        private long lvalue;
        private boolean bvalue;
        private double dvalue;
        private boolean isNull;
        private int hashCode;

        public HashKey() {
        }

        public HashKey(int index, FieldValue value, InternalReadAccessor extractor) {
            this.setValue(index, extractor, value);
        }

        public HashKey(int index, Object value, InternalReadAccessor extractor) {
            this.setValue(index, value, extractor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = in.readInt();
            this.type = in.readByte();
            this.ovalue = in.readObject();
            this.lvalue = in.readLong();
            this.bvalue = in.readBoolean();
            this.dvalue = in.readDouble();
            this.isNull = in.readBoolean();
            this.hashCode = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeByte(this.type);
            out.writeObject(this.ovalue);
            out.writeLong(this.lvalue);
            out.writeBoolean(this.bvalue);
            out.writeDouble(this.dvalue);
            out.writeBoolean(this.isNull);
            out.writeInt(this.hashCode);
        }

        public int getIndex() {
            return this.index;
        }

        public void setValue(int index, Object value, InternalReadAccessor extractor) {
            this.index = index;
            ValueType vtype = extractor.getValueType();
            this.isNull = extractor.isNullValue(null, value);
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = extractor.getBooleanValue(null, value);
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber() || vtype.isChar()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = extractor.getLongValue(null, value);
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = extractor.getDoubleValue(null, value);
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = extractor.getValue(null, value);
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        public void setValue(int index, InternalReadAccessor extractor, FieldValue value) {
            this.index = index;
            this.isNull = value.isNull();
            ValueType vtype = extractor.getValueType();
            if (vtype.isBoolean()) {
                this.type = (byte)4;
                if (!this.isNull) {
                    this.bvalue = value.getBooleanValue();
                    this.setHashCode(this.bvalue ? 1231 : 1237);
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isIntegerNumber()) {
                this.type = (byte)2;
                if (!this.isNull) {
                    this.lvalue = value.getLongValue();
                    this.setHashCode((int)(this.lvalue ^ this.lvalue >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else if (vtype.isFloatNumber()) {
                this.type = (byte)3;
                if (!this.isNull) {
                    this.dvalue = value.getDoubleValue();
                    long temp = Double.doubleToLongBits(this.dvalue);
                    this.setHashCode((int)(temp ^ temp >>> 32));
                } else {
                    this.setHashCode(0);
                }
            } else {
                this.type = 1;
                if (!this.isNull) {
                    this.ovalue = vtype.coerce(value.getValue());
                    this.setHashCode(this.ovalue != null ? this.ovalue.hashCode() : 0);
                } else {
                    this.setHashCode(0);
                }
            }
        }

        private void setHashCode(int hashSeed) {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + hashSeed;
            this.hashCode = result = 31 * result + this.index;
        }

        public boolean getBooleanValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return false;
                    }
                    if (this.ovalue instanceof Boolean) {
                        return (Boolean)this.ovalue;
                    }
                    if (this.ovalue instanceof String) {
                        return Boolean.valueOf((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a boolean value.");
                }
                case 2: {
                    throw new ClassCastException("Can't convert long to a boolean value.");
                }
                case 3: {
                    throw new ClassCastException("Can't convert double to a boolean value.");
                }
            }
            return false;
        }

        public long getLongValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1L : 0L;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0L;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).longValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Long.parseLong((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a long value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return (long)this.dvalue;
                }
            }
            return 0L;
        }

        public double getDoubleValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? 1.0 : 0.0;
                }
                case 1: {
                    if (this.ovalue == null) {
                        return 0.0;
                    }
                    if (this.ovalue instanceof Number) {
                        return ((Number)this.ovalue).doubleValue();
                    }
                    if (this.ovalue instanceof String) {
                        return Double.parseDouble((String)this.ovalue);
                    }
                    throw new ClassCastException("Can't convert " + this.ovalue.getClass() + " to a double value.");
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return 0.0;
        }

        public Object getObjectValue() {
            switch (this.type) {
                case 4: {
                    return this.bvalue ? Boolean.TRUE : Boolean.FALSE;
                }
                case 1: {
                    return this.ovalue;
                }
                case 2: {
                    return this.lvalue;
                }
                case 3: {
                    return this.dvalue;
                }
            }
            return null;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            HashKey other = (HashKey)object;
            if (this.isNull) {
                return other.isNull;
            }
            if (this.index != other.index) {
                return false;
            }
            switch (this.type) {
                case 4: {
                    return this.bvalue == other.getBooleanValue();
                }
                case 2: {
                    return this.lvalue == other.getLongValue();
                }
                case 3: {
                    return this.dvalue == other.getDoubleValue();
                }
                case 1: {
                    Object otherValue = other.getObjectValue();
                    return this.ovalue == null ? otherValue == null : this.ovalue.equals(otherValue);
                }
            }
            return false;
        }
    }
}

