/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocatorImpl;
import org.dashbuilder.dataprovider.sql.SQLFactory;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.dashbuilder.dataprovider.sql.model.SortColumn;
import org.dashbuilder.dataprovider.sql.model.Table;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpEngine;
import org.dashbuilder.dataset.IntervalBuilderDynamicDate;
import org.dashbuilder.dataset.date.DateUtils;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.impl.MemSizeEstimator;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDataSetProvider
implements DataSetProvider,
DataSetDefRegistryListener {
    private static SQLDataSetProvider SINGLETON = null;
    protected Logger log = LoggerFactory.getLogger(SQLDataSetProvider.class);
    protected StaticDataSetProvider staticDataSetProvider;
    protected SQLDataSourceLocator dataSourceLocator;
    protected IntervalBuilderLocator intervalBuilderLocator;
    protected IntervalBuilderDynamicDate intervalBuilderDynamicDate;
    protected DataSetDefRegistry dataSetDefRegistry;
    protected DataSetOpEngine opEngine;
    protected transient Map<String, MetadataHolder> _metadataMap = new HashMap<String, MetadataHolder>();

    public static SQLDataSetProvider get() {
        if (SINGLETON == null) {
            DataSetCore dataSetCore = DataSetCore.get();
            StaticDataSetProvider staticDataSetProvider = dataSetCore.getStaticDataSetProvider();
            DataSetDefRegistry dataSetDefRegistry = dataSetCore.getDataSetDefRegistry();
            SharedDataSetOpEngine dataSetOpEngine = dataSetCore.getSharedDataSetOpEngine();
            IntervalBuilderLocator intervalBuilderLocator = dataSetCore.getIntervalBuilderLocator();
            IntervalBuilderDynamicDate intervalBuilderDynamicDate = dataSetCore.getIntervalBuilderDynamicDate();
            SINGLETON = new SQLDataSetProvider(staticDataSetProvider, new SQLDataSourceLocatorImpl(), intervalBuilderLocator, intervalBuilderDynamicDate, dataSetDefRegistry, (DataSetOpEngine)dataSetOpEngine);
        }
        return SINGLETON;
    }

    public SQLDataSetProvider() {
    }

    public SQLDataSetProvider(StaticDataSetProvider staticDataSetProvider, SQLDataSourceLocator dataSourceLocator, IntervalBuilderLocator intervalBuilderLocator, IntervalBuilderDynamicDate intervalBuilderDynamicDate, DataSetDefRegistry dataSetDefRegistry, DataSetOpEngine opEngine) {
        this.staticDataSetProvider = staticDataSetProvider;
        this.dataSourceLocator = dataSourceLocator;
        this.intervalBuilderLocator = intervalBuilderLocator;
        this.intervalBuilderDynamicDate = intervalBuilderDynamicDate;
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.dataSetDefRegistry.addListener((DataSetDefRegistryListener)this);
        this.opEngine = opEngine;
    }

    public StaticDataSetProvider getStaticDataSetProvider() {
        return this.staticDataSetProvider;
    }

    public void setStaticDataSetProvider(StaticDataSetProvider staticDataSetProvider) {
        this.staticDataSetProvider = staticDataSetProvider;
    }

    public SQLDataSourceLocator getDataSourceLocator() {
        return this.dataSourceLocator;
    }

    public void setDataSourceLocator(SQLDataSourceLocator dataSourceLocator) {
        this.dataSourceLocator = dataSourceLocator;
    }

    public IntervalBuilderLocator getIntervalBuilderLocator() {
        return this.intervalBuilderLocator;
    }

    public void setIntervalBuilderLocator(IntervalBuilderLocator intervalBuilderLocator) {
        this.intervalBuilderLocator = intervalBuilderLocator;
    }

    public IntervalBuilderDynamicDate getIntervalBuilderDynamicDate() {
        return this.intervalBuilderDynamicDate;
    }

    public void setIntervalBuilderDynamicDate(IntervalBuilderDynamicDate intervalBuilderDynamicDate) {
        this.intervalBuilderDynamicDate = intervalBuilderDynamicDate;
    }

    public DataSetDefRegistry getDataSetDefRegistry() {
        return this.dataSetDefRegistry;
    }

    public void setDataSetDefRegistry(DataSetDefRegistry dataSetDefRegistry) {
        this.dataSetDefRegistry = dataSetDefRegistry;
    }

    public DataSetOpEngine getOpEngine() {
        return this.opEngine;
    }

    public void setOpEngine(DataSetOpEngine opEngine) {
        this.opEngine = opEngine;
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.SQL;
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        SQLDataSetDef sqlDef = (SQLDataSetDef)def;
        if (StringUtils.isBlank((CharSequence)sqlDef.getDataSource())) {
            throw new IllegalArgumentException("Missing data source in SQL data set definition: " + sqlDef);
        }
        if (StringUtils.isBlank((CharSequence)sqlDef.getDbSQL()) && StringUtils.isBlank((CharSequence)sqlDef.getDbTable())) {
            throw new IllegalArgumentException("Missing DB table or SQL in the data set definition: " + sqlDef);
        }
        if (sqlDef.isCacheEnabled()) {
            DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
            if (dataSet != null) {
                return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
            }
            int rows = this.getRowCount(sqlDef);
            if (rows > sqlDef.getCacheMaxRows()) {
                return this._lookupDataSet(sqlDef, lookup);
            }
            dataSet = this._lookupDataSet(sqlDef, null);
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            this.staticDataSetProvider.registerDataSet(dataSet);
            return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
        }
        return this._lookupDataSet(sqlDef, lookup);
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        MetadataHolder last = this._metadataMap.remove(def.getUUID());
        if (last == null) {
            return false;
        }
        try {
            DataSetMetadata current = this.getDataSetMetadata(def);
            return !current.equals(last.metadata);
        }
        catch (Exception e) {
            this.log.error("Error fetching metadata: " + def, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        SQLDataSetDef sqlDef = (SQLDataSetDef)def;
        DataSource ds = this.dataSourceLocator.lookup(sqlDef);
        Connection conn = ds.getConnection();
        try {
            DataSetMetadata dataSetMetadata = this._getDataSetMetadata(sqlDef, conn, true);
            return dataSetMetadata;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(SQLDataSetDef def) throws Exception {
        DataSource ds = this.dataSourceLocator.lookup(def);
        Connection conn = ds.getConnection();
        try {
            int n = this._getRowCount(def, conn);
            return n;
        }
        finally {
            conn.close();
        }
    }

    public void onDataSetDefStale(DataSetDef def) {
        if (DataSetProviderType.SQL.equals((Object)def.getProvider())) {
            this.staticDataSetProvider.removeDataSet(def.getUUID());
        }
    }

    public void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        if (DataSetProviderType.SQL.equals((Object)olDef.getProvider())) {
            String uuid = olDef.getUUID();
            this._metadataMap.remove(uuid);
            this.staticDataSetProvider.removeDataSet(uuid);
        }
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        if (DataSetProviderType.SQL.equals((Object)oldDef.getProvider())) {
            String uuid = oldDef.getUUID();
            this._metadataMap.remove(uuid);
            this.staticDataSetProvider.removeDataSet(uuid);
        }
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
    }

    protected Column _getDbColumn(Collection<Column> dbColumns, String columnId) {
        for (Column dbColumn : dbColumns) {
            if (!dbColumn.getName().equalsIgnoreCase(columnId)) continue;
            return dbColumn;
        }
        return null;
    }

    protected DataSetMetadata _getDataSetMetadata(SQLDataSetDef def, Connection conn, boolean isTestMode) throws Exception {
        MetadataHolder result;
        if (!isTestMode && (result = this._metadataMap.get(def.getUUID())) != null) {
            return result.metadata;
        }
        int estimatedSize = 0;
        int rowCount = this._getRowCount(def, conn);
        Collection<Column> dbColumns = this._getColumns(def, conn);
        ArrayList<String> dbColumnIds = new ArrayList<String>();
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        if (def.getColumns() != null) {
            for (DataColumnDef column : def.getColumns()) {
                Column dbColumn = this._getDbColumn(dbColumns, column.getId());
                if (dbColumn == null) {
                    throw new IllegalArgumentException("The DataSetDef's column does not exist in DB: " + column.getId());
                }
                dbColumnIds.add(dbColumn.getName());
                columnTypes.add(column.getColumnType());
            }
        }
        for (Column dbColumn : dbColumns) {
            ColumnType cType;
            boolean columnExists;
            String dbColumnId = dbColumn.getName();
            int columnIdx = dbColumnIds.indexOf(dbColumnId);
            boolean bl = columnExists = columnIdx != -1;
            if (!columnExists) {
                if (!def.isAllColumnsEnabled()) continue;
                dbColumnIds.add(dbColumnId);
                columnIdx = dbColumnIds.size() - 1;
                columnTypes.add(dbColumn.getType());
            }
            if (ColumnType.DATE.equals((Object)(cType = (ColumnType)columnTypes.get(columnIdx)))) {
                estimatedSize += MemSizeEstimator.sizeOf(java.util.Date.class) * rowCount;
                continue;
            }
            if (ColumnType.NUMBER.equals((Object)cType)) {
                estimatedSize += MemSizeEstimator.sizeOf(Double.class) * rowCount;
                continue;
            }
            int length = dbColumn.getLength();
            estimatedSize += length / 2 * rowCount;
        }
        if (dbColumnIds.isEmpty()) {
            throw new IllegalArgumentException("No data set columns found: " + def);
        }
        MetadataHolder result2 = new MetadataHolder();
        result2.columns = dbColumns;
        result2.metadata = new DataSetMetadataImpl((DataSetDef)def, def.getUUID(), rowCount, dbColumnIds.size(), dbColumnIds, columnTypes, estimatedSize);
        if (!isTestMode) {
            boolean isDefRegistered;
            boolean bl = isDefRegistered = def.getUUID() != null && this.dataSetDefRegistry.getDataSetDef(def.getUUID()) != null;
            if (isDefRegistered) {
                this._metadataMap.put(def.getUUID(), result2);
            }
        }
        return result2.metadata;
    }

    protected Collection<Column> _getColumns(SQLDataSetDef def, Connection conn) throws Exception {
        Dialect dialect = JDBCUtils.dialect(conn);
        if (!StringUtils.isBlank((CharSequence)def.getDbSQL())) {
            Select query = SQLFactory.select(conn).from(def.getDbSQL()).limit(1);
            return JDBCUtils.getColumns(this.logSQL(query).fetch(), dialect.getExcludedColumns());
        }
        Select query = SQLFactory.select(conn).from(this._createTable(def)).limit(1);
        return JDBCUtils.getColumns(this.logSQL(query).fetch(), dialect.getExcludedColumns());
    }

    protected int _getRowCount(SQLDataSetDef def, Connection conn) throws Exception {
        Select _query = SQLFactory.select(conn);
        this._appendFrom(def, _query);
        DataSetFilter filterOp = def.getDataSetFilter();
        if (filterOp != null) {
            List filterList = filterOp.getColumnFilterList();
            for (ColumnFilter filter : filterList) {
                this._appendFilterBy(def, filter, _query);
            }
        }
        return _query.fetchCount();
    }

    protected DataSet _lookupDataSet(SQLDataSetDef def, DataSetLookup lookup) throws Exception {
        LookupProcessor processor = new LookupProcessor(def, lookup);
        return processor.run();
    }

    protected Table _createTable(SQLDataSetDef def) {
        if (StringUtils.isBlank((CharSequence)def.getDbSchema())) {
            return SQLFactory.table(def.getDbTable());
        }
        return SQLFactory.table(def.getDbSchema(), def.getDbTable());
    }

    protected void _appendFrom(SQLDataSetDef def, Select _query) {
        if (!StringUtils.isBlank((CharSequence)def.getDbSQL())) {
            _query.from(def.getDbSQL());
        } else {
            _query.from(this._createTable(def));
        }
    }

    protected void _appendFilterBy(SQLDataSetDef def, DataSetFilter filterOp, Select _query) {
        List filterList = filterOp.getColumnFilterList();
        for (ColumnFilter filter : filterList) {
            this._appendFilterBy(def, filter, _query);
        }
    }

    protected void _appendFilterBy(SQLDataSetDef def, ColumnFilter filter, Select _query) {
        Condition condition = this._createCondition(def, filter);
        if (condition != null) {
            _query.where(condition);
        }
    }

    protected Condition _createCondition(SQLDataSetDef def, ColumnFilter filter) {
        CoreFunctionType type;
        CoreFunctionFilter f;
        String filterId = filter.getColumnId();
        Column _column = SQLFactory.column(filterId);
        if (filter instanceof CoreFunctionFilter) {
            TimeFrame timeFrame;
            f = (CoreFunctionFilter)filter;
            type = f.getType();
            List params = f.getParameters();
            if (CoreFunctionType.IS_NULL.equals((Object)type)) {
                return _column.isNull();
            }
            if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
                return _column.notNull();
            }
            if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
                if (params.isEmpty()) {
                    return null;
                }
                if (params.size() == 1) {
                    return _column.equalsTo(params.get(0));
                }
                return _column.in(params);
            }
            if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
                if (params.isEmpty()) {
                    return null;
                }
                if (params.size() == 1) {
                    return _column.notEquals(params.get(0));
                }
                return _column.in(params).not();
            }
            if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
                boolean caseSensitive;
                String pattern = (String)params.get(0);
                boolean bl = caseSensitive = params.size() < 2 || Boolean.parseBoolean(params.get(1).toString());
                if (caseSensitive) {
                    return _column.like(pattern);
                }
                return _column.lower().like(pattern.toLowerCase());
            }
            if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
                return _column.lowerThan(params.get(0));
            }
            if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
                return _column.lowerOrEquals(params.get(0));
            }
            if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
                return _column.greaterThan(params.get(0));
            }
            if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
                return _column.greaterOrEquals(params.get(0));
            }
            if (CoreFunctionType.BETWEEN.equals((Object)type)) {
                Object low = params.get(0);
                Object high = params.get(1);
                if (low == null && high == null) {
                    return null;
                }
                if (low != null && high == null) {
                    return _column.greaterOrEquals(low);
                }
                if (low == null && high != null) {
                    return _column.lowerOrEquals(high);
                }
                return _column.between(low, high);
            }
            if (CoreFunctionType.TIME_FRAME.equals((Object)type) && (timeFrame = TimeFrame.parse((String)params.get(0).toString())) != null) {
                Date past = new Date(timeFrame.getFrom().getTimeInstant().getTime());
                Date future = new Date(timeFrame.getTo().getTimeInstant().getTime());
                return _column.between(past, future);
            }
            if (CoreFunctionType.IN.equals((Object)type) && params instanceof List) {
                if (params.isEmpty()) {
                    return null;
                }
                return _column.inSql(params);
            }
            if (CoreFunctionType.NOT_IN.equals((Object)type) && params instanceof List) {
                if (params.isEmpty()) {
                    return null;
                }
                return _column.notInSql(params);
            }
        }
        if (filter instanceof LogicalExprFilter) {
            f = (LogicalExprFilter)filter;
            type = f.getLogicalOperator();
            Condition condition = null;
            List logicalTerms = f.getLogicalTerms();
            for (int i = 0; i < logicalTerms.size(); ++i) {
                Condition next = this._createCondition(def, (ColumnFilter)logicalTerms.get(i));
                if (LogicalExprType.AND.equals((Object)type)) {
                    condition = condition == null ? next : condition.and(next);
                }
                if (LogicalExprType.OR.equals((Object)type)) {
                    condition = condition == null ? next : condition.or(next);
                }
                if (!LogicalExprType.NOT.equals((Object)type)) continue;
                condition = condition == null ? next.not() : condition.and(next.not());
            }
            return condition;
        }
        throw new IllegalArgumentException("Filter not supported: " + filter);
    }

    public Select logSQL(Select q) {
        String sql = q.getSQL();
        this.log.debug(sql);
        return q;
    }

    private class LookupProcessor {
        SQLDataSetDef def;
        DataSetLookup lookup;
        DataSetMetadata metadata;
        Select _query;
        Connection conn;
        java.util.Date[] dateLimits;
        DateIntervalType dateIntervalType;
        List<DataSetOp> postProcessingOps = new ArrayList<DataSetOp>();

        public LookupProcessor(SQLDataSetDef def, DataSetLookup lookup) {
            this.def = def;
            this.lookup = lookup;
            DataSetFilter dataSetFilter = def.getDataSetFilter();
            if (dataSetFilter != null) {
                if (lookup == null) {
                    this.lookup = new DataSetLookup(def.getUUID(), new DataSetOp[]{dataSetFilter});
                } else {
                    this.lookup.addOperation(new DataSetOp[]{dataSetFilter});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataSet run() throws Exception {
            DataSource ds = SQLDataSetProvider.this.dataSourceLocator.lookup(this.def);
            this.conn = ds.getConnection();
            try {
                DataSetSort sortOp;
                boolean trim;
                this.metadata = SQLDataSetProvider.this._getDataSetMetadata(this.def, this.conn, this.lookup.testMode());
                int totalRows = this.metadata.getNumberOfRows();
                boolean bl = trim = this.lookup != null && (this.lookup.getNumberOfRows() > 0 || this.lookup.getRowOffset() > 0);
                if (this.lookup == null || this.lookup.getOperationList().isEmpty()) {
                    this._query = SQLFactory.select(this.conn).columns(this._createAllColumns());
                    SQLDataSetProvider.this._appendFrom(this.def, this._query);
                    if (trim) {
                        totalRows = this._query.fetchCount();
                        this._query.limit(this.lookup.getNumberOfRows()).offset(this.lookup.getRowOffset());
                    }
                    ResultSet _results = SQLDataSetProvider.this.logSQL(this._query).fetch();
                    List<DataColumn> columns = this.calculateColumns(null);
                    DataSet dataSet = this._buildDataSet(columns, _results);
                    if (trim) {
                        dataSet.setRowCountNonTrimmed(totalRows);
                    }
                    DataSet dataSet2 = dataSet;
                    return dataSet2;
                }
                DataSetGroup groupOp = null;
                int groupIdx = this.lookup.getFirstGroupOpIndex(0, null, Boolean.valueOf(false));
                if (groupIdx != -1) {
                    groupOp = (DataSetGroup)this.lookup.getOperation(groupIdx);
                }
                this._query = SQLFactory.select(this.conn).columns(this._createColumns(groupOp));
                SQLDataSetProvider.this._appendFrom(this.def, this._query);
                for (DataSetFilter filterOp : this.lookup.getOperationList(DataSetFilter.class)) {
                    SQLDataSetProvider.this._appendFilterBy(this.def, filterOp, this._query);
                }
                List intervalSelects = this.lookup.getFirstGroupOpSelections();
                for (DataSetGroup intervalSelect : intervalSelects) {
                    this._appendIntervalSelection(intervalSelect, this._query);
                }
                ColumnGroup cg = null;
                if (groupOp != null && (cg = groupOp.getColumnGroup()) != null) {
                    this._appendGroupBy(groupOp);
                }
                if ((sortOp = this.lookup.getFirstSortOp()) != null) {
                    if (cg != null) {
                        this._appendOrderGroupBy(groupOp, sortOp);
                    } else {
                        this._appendOrderBy(sortOp);
                    }
                } else if (cg != null) {
                    this._appendOrderGroupBy(groupOp);
                }
                if (trim) {
                    totalRows = this._query.fetchCount();
                    this._query.limit(this.lookup.getNumberOfRows()).offset(this.lookup.getRowOffset());
                }
                ResultSet _results = SQLDataSetProvider.this.logSQL(this._query).fetch();
                List<DataColumn> columns = this.calculateColumns(groupOp);
                DataSet dataSet = this._buildDataSet(columns, _results);
                if (trim) {
                    dataSet.setRowCountNonTrimmed(totalRows);
                }
                DataSet dataSet3 = dataSet;
                return dataSet3;
            }
            finally {
                this.conn.close();
            }
        }

        protected DateIntervalType calculateDateInterval(ColumnGroup cg) {
            java.util.Date[] limits;
            if (this.dateIntervalType != null) {
                return this.dateIntervalType;
            }
            if (GroupStrategy.DYNAMIC.equals((Object)cg.getStrategy()) && (limits = this.calculateDateLimits(cg.getSourceId())) != null) {
                this.dateIntervalType = SQLDataSetProvider.this.intervalBuilderDynamicDate.calculateIntervalSize(limits[0], limits[1], cg);
                return this.dateIntervalType;
            }
            this.dateIntervalType = DateIntervalType.getByName((String)cg.getIntervalSize());
            return this.dateIntervalType;
        }

        protected java.util.Date[] calculateDateLimits(String dateColumnId) {
            if (this.dateLimits != null) {
                return this.dateLimits;
            }
            java.util.Date minDate = this.calculateDateLimit(dateColumnId, true);
            java.util.Date maxDate = this.calculateDateLimit(dateColumnId, false);
            this.dateLimits = new java.util.Date[]{minDate, maxDate};
            return this.dateLimits;
        }

        protected java.util.Date calculateDateLimit(String dateColumnId, boolean min) {
            Column _dateColumn = SQLFactory.column(dateColumnId);
            Select _limitsQuery = SQLFactory.select(this.conn).columns(_dateColumn);
            SQLDataSetProvider.this._appendFrom(this.def, _limitsQuery);
            for (DataSetFilter filterOp : this.lookup.getOperationList(DataSetFilter.class)) {
                SQLDataSetProvider.this._appendFilterBy(this.def, filterOp, _limitsQuery);
            }
            List intervalSelects = this.lookup.getFirstGroupOpSelections();
            for (DataSetGroup intervalSelect : intervalSelects) {
                this._appendIntervalSelection(intervalSelect, _limitsQuery);
            }
            try {
                ResultSet rs = SQLDataSetProvider.this.logSQL(_limitsQuery.where(_dateColumn.notNull()).orderBy(min ? _dateColumn.asc() : _dateColumn.desc()).limit(1)).fetch();
                if (!rs.next()) {
                    return null;
                }
                return rs.getDate(1);
            }
            catch (SQLException e) {
                SQLDataSetProvider.this.log.error("Error reading date limit from query results", (Throwable)e);
                return null;
            }
        }

        protected List<DataColumn> calculateColumns(DataSetGroup gOp) {
            ArrayList<DataColumn> result = new ArrayList<DataColumn>();
            if (gOp == null) {
                for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
                    String columnId = this.metadata.getColumnId(i);
                    ColumnType columnType = this.metadata.getColumnType(i);
                    DataColumnImpl column = new DataColumnImpl(columnId, columnType);
                    result.add((DataColumn)column);
                }
            } else {
                ColumnGroup cg = gOp.getColumnGroup();
                for (GroupFunction gf : gOp.getGroupFunctions()) {
                    String sourceId = gf.getSourceId();
                    String columnId = this._getTargetColumnId(gf);
                    DataColumnImpl column = new DataColumnImpl();
                    column.setId(columnId);
                    column.setGroupFunction(gf);
                    result.add((DataColumn)column);
                    if (cg != null && cg.getSourceId().equals(sourceId) && gf.getFunction() == null) {
                        column.setColumnType(ColumnType.LABEL);
                        column.setColumnGroup(cg);
                        if (!ColumnType.DATE.equals((Object)this.metadata.getColumnType(sourceId))) continue;
                        column.setIntervalType(this.dateIntervalType != null ? this.dateIntervalType.toString() : null);
                        column.setMinValue(this.dateLimits != null ? this.dateLimits[0] : null);
                        column.setMaxValue(this.dateLimits != null ? this.dateLimits[1] : null);
                        continue;
                    }
                    if (gf.getFunction() != null) {
                        column.setColumnType(ColumnType.NUMBER);
                        continue;
                    }
                    column.setColumnType(this.metadata.getColumnType(sourceId));
                }
            }
            return result;
        }

        protected void _appendOrderBy(DataSetSort sortOp) {
            ArrayList<SortColumn> _columns = new ArrayList<SortColumn>();
            List sortList = sortOp.getColumnSortList();
            for (ColumnSort columnSort : sortList) {
                String columnId = columnSort.getColumnId();
                this._assertColumnExists(columnId);
                if (SortOrder.DESCENDING.equals((Object)columnSort.getOrder())) {
                    _columns.add(SQLFactory.column(columnId).desc());
                    continue;
                }
                _columns.add(SQLFactory.column(columnId).asc());
            }
            this._query.orderBy(_columns);
        }

        protected boolean isDynamicDateGroup(DataSetGroup groupOp) {
            ColumnGroup cg = groupOp.getColumnGroup();
            if (!ColumnType.DATE.equals((Object)this.metadata.getColumnType(cg.getSourceId()))) {
                return false;
            }
            return GroupStrategy.DYNAMIC.equals((Object)cg.getStrategy());
        }

        protected void _appendOrderGroupBy(DataSetGroup groupOp) {
            if (this.isDynamicDateGroup(groupOp)) {
                ColumnGroup cg = groupOp.getColumnGroup();
                this._query.orderBy(this._createColumn(cg).asc());
                GroupFunction gf = groupOp.getGroupFunction(cg.getSourceId());
                if (gf != null) {
                    DataSetSort sortOp = new DataSetSort();
                    String targetId = this._getTargetColumnId(gf);
                    sortOp.addSortColumn(new ColumnSort[]{new ColumnSort(targetId, SortOrder.ASCENDING)});
                    this.postProcessingOps.add((DataSetOp)sortOp);
                }
            }
        }

        protected void _appendOrderGroupBy(DataSetGroup groupOp, DataSetSort sortOp) {
            ArrayList<SortColumn> _columns = new ArrayList<SortColumn>();
            List sortList = sortOp.getColumnSortList();
            ColumnGroup cg = groupOp.getColumnGroup();
            for (ColumnSort cs : sortList) {
                GroupFunction gf = groupOp.getGroupFunction(cs.getColumnId());
                if (cg.getSourceId().equals(cs.getColumnId()) || cg.getColumnId().equals(cs.getColumnId())) {
                    if (SortOrder.DESCENDING.equals((Object)cs.getOrder())) {
                        _columns.add(this._createColumn(cg).desc());
                        if (!this.isDynamicDateGroup(groupOp)) continue;
                        this.postProcessingOps.add((DataSetOp)sortOp);
                        continue;
                    }
                    _columns.add(this._createColumn(cg).asc());
                    if (!this.isDynamicDateGroup(groupOp)) continue;
                    this.postProcessingOps.add((DataSetOp)sortOp);
                    continue;
                }
                if (gf == null) continue;
                if (SortOrder.DESCENDING.equals((Object)cs.getOrder())) {
                    _columns.add(this._createColumn(gf).desc());
                    continue;
                }
                _columns.add(this._createColumn(gf).asc());
            }
            this._query.orderBy(_columns);
        }

        protected void _appendIntervalSelection(DataSetGroup intervalSel, Select _query) {
            if (intervalSel != null && intervalSel.isSelect()) {
                ColumnGroup cg = intervalSel.getColumnGroup();
                List intervalList = intervalSel.getSelectedIntervalList();
                ArrayList<String> names = new ArrayList<String>();
                Comparable min = null;
                Comparable max = null;
                for (Interval interval : intervalList) {
                    names.add(interval.getName());
                    Comparable intervalMin = (Comparable)interval.getMinValue();
                    Comparable intervalMax = (Comparable)interval.getMaxValue();
                    if (intervalMin != null) {
                        if (min == null) {
                            min = intervalMin;
                        } else if (min.compareTo(intervalMin) > 0) {
                            min = intervalMin;
                        }
                    }
                    if (intervalMax == null) continue;
                    if (max == null) {
                        max = intervalMax;
                        continue;
                    }
                    if (max.compareTo(intervalMax) <= 0) continue;
                    max = intervalMax;
                }
                if (min != null && max != null && min.compareTo(max) > 0) {
                    min = max;
                }
                ColumnFilter filter = null;
                filter = min != null && max != null ? FilterFactory.between((String)cg.getSourceId(), (Comparable)min, max) : (min != null ? FilterFactory.greaterOrEqualsTo((String)cg.getSourceId(), (Comparable)min) : (max != null ? FilterFactory.lowerOrEqualsTo((String)cg.getSourceId(), max) : FilterFactory.equalsTo((String)cg.getSourceId(), names)));
                SQLDataSetProvider.this._appendFilterBy(this.def, filter, _query);
            }
        }

        protected void _appendGroupBy(DataSetGroup groupOp) {
            ColumnGroup cg = groupOp.getColumnGroup();
            String sourceId = cg.getSourceId();
            ColumnType columnType = this.metadata.getColumnType(this._assertColumnExists(sourceId));
            boolean postProcessing = false;
            if (ColumnType.NUMBER.equals((Object)columnType)) {
                throw new IllegalArgumentException("Group by number '" + sourceId + "' not supported");
            }
            if (ColumnType.TEXT.equals((Object)columnType)) {
                throw new IllegalArgumentException("Group by text '" + sourceId + "' not supported");
            }
            if (ColumnType.DATE.equals((Object)columnType)) {
                this._query.groupBy(this._createColumn(cg));
                postProcessing = true;
            } else {
                this._query.groupBy(SQLFactory.column(sourceId));
                for (GroupFunction gf : groupOp.getGroupFunctions()) {
                    if (sourceId.equals(gf.getSourceId()) || gf.getFunction() != null) continue;
                    postProcessing = true;
                }
            }
            for (GroupFunction gf : groupOp.getGroupFunctions()) {
                if (gf.getFunction() != null || gf.getSourceId().equals(cg.getSourceId())) continue;
                this._query.groupBy(SQLFactory.column(gf.getSourceId()));
            }
            if (postProcessing) {
                GroupFunction gf;
                DataSetGroup postGroup = groupOp.cloneInstance();
                gf = postGroup.getGroupFunction(sourceId);
                if (gf != null) {
                    String targetId = this._getTargetColumnId(gf);
                    postGroup.getColumnGroup().setSourceId(targetId);
                    postGroup.getColumnGroup().setColumnId(targetId);
                }
                for (GroupFunction pgf : postGroup.getGroupFunctions()) {
                    AggregateFunctionType pft = pgf.getFunction();
                    pgf.setSourceId(this._getTargetColumnId(pgf));
                    if (pft == null || !AggregateFunctionType.DISTINCT.equals((Object)pft) && !AggregateFunctionType.COUNT.equals((Object)pft)) continue;
                    pgf.setFunction(AggregateFunctionType.SUM);
                }
                this.postProcessingOps.add((DataSetOp)postGroup);
            }
        }

        protected DataSet _buildDataSet(List<DataColumn> columns, ResultSet _rs) throws Exception {
            IntervalBuilder intervalBuilder;
            IntervalList intervalList;
            String value;
            int i;
            DataSet dataSet = DataSetFactory.newEmptyDataSet();
            dataSet.setUUID(this.def.getUUID());
            dataSet.setDefinition((DataSetDef)this.def);
            DataColumn dateGroupColumn = null;
            boolean dateIncludeEmptyIntervals = false;
            for (i = 0; i < columns.size(); ++i) {
                DataColumn column = columns.get(i).cloneEmpty();
                dataSet.addColumn(column);
            }
            if (this._query.isOffsetPostProcessing() && this._query.getOffset() > 0) {
                for (i = 0; i < this._query.getOffset() && _rs.next(); ++i) {
                }
            }
            int rowIdx = 0;
            int numRows = this._query.getLimit();
            while (_rs.next() && (numRows < 0 || rowIdx++ < numRows)) {
                for (int i2 = 0; i2 < columns.size(); ++i2) {
                    DataColumn column = dataSet.getColumnByIndex(i2);
                    column.getValues().add(_rs.getObject(i2 + 1));
                }
            }
            Dialect dialect = JDBCUtils.dialect(this.conn);
            for (DataColumn column : dataSet.getColumns()) {
                ColumnType columnType = column.getColumnType();
                List values = column.getValues();
                if (ColumnType.LABEL.equals((Object)columnType)) {
                    int j;
                    ColumnGroup cg = column.getColumnGroup();
                    if (cg != null && ColumnType.DATE.equals((Object)this.metadata.getColumnType(cg.getSourceId()))) {
                        dateGroupColumn = column;
                        dateIncludeEmptyIntervals = cg.areEmptyIntervalsAllowed();
                        column.setColumnType(ColumnType.DATE);
                        for (j = 0; j < values.size(); ++j) {
                            Object val = values.remove(j);
                            java.util.Date dateObj = DateUtils.parseDate((DataColumn)column, val);
                            values.add(j, dateObj);
                        }
                    } else {
                        for (j = 0; j < values.size(); ++j) {
                            value = dialect.convertToString(values.remove(j));
                            values.add(j, value);
                        }
                    }
                } else if (ColumnType.NUMBER.equals((Object)columnType)) {
                    for (int j = 0; j < values.size(); ++j) {
                        Double value2 = dialect.convertToDouble(values.remove(j));
                        values.add(j, value2);
                    }
                } else if (ColumnType.DATE.equals((Object)columnType)) {
                    for (int j = 0; j < values.size(); ++j) {
                        java.util.Date value3 = dialect.convertToDate(values.remove(j));
                        values.add(j, value3);
                    }
                } else {
                    for (int j = 0; j < values.size(); ++j) {
                        String value4 = dialect.convertToString(values.remove(j));
                        values.add(j, value4);
                    }
                }
                column.setValues(values);
            }
            if (!this.postProcessingOps.isEmpty()) {
                DataSet tempSet = SQLDataSetProvider.this.opEngine.execute(dataSet, this.postProcessingOps);
                dataSet = dataSet.cloneEmpty();
                dataSet.setUUID(this.def.getUUID());
                dataSet.setDefinition((DataSetDef)this.def);
                for (int i3 = 0; i3 < columns.size(); ++i3) {
                    DataColumn source = tempSet.getColumnByIndex(i3);
                    DataColumn target = dataSet.getColumnByIndex(i3);
                    target.setColumnType(source.getColumnType());
                    target.setIntervalType(source.getIntervalType());
                    target.setMinValue(target.getMinValue());
                    target.setMaxValue(target.getMaxValue());
                    target.setValues(new ArrayList(source.getValues()));
                }
            }
            if (dateIncludeEmptyIntervals && (intervalList = (intervalBuilder = SQLDataSetProvider.this.intervalBuilderLocator.lookup(ColumnType.DATE, dateGroupColumn.getColumnGroup().getStrategy())).build(dateGroupColumn)).size() > dataSet.getRowCount()) {
                List values = dateGroupColumn.getValues();
                int valueIdx = 0;
                for (int intervalIdx = 0; intervalIdx < intervalList.size(); ++intervalIdx) {
                    String interval = ((Interval)intervalList.get(intervalIdx)).getName();
                    String string = value = values.isEmpty() ? null : (String)values.get(valueIdx++);
                    if (value != null && value.equals(interval)) continue;
                    dataSet.addEmptyRowAt(intervalIdx);
                    dateGroupColumn.getValues().set(intervalIdx, interval);
                }
            }
            return dataSet;
        }

        protected Collection<Column> _createAllColumns() {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
                String columnId = this.metadata.getColumnId(i);
                columns.add(SQLFactory.column(columnId));
            }
            return columns;
        }

        protected Collection<Column> _createColumns(DataSetGroup gOp) {
            if (gOp == null) {
                return this._createAllColumns();
            }
            ColumnGroup cg = gOp.getColumnGroup();
            ArrayList<Column> _columns = new ArrayList<Column>();
            for (GroupFunction gf : gOp.getGroupFunctions()) {
                String sourceId = gf.getSourceId();
                if (StringUtils.isBlank((CharSequence)sourceId)) {
                    sourceId = this.metadata.getColumnId(0);
                } else {
                    this._assertColumnExists(sourceId);
                }
                String targetId = gf.getColumnId();
                if (StringUtils.isBlank((CharSequence)targetId)) {
                    targetId = sourceId;
                }
                if (cg != null && cg.getSourceId().equals(sourceId) && gf.getFunction() == null) {
                    _columns.add(this._createColumn(cg).as(targetId));
                    continue;
                }
                _columns.add(this._createColumn(gf).as(targetId));
            }
            return _columns;
        }

        protected Column _createColumn(GroupFunction gf) {
            String sourceId = gf.getSourceId();
            if (sourceId == null) {
                sourceId = this.metadata.getColumnId(0);
            }
            AggregateFunctionType ft = gf.getFunction();
            return SQLFactory.column(sourceId).function(ft);
        }

        protected Column _createColumn(ColumnGroup cg) {
            String columnId = cg.getSourceId();
            this._assertColumnExists(columnId);
            ColumnType type = this.metadata.getColumnType(columnId);
            if (ColumnType.DATE.equals((Object)type)) {
                DateIntervalType size = this.calculateDateInterval(cg);
                return SQLFactory.column(cg.getSourceId(), cg.getStrategy(), size);
            }
            if (ColumnType.NUMBER.equals((Object)type)) {
                throw new IllegalArgumentException("Group by number '" + columnId + "' not supported");
            }
            if (ColumnType.TEXT.equals((Object)type)) {
                throw new IllegalArgumentException("Group by text '" + columnId + "' not supported");
            }
            return SQLFactory.column(columnId);
        }

        protected int _assertColumnExists(String columnId) {
            for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
                if (!this.metadata.getColumnId(i).equalsIgnoreCase(columnId)) continue;
                return i;
            }
            throw new RuntimeException("Column '" + columnId + "' not found in data set: " + this.metadata.getUUID());
        }

        protected String _getTargetColumnId(GroupFunction gf) {
            String sourceId = gf.getSourceId();
            if (sourceId != null) {
                this._assertColumnExists(sourceId);
            }
            return gf.getColumnId() == null ? sourceId : gf.getColumnId();
        }
    }

    protected class MetadataHolder {
        DataSetMetadata metadata;
        Collection<Column> columns;

        protected MetadataHolder() {
        }

        public Column getColumn(String name) {
            for (Column column : this.columns) {
                if (!column.getName().equals(name)) continue;
                return column;
            }
            return null;
        }
    }
}

