/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.dialect;

import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataprovider.sql.dialect.DefaultDialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.DynamicDateColumn;
import org.dashbuilder.dataset.group.DateIntervalType;

public class MySQLDialect
extends DefaultDialect {
    public static final String PATTERN_YEAR = "%Y";
    public static final String PATTERN_MONTH = "%Y-%m";
    public static final String PATTERN_DAY = "%Y-%m-%d";
    public static final String PATTERN_HOUR = "%Y-%m-%d %H";
    public static final String PATTERN_MINUTE = "%Y-%m-%d %H:%i";
    public static final String PATTERN_SECOND = "%Y-%m-%d %H:%i:%s";
    private static Map<DateIntervalType, String> datePatternMap = new HashMap<DateIntervalType, String>();

    @Override
    public boolean allowAliasInStatements() {
        return true;
    }

    @Override
    public String getAliasForColumnSQL(String alias) {
        return "AS `" + alias + "`";
    }

    @Override
    public String getAliasForStatementSQL(String alias) {
        return "`" + alias + "`";
    }

    @Override
    public String getConcatFunctionSQL(Column[] columns) {
        return super.getConcatFunctionSQL(columns, "CONCAT(", ")", ",");
    }

    @Override
    public String getColumnCastSQL(Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "CAST(" + columnSQL + " AS CHAR)";
    }

    @Override
    public String getDynamicDateColumnSQL(DynamicDateColumn column) {
        DateIntervalType type = column.getDateType();
        if (!datePatternMap.containsKey(type)) {
            throw new IllegalArgumentException("Group '" + column.getName() + "' by the given date interval type is not supported: " + type);
        }
        String datePattern = datePatternMap.get(type);
        String columnName = this.getColumnNameSQL(column.getName());
        return "DATE_FORMAT(" + columnName + ", '" + datePattern + "')";
    }

    static {
        datePatternMap.put(DateIntervalType.SECOND, PATTERN_SECOND);
        datePatternMap.put(DateIntervalType.MINUTE, PATTERN_MINUTE);
        datePatternMap.put(DateIntervalType.HOUR, PATTERN_HOUR);
        datePatternMap.put(DateIntervalType.DAY, PATTERN_DAY);
        datePatternMap.put(DateIntervalType.WEEK, PATTERN_DAY);
        datePatternMap.put(DateIntervalType.MONTH, PATTERN_MONTH);
        datePatternMap.put(DateIntervalType.QUARTER, PATTERN_MONTH);
        datePatternMap.put(DateIntervalType.YEAR, PATTERN_YEAR);
        datePatternMap.put(DateIntervalType.DECADE, PATTERN_YEAR);
        datePatternMap.put(DateIntervalType.CENTURY, PATTERN_YEAR);
        datePatternMap.put(DateIntervalType.MILLENIUM, PATTERN_YEAR);
    }
}

