/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Condition;
import org.dashbuilder.dataprovider.sql.model.CoreCondition;
import org.dashbuilder.dataprovider.sql.model.SQLStatement;
import org.dashbuilder.dataprovider.sql.model.SortColumn;
import org.dashbuilder.dataprovider.sql.model.Table;

public class Select
extends SQLStatement<Select> {
    protected List<Column> columns = new ArrayList<Column>();
    protected String fromSelect = null;
    protected List<Condition> wheres = new ArrayList<Condition>();
    protected List<Column> groupBys = new ArrayList<Column>();
    protected List<SortColumn> orderBys = new ArrayList<SortColumn>();
    protected int limit = -1;
    protected int offset = -1;
    protected boolean offsetPostProcessing = false;

    public Select(Connection connection, Dialect dialect) {
        super(connection, dialect);
    }

    public boolean isOffsetPostProcessing() {
        return this.offsetPostProcessing;
    }

    public void setOffsetPostProcessing(boolean offsetPostProcessing) {
        this.offsetPostProcessing = offsetPostProcessing;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String getFromSelect() {
        return this.fromSelect;
    }

    public Table getFromTable() {
        return super.getTable();
    }

    public List<Condition> getWheres() {
        return this.wheres;
    }

    public List<Column> getGroupBys() {
        return this.groupBys;
    }

    public List<SortColumn> getOrderBys() {
        return this.orderBys;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public Select columns(Column ... cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public Select columns(Collection<Column> cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public Select from(String sql) {
        this.fromSelect = this.fix(sql);
        return this;
    }

    public Select from(Table table) {
        return (Select)super.table(table);
    }

    public Select where(Condition condition) {
        if (condition != null) {
            if (condition instanceof CoreCondition) {
                this.fix(((CoreCondition)condition).getColumn());
            }
            this.wheres.add(condition);
        }
        return this;
    }

    public Select groupBy(Column column) {
        if (column != null) {
            this.groupBys.add(this.fix(column));
        }
        return this;
    }

    public Select orderBy(SortColumn ... columns) {
        for (SortColumn column : columns) {
            this.fix(column.getSource());
            this.orderBys.add(column);
        }
        return this;
    }

    public Select orderBy(List<SortColumn> columns) {
        for (SortColumn column : columns) {
            this.fix(column.getSource());
            this.orderBys.add(column);
        }
        return this;
    }

    public Select limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Select offset(int offset) {
        this.offset = offset;
        return this;
    }

    public String getSQL() {
        return this.dialect.getSQL(this);
    }

    public String toString() {
        return this.getSQL();
    }

    public int fetchCount() throws SQLException {
        String countSql = this.dialect.getCountQuerySQL(this);
        ResultSet _rs = JDBCUtils.executeQuery(this.connection, countSql);
        if (_rs.next()) {
            return _rs.getInt(1);
        }
        return 0;
    }

    public ResultSet fetch() throws SQLException {
        String sql = this.getSQL();
        return JDBCUtils.executeQuery(this.connection, sql);
    }
}

