/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.RuleComponent;
import org.drools.core.util.Bag;
import org.kie.api.definition.rule.Rule;

public abstract class BaseNode
implements NetworkNode {
    protected int id;
    protected RuleBasePartitionId partitionId;
    protected boolean partitionsEnabled;
    protected Bag<Rule> associations;
    private boolean streamMode;

    public BaseNode() {
    }

    public BaseNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this.id = id;
        this.partitionId = partitionId;
        this.partitionsEnabled = partitionsEnabled;
        this.associations = new Bag();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.partitionId = (RuleBasePartitionId)in.readObject();
        this.partitionsEnabled = in.readBoolean();
        this.associations = (Bag)in.readObject();
        this.streamMode = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.partitionId);
        out.writeBoolean(this.partitionsEnabled);
        out.writeObject(this.associations);
        out.writeBoolean(this.streamMode);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    protected void setStreamMode(boolean streamMode) {
        this.streamMode = streamMode;
    }

    public abstract void attach(BuildContext var1);

    public abstract void networkUpdated(UpdateContext var1);

    public boolean remove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        boolean removed = this.doRemove(context, builder, workingMemories);
        if (!this.isInUse() && !(this instanceof EntryPointNode)) {
            builder.getIdGenerator().releaseId(this.getId());
        }
        return removed;
    }

    protected abstract boolean doRemove(RuleRemovalContext var1, ReteooBuilder var2, InternalWorkingMemory[] var3);

    public abstract boolean isInUse();

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ")]";
    }

    @Override
    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public void addAssociation(Rule rule) {
        this.associations.add(rule);
    }

    public void addAssociation(Rule rule, RuleComponent ruleComponent) {
        this.addAssociation(rule);
    }

    public boolean removeAssociation(Rule rule) {
        return this.associations.removeKey(rule);
    }

    @Override
    public int getAssociationsSize() {
        return this.associations.size();
    }

    @Override
    public int getAssociatedRuleSize() {
        return this.associations.getKeySize();
    }

    @Override
    public int getAssociationsSize(Rule rule) {
        return this.associations.sizeFor(rule);
    }

    @Override
    public boolean isAssociatedWith(Rule rule) {
        return this.associations.contains(rule);
    }
}

