/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.dashbuilder.scheduler.Scheduler;
import org.dashbuilder.scheduler.SchedulerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetDefRegistryImpl
implements DataSetDefRegistry {
    protected Logger log = LoggerFactory.getLogger(DataSetDefRegistryImpl.class);
    protected DataSetProviderRegistry dataSetProviderRegistry;
    protected Scheduler scheduler;
    protected Map<String, DataSetDefEntry> dataSetDefMap = new HashMap<String, DataSetDefEntry>();
    protected Set<DataSetDefRegistryListener> listenerSet = new HashSet<DataSetDefRegistryListener>();

    public DataSetDefRegistryImpl() {
    }

    public DataSetDefRegistryImpl(DataSetProviderRegistry dataSetProviderRegistry, Scheduler scheduler) {
        this.dataSetProviderRegistry = dataSetProviderRegistry;
        this.scheduler = scheduler;
        if (scheduler == null) {
            this.log.warn("No scheduler set. Data set refresh features are disabled.");
        }
    }

    public DataSetProviderRegistry getDataSetProviderRegistry() {
        return this.dataSetProviderRegistry;
    }

    public void setDataSetProviderRegistry(DataSetProviderRegistry dataSetProviderRegistry) {
        this.dataSetProviderRegistry = dataSetProviderRegistry;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected DataSetProvider resolveProvider(DataSetDef dataSetDef) {
        DataSetProvider dataSetProvider;
        DataSetProviderType type = dataSetDef.getProvider();
        if (type != null && (dataSetProvider = this.dataSetProviderRegistry.getDataSetProvider(type)) != null) {
            return dataSetProvider;
        }
        throw new IllegalStateException("DataSetProvider not found: " + dataSetDef.getProvider());
    }

    public synchronized List<DataSetDef> getDataSetDefs(boolean onlyPublic) {
        ArrayList<DataSetDef> results = new ArrayList<DataSetDef>();
        for (DataSetDefEntry r : this.dataSetDefMap.values()) {
            if (onlyPublic && !r.def.isPublic()) continue;
            results.add(r.def);
        }
        return results;
    }

    public synchronized DataSetDef getDataSetDef(String uuid) {
        DataSetDefEntry record = this.dataSetDefMap.get(uuid);
        if (record == null) {
            return null;
        }
        return record.def;
    }

    public synchronized void registerPreprocessor(String uuid, DataSetPreprocessor preprocessor) {
        DataSetDefEntry record = this.dataSetDefMap.get(uuid);
        if (record == null) {
            throw new IllegalStateException("DataSetDef not found: " + uuid);
        }
        record.registerDataSetPreprocessor(preprocessor);
    }

    public synchronized List<DataSetPreprocessor> getDataSetDefPreProcessors(String uuid) {
        DataSetDefEntry record = this.dataSetDefMap.get(uuid);
        if (record == null) {
            return null;
        }
        return record.getDataSetPreprocessors();
    }

    public synchronized void registerDataSetDef(DataSetDef newDef) {
        this.registerDataSetDef(newDef, "system", "register(" + newDef.getUUID() + ")");
    }

    public synchronized DataSetDef removeDataSetDef(String uuid) {
        return this.removeDataSetDef(uuid, "system", "remove(" + uuid + ")");
    }

    public synchronized void registerDataSetDef(DataSetDef newDef, String subjectId, String message) {
        DataSetDefEntry oldEntry = this._removeDataSetDef(newDef.getUUID());
        this.dataSetDefMap.put(newDef.getUUID(), new DataSetDefEntry(newDef));
        DataSetDefEntry newEntry = this.dataSetDefMap.get(newDef.getUUID());
        if (oldEntry != null) {
            this.onDataSetDefModified(oldEntry.def, newDef);
        } else {
            this.onDataSetDefRegistered(newDef);
        }
        newEntry.schedule();
    }

    public synchronized DataSetDef removeDataSetDef(String uuid, String subjectId, String message) {
        DataSetDefEntry oldEntry = this._removeDataSetDef(uuid);
        if (oldEntry == null) {
            return null;
        }
        this.onDataSetDefRemoved(oldEntry.def);
        return oldEntry.def;
    }

    protected DataSetDefEntry _removeDataSetDef(String uuid) {
        DataSetDefEntry oldEntry = this.dataSetDefMap.remove(uuid);
        if (oldEntry == null) {
            return null;
        }
        oldEntry.unschedule();
        oldEntry.stale();
        return oldEntry;
    }

    public void addListener(DataSetDefRegistryListener listener) {
        this.listenerSet.add(listener);
    }

    protected void onDataSetDefStale(DataSetDef def) {
        for (DataSetDefRegistryListener listener : this.listenerSet) {
            listener.onDataSetDefStale(def);
        }
    }

    protected void onDataSetDefModified(DataSetDef olDef, DataSetDef newDef) {
        for (DataSetDefRegistryListener listener : this.listenerSet) {
            listener.onDataSetDefModified(olDef, newDef);
        }
    }

    protected void onDataSetDefRegistered(DataSetDef newDef) {
        for (DataSetDefRegistryListener listener : this.listenerSet) {
            listener.onDataSetDefRegistered(newDef);
        }
    }

    protected void onDataSetDefRemoved(DataSetDef oldDef) {
        for (DataSetDefRegistryListener listener : this.listenerSet) {
            listener.onDataSetDefRemoved(oldDef);
        }
    }

    protected class DataSetDefEntry
    extends SchedulerTask {
        DataSetDef def;
        long lastRefreshTime;
        long refreshInMillis;
        List<DataSetPreprocessor> preprocessors;

        public DataSetDefEntry(DataSetDef def) {
            this.def = def;
            this.lastRefreshTime = System.currentTimeMillis();
            this.refreshInMillis = -1L;
            if (def.getRefreshTime() != null && def.getRefreshTime().trim().length() > 0) {
                TimeAmount tf = TimeAmount.parse((String)def.getRefreshTime());
                this.refreshInMillis = tf.toMillis();
            }
        }

        public void registerDataSetPreprocessor(DataSetPreprocessor preprocessor) {
            if (this.preprocessors == null) {
                this.preprocessors = new ArrayList<DataSetPreprocessor>();
            }
            this.preprocessors.add(preprocessor);
        }

        public List<DataSetPreprocessor> getDataSetPreprocessors() {
            return this.preprocessors;
        }

        public void schedule() {
            if (this.refreshInMillis != -1L && DataSetDefRegistryImpl.this.scheduler != null) {
                DataSetDefRegistryImpl.this.scheduler.schedule((SchedulerTask)this, this.refreshInMillis / 1000L);
            }
        }

        public void unschedule() {
            if (DataSetDefRegistryImpl.this.scheduler != null) {
                DataSetDefRegistryImpl.this.scheduler.unschedule(this.getKey());
            }
        }

        public boolean isStale() {
            if (this.refreshInMillis == -1L) {
                return false;
            }
            if (!this.def.isRefreshAlways()) {
                DataSetProvider provider = DataSetDefRegistryImpl.this.resolveProvider(this.def);
                return provider.isDataSetOutdated(this.def);
            }
            return System.currentTimeMillis() >= this.lastRefreshTime + this.refreshInMillis;
        }

        public void stale() {
            this.lastRefreshTime = System.currentTimeMillis();
            DataSetDefRegistryImpl.this.onDataSetDefStale(this.def);
        }

        @Override
        public String getDescription() {
            return "DataSetDef refresh task " + this.def.getUUID();
        }

        @Override
        public String getKey() {
            return this.def.getUUID();
        }

        @Override
        public void execute() {
            if (this.isStale()) {
                this.stale();
            }
        }
    }
}

