/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.EntityMode;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbAnyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbComponentElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToManyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbManyToOneElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbOneToManyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbOneToOneElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbPropertyElement;
import org.hibernate.internal.jaxb.mapping.hbm.JaxbTuplizerElement;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.PropertyAttributeSourceImpl;

public class ComponentAttributeSourceImpl
implements ComponentAttributeSource {
    private final JaxbComponentElement componentElement;
    private final AttributeSourceContainer parentContainer;
    private final ValueHolder<Class<?>> componentClassReference;
    private final String path;

    public ComponentAttributeSourceImpl(JaxbComponentElement componentElement, AttributeSourceContainer parentContainer, LocalBindingContext bindingContext) {
        this.componentElement = componentElement;
        this.parentContainer = parentContainer;
        this.componentClassReference = bindingContext.makeClassReference(bindingContext.qualifyClassName(componentElement.getClazz()));
        this.path = parentContainer.getPath() + '.' + componentElement.getName();
    }

    @Override
    public String getClassName() {
        return this.componentElement.getClazz();
    }

    @Override
    public ValueHolder<Class<?>> getClassReference() {
        return this.componentClassReference;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.parentContainer.getLocalBindingContext();
    }

    @Override
    public String getParentReferenceAttributeName() {
        return this.componentElement.getParent() == null ? null : this.componentElement.getParent().getName();
    }

    @Override
    public String getExplicitTuplizerClassName() {
        if (this.componentElement.getTuplizer() == null) {
            return null;
        }
        EntityMode entityMode = StringHelper.isEmpty(this.componentElement.getClazz()) ? EntityMode.MAP : EntityMode.POJO;
        for (JaxbTuplizerElement tuplizerElement : this.componentElement.getTuplizer()) {
            if (entityMode != EntityMode.parse(tuplizerElement.getEntityMode())) continue;
            return tuplizerElement.getClazz();
        }
        return null;
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
        for (Object attributeElement : this.componentElement.getPropertyOrManyToOneOrOneToOne()) {
            if (JaxbPropertyElement.class.isInstance(attributeElement)) {
                attributeSources.add(new PropertyAttributeSourceImpl((JaxbPropertyElement)JaxbPropertyElement.class.cast(attributeElement), this.getLocalBindingContext()));
                continue;
            }
            if (JaxbComponentElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ComponentAttributeSourceImpl((JaxbComponentElement)attributeElement, this, this.getLocalBindingContext()));
                continue;
            }
            if (JaxbManyToOneElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ManyToOneAttributeSourceImpl((JaxbManyToOneElement)JaxbManyToOneElement.class.cast(attributeElement), this.getLocalBindingContext()));
                continue;
            }
            if (!JaxbOneToOneElement.class.isInstance(attributeElement) && !JaxbAnyElement.class.isInstance(attributeElement) && !JaxbOneToManyElement.class.isInstance(attributeElement) && !JaxbManyToManyElement.class.isInstance(attributeElement)) continue;
        }
        return attributeSources;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.COMPONENT;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return null;
    }

    @Override
    public String getName() {
        return this.componentElement.getName();
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.componentElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.componentElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.componentElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }

    @Override
    public boolean isLazy() {
        return this.componentElement.isLazy();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.componentElement.isOptimisticLock();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.componentElement.getMeta());
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.isInsertable();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.isUpdatable();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return null;
    }
}

