/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transports.http.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;

@NoJSR250Annotations(unlessNull={"bus"})
public class QueryHandlerRegistryImpl
implements QueryHandlerRegistry {
    List<QueryHandler> queryHandlers;
    Bus bus;

    public QueryHandlerRegistryImpl() {
    }

    public QueryHandlerRegistryImpl(Bus b) {
        this.setBus(b);
    }

    public QueryHandlerRegistryImpl(Bus b, List<QueryHandler> handlers) {
        this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>(handlers);
        this.setBus(b);
    }

    public void setQueryHandlers(List<QueryHandler> handlers) {
        this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>(handlers);
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public final void setBus(Bus b) {
        this.bus = b;
        if (this.queryHandlers == null) {
            this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>();
        }
        if (null != this.bus) {
            this.bus.setExtension((Object)this, QueryHandlerRegistry.class);
            ConfiguredBeanLocator c = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class);
            if (c != null) {
                for (QueryHandler handler : c.getBeansOfType(QueryHandler.class)) {
                    if (this.queryHandlers.contains(handler)) continue;
                    this.queryHandlers.add(handler);
                }
            }
        }
    }

    public List<QueryHandler> getHandlers() {
        return this.queryHandlers;
    }

    public void registerHandler(QueryHandler handler) {
        this.queryHandlers.add(handler);
    }

    public void registerHandler(QueryHandler handler, int position) {
        this.queryHandlers.add(position, handler);
    }
}

