/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.commons.jci.problems.CompilationProblem;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.kie.api.io.Resource;

public class DescrBuildError
extends DroolsError {
    private BaseDescr parentDescr;
    private BaseDescr descr;
    private Object object;
    private String message;
    private int[] errorLines = new int[1];

    public DescrBuildError(BaseDescr parentDescr, BaseDescr descr, Object object, String message) {
        super((Resource)(descr.getResource() != null ? descr.getResource() : (parentDescr != null ? parentDescr.getResource() : null)));
        this.parentDescr = parentDescr;
        this.descr = descr;
        this.object = object;
        this.message = message;
        this.errorLines[0] = this.getLine();
    }

    @Override
    public String getNamespace() {
        return this.parentDescr != null ? this.parentDescr.getNamespace() : this.descr.getNamespace();
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public BaseDescr getDescr() {
        return this.descr;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public int[] getLines() {
        return this.errorLines;
    }

    public int getLine() {
        return this.descr != null ? this.descr.getLine() : -1;
    }

    public int getColumn() {
        return this.descr != null ? this.descr.getColumn() : -1;
    }

    @Override
    public String getMessage() {
        String summary = this.message;
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            for (int i = 0; i < problem.length; ++i) {
                summary = i != 0 ? summary + "\n" + problem[i].getMessage() : summary + " " + problem[i].getMessage();
            }
        }
        return summary;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.message);
        buf.append(" : ");
        buf.append(this.parentDescr);
        buf.append("\n");
        if (this.object instanceof CompilationProblem[]) {
            CompilationProblem[] problem = (CompilationProblem[])this.object;
            for (int i = 0; i < problem.length; ++i) {
                buf.append("\t");
                buf.append(problem[i]);
                buf.append("\n");
            }
        } else if (this.object != null) {
            buf.append(this.object);
        }
        return buf.toString();
    }
}

