/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.query.AbstractAuditQueryBuilderImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskEventQueryBuilder;

public class TaskEventQueryBuilderImpl
extends AbstractAuditQueryBuilderImpl<TaskEventQueryBuilder, TaskEvent>
implements TaskEventQueryBuilder {
    public TaskEventQueryBuilderImpl(CommandExecutor cmdService) {
        super(cmdService);
    }

    public TaskEventQueryBuilderImpl(JPAAuditLogService jpaAuditService) {
        super(jpaAuditService);
    }

    public TaskEventQueryBuilder message(String ... name) {
        this.addObjectParameter(QueryParameterIdentifiers.MESSAGE_LIST, "message", name);
        return this;
    }

    public TaskEventQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public TaskEventQueryBuilder taskIdRange(Long taskIdMin, Long taskIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ID_LIST, "task id range", taskIdMin, taskIdMax);
        return this;
    }

    public TaskEventQueryBuilder id(long ... id) {
        this.addLongParameter(QueryParameterIdentifiers.ID_LIST, "task id", id);
        return this;
    }

    public TaskEventQueryBuilder logTime(Date ... logTime) {
        this.addObjectParameter(QueryParameterIdentifiers.DATE_LIST, "log time", logTime);
        return this;
    }

    public TaskEventQueryBuilder logTimeRange(Date logTimeMin, Date logTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.DATE_LIST, "log time range", logTimeMin, logTimeMax);
        return this;
    }

    public TaskEventQueryBuilder userId(String ... userId) {
        this.addObjectParameter(QueryParameterIdentifiers.USER_ID_LIST, "user id", userId);
        return this;
    }

    public TaskEventQueryBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public TaskEventQueryBuilder type(TaskEvent.TaskEventType ... taskEventType) {
        this.addObjectParameter(QueryParameterIdentifiers.TYPE_LIST, "task event type", taskEventType);
        return this;
    }

    public TaskEventQueryBuilder ascending(TaskEventQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public TaskEventQueryBuilder descending(TaskEventQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String convertOrderByToListId(TaskEventQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case taskId: {
                listId = QueryParameterIdentifiers.TASK_ID_LIST;
                break;
            }
            case logTime: {
                listId = QueryParameterIdentifiers.DATE_LIST;
            }
            case processInstanceId: {
                listId = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    protected Class<TaskEvent> getResultType() {
        return TaskEvent.class;
    }

    protected Class<TaskEventImpl> getQueryType() {
        return TaskEventImpl.class;
    }
}

