/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.kie.internal.runtime.conf.BuilderHandler;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;

public class DeploymentDescriptorMerger {
    public DeploymentDescriptor merge(List<DeploymentDescriptor> descriptorHierarchy, MergeMode mode) {
        if (descriptorHierarchy == null || descriptorHierarchy.isEmpty()) {
            throw new IllegalArgumentException("Descriptor hierarchy list cannot be empty");
        }
        if (descriptorHierarchy.size() == 1) {
            return descriptorHierarchy.get(0);
        }
        Stack<DeploymentDescriptor> stack = new Stack<DeploymentDescriptor>();
        stack.addAll(descriptorHierarchy);
        if (mode == null) {
            mode = MergeMode.MERGE_COLLECTIONS;
        }
        while (stack.size() > 1) {
            DeploymentDescriptor master = (DeploymentDescriptor)stack.pop();
            DeploymentDescriptor slave = (DeploymentDescriptor)stack.pop();
            DeploymentDescriptor desc = this.merge(master, slave, mode);
            stack.push(desc);
        }
        return (DeploymentDescriptor)stack.pop();
    }

    public DeploymentDescriptor merge(DeploymentDescriptor master, DeploymentDescriptor slave, MergeMode mode) {
        if (master == null || slave == null) {
            throw new IllegalArgumentException("Descriptors to merge must be provided");
        }
        DeploymentDescriptor merged = null;
        DeploymentDescriptorBuilder builder = master.getBuilder();
        builder.setBuildHandler((BuilderHandler)new MergeModeBuildHandler(mode));
        switch (mode) {
            case KEEP_ALL: {
                merged = master;
                break;
            }
            case OVERRIDE_ALL: {
                merged = slave;
                break;
            }
            case OVERRIDE_EMPTY: {
                builder.auditMode(slave.getAuditMode());
                builder.auditPersistenceUnit(slave.getAuditPersistenceUnit());
                builder.persistenceMode(slave.getPersistenceMode());
                builder.persistenceUnit(slave.getPersistenceUnit());
                builder.runtimeStrategy(slave.getRuntimeStrategy());
                builder.setConfiguration(slave.getConfiguration());
                builder.setEnvironmentEntries(slave.getEnvironmentEntries());
                builder.setEventListeners(slave.getEventListeners());
                builder.setGlobals(slave.getGlobals());
                builder.setMarshalingStrategies(slave.getMarshallingStrategies());
                builder.setTaskEventListeners(slave.getTaskEventListeners());
                builder.setWorkItemHandlers(slave.getWorkItemHandlers());
                builder.setRequiredRoles(slave.getRequiredRoles());
                builder.setClasses(slave.getClasses());
                builder.setLimitSerializationClasses(slave.getLimitSerializationClasses());
                merged = builder.get();
                break;
            }
            case MERGE_COLLECTIONS: {
                builder.auditMode(slave.getAuditMode());
                builder.auditPersistenceUnit(slave.getAuditPersistenceUnit());
                builder.persistenceMode(slave.getPersistenceMode());
                builder.persistenceUnit(slave.getPersistenceUnit());
                builder.runtimeStrategy(slave.getRuntimeStrategy());
                for (ObjectModel model : slave.getEventListeners()) {
                    builder.addEventListener(model);
                }
                for (ObjectModel model : slave.getMarshallingStrategies()) {
                    builder.addMarshalingStrategy(model);
                }
                for (ObjectModel model : slave.getTaskEventListeners()) {
                    builder.addTaskEventListener(model);
                }
                for (ObjectModel model : slave.getConfiguration()) {
                    builder.addConfiguration((NamedObjectModel)model);
                }
                for (ObjectModel model : slave.getEnvironmentEntries()) {
                    builder.addEnvironmentEntry((NamedObjectModel)model);
                }
                for (ObjectModel model : slave.getGlobals()) {
                    builder.addGlobal((NamedObjectModel)model);
                }
                for (ObjectModel model : slave.getWorkItemHandlers()) {
                    builder.addWorkItemHandler((NamedObjectModel)model);
                }
                for (String requiredRole : slave.getRequiredRoles()) {
                    builder.addRequiredRole(requiredRole);
                }
                for (String clazz : slave.getClasses()) {
                    builder.addClass(clazz);
                }
                Boolean slaveLimit = slave.getLimitSerializationClasses();
                Boolean masterLimit = master.getLimitSerializationClasses();
                if (slaveLimit != null && masterLimit != null && (slaveLimit.booleanValue() || masterLimit.booleanValue())) {
                    builder.setLimitSerializationClasses(Boolean.valueOf(true));
                }
                merged = builder.get();
                break;
            }
        }
        return merged;
    }

    private class MergeModeBuildHandler
    implements BuilderHandler {
        private MergeMode mode;

        MergeModeBuildHandler(MergeMode mode) {
            this.mode = mode;
        }

        public boolean accepted(Object value) {
            boolean accepted = false;
            switch (this.mode) {
                case OVERRIDE_ALL: {
                    accepted = true;
                    break;
                }
                case OVERRIDE_EMPTY: {
                    if (this.isEmpty(value)) break;
                    accepted = true;
                    break;
                }
                case MERGE_COLLECTIONS: {
                    if (this.isEmpty(value)) break;
                    accepted = true;
                    break;
                }
            }
            return accepted;
        }

        protected boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof String) {
                return ((String)value).isEmpty();
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            return false;
        }
    }
}

