/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Map;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Tuple;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.CronExpression;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class CronTimer
extends BaseTimer
implements Timer,
Externalizable {
    private MVELObjectExpression startTime;
    private MVELObjectExpression endTime;
    private int repeatLimit;
    private CronExpression cronExpression;

    public CronTimer() {
    }

    public CronTimer(MVELObjectExpression startTime, MVELObjectExpression endTime, int repeatLimit, CronExpression cronExpression) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.cronExpression = cronExpression;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.cronExpression.getCronExpression());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (MVELObjectExpression)in.readObject();
        this.endTime = (MVELObjectExpression)in.readObject();
        this.repeatLimit = in.readInt();
        String string = (String)in.readObject();
        try {
            this.cronExpression = new CronExpression(string);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to marshal CronExpression '" + string + "'", e);
        }
    }

    public Declaration[] getStartDeclarations() {
        return this.startTime != null ? this.startTime.getMVELCompilationUnit().getPreviousDeclarations() : null;
    }

    public Declaration[] getEndDeclarations() {
        return this.endTime != null ? this.endTime.getMVELCompilationUnit().getPreviousDeclarations() : null;
    }

    @Override
    public Declaration[][] getTimerDeclarations(Map<String, Declaration> outerDeclrs) {
        return new Declaration[][]{this.sortDeclarations(outerDeclrs, this.getStartDeclarations()), this.sortDeclarations(outerDeclrs, this.getEndDeclarations())};
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        Declaration[][] timerDeclrs = ((AgendaItem)item).getTerminalNode().getTimerDeclarations();
        ScheduledAgendaItem schItem = (ScheduledAgendaItem)item;
        DefaultJobHandle jh = null;
        if (schItem.getJobHandle() != null) {
            jh = (DefaultJobHandle)schItem.getJobHandle();
        }
        return this.createTrigger(timestamp, item.getTuple(), jh, calendarNames, calendars, timerDeclrs, wm);
    }

    @Override
    public Trigger createTrigger(long timestamp, Tuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        Declaration[] startDeclarations = declrs[0];
        return new CronTrigger(timestamp, TimeUtils.evalDateExpression(this.startTime, leftTuple, startDeclarations, wm), TimeUtils.evalDateExpression(this.endTime, leftTuple, startDeclarations, wm), this.repeatLimit, this.cronExpression, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new CronTrigger(timestamp, null, null, this.repeatLimit, this.cronExpression, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cronExpression.getCronExpression() == null ? 0 : this.cronExpression.getCronExpression().hashCode());
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CronTimer other = (CronTimer)obj;
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.cronExpression.getCronExpression() == null ? other.cronExpression.getCronExpression() != null : !this.cronExpression.getCronExpression().equals(other.cronExpression.getCronExpression())) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new CronTimer(this.startTime, this.endTime, this.repeatLimit, this.cronExpression);
    }
}

