/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserGroupInfo {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUserGroupInfo.class);

    protected Properties readProperties(String propertiesLocation, String defaultProperties) {
        URL locationUrl;
        Properties config;
        block9: {
            config = null;
            locationUrl = null;
            if (propertiesLocation == null) {
                propertiesLocation = defaultProperties;
            }
            logger.debug("Callback properties will be loaded from {}", (Object)propertiesLocation);
            if (propertiesLocation.startsWith("classpath:")) {
                String stripedLocation = propertiesLocation.replaceFirst("classpath:", "");
                locationUrl = this.getClass().getResource(stripedLocation);
                if (locationUrl == null) {
                    locationUrl = Thread.currentThread().getContextClassLoader().getResource(stripedLocation);
                }
            } else {
                try {
                    locationUrl = new URL(propertiesLocation);
                }
                catch (MalformedURLException e) {
                    locationUrl = this.getClass().getResource(propertiesLocation);
                    if (locationUrl != null) break block9;
                    locationUrl = Thread.currentThread().getContextClassLoader().getResource(propertiesLocation);
                }
            }
        }
        if (locationUrl != null) {
            config = new Properties();
            try {
                config.load(locationUrl.openStream());
            }
            catch (IOException e) {
                logger.error("Error when loading properties for DB user group callback", (Throwable)e);
                config = null;
            }
        }
        return config;
    }
}

