/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.command.CommandService;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.persistence.OrderedTransactionSynchronization;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineInitlializer;
import org.jbpm.runtime.manager.impl.factory.LocalTaskServiceFactory;
import org.jbpm.runtime.manager.impl.mapper.EnvironmentAwareProcessInstanceContext;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.InternalMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerProcessInstanceRuntimeManager
extends AbstractRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(PerProcessInstanceRuntimeManager.class);
    private boolean useLocking = Boolean.parseBoolean(System.getProperty("org.jbpm.runtime.manager.ppi.lock", "true"));
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<Object, RuntimeEngine>> local = new ThreadLocal();
    private ConcurrentMap<Long, ReentrantLock> engineLocks = new ConcurrentHashMap<Long, ReentrantLock>();
    private Mapper mapper;

    public PerProcessInstanceRuntimeManager(org.kie.api.runtime.manager.RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.mapper = ((RuntimeEnvironment)environment).getMapper();
        this.registry.register((RuntimeManager)this);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        RuntimeEngineImpl runtime = null;
        Object contextId = context.getContextId();
        if (!(context instanceof ProcessInstanceIdContext) && !(context instanceof CorrelationKeyContext)) {
            logger.warn("ProcessInstanceIdContext or CorrelationKeyContext shall be used when interacting with PerProcessInstance runtime manager");
        }
        if (this.engineInitEager) {
            KieSession ksession = null;
            Long ksessionId = null;
            if (contextId == null || context instanceof EmptyContext) {
                ksession = this.factory.newKieSession();
                ksessionId = ksession.getIdentifier();
            } else {
                RuntimeEngine localRuntime = this.findLocalRuntime(contextId);
                if (localRuntime != null) {
                    return localRuntime;
                }
                ksessionId = this.mapper.findMapping(context, this.identifier);
                if (ksessionId == null) {
                    throw new SessionNotFoundException("No session found for context " + context.getContextId());
                }
                ksession = this.factory.findKieSessionById(ksessionId);
            }
            InternalTaskService internalTaskService = (InternalTaskService)this.taskServiceFactory.newTaskService();
            runtime = new RuntimeEngineImpl(ksession, (TaskService)internalTaskService);
            runtime.setManager((RuntimeManager)this);
            runtime.setContext(context);
            this.configureRuntimeOnTaskService(internalTaskService, runtime);
            this.registerDisposeCallback(runtime, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)this, runtime));
            this.registerItems(runtime);
            this.attachManager(runtime);
            ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, runtime, this.identifier));
        } else {
            RuntimeEngine localRuntime = this.findLocalRuntime(contextId);
            if (localRuntime != null) {
                return localRuntime;
            }
            runtime = new RuntimeEngineImpl(context, new PerProcessInstanceInitializer());
            runtime.setManager((RuntimeManager)this);
        }
        this.createLockOnGetEngine(context, runtime);
        this.saveLocalRuntime(contextId, runtime);
        return runtime;
    }

    public void signalEvent(String type, Object event) {
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context<?>)ProcessInstanceIdContext.get());
        runtimeEngine.getKieSession().signalEvent(type, event);
        this.disposeRuntimeEngine(runtimeEngine);
        List<String> processInstances = ((InternalMapper)this.mapper).findContextIdForEvent(type, this.getIdentifier());
        for (String piId : processInstances) {
            runtimeEngine = this.getRuntimeEngine((Context<?>)ProcessInstanceIdContext.get((Long)Long.parseLong(piId)));
            runtimeEngine.getKieSession().signalEvent(type, event);
            this.disposeRuntimeEngine(runtimeEngine);
        }
        Map<Object, RuntimeEngine> currentlyActive = local.get();
        if (currentlyActive != null && !currentlyActive.isEmpty()) {
            RuntimeEngine[] activeEngines;
            for (RuntimeEngine engine : activeEngines = currentlyActive.values().toArray(new RuntimeEngine[currentlyActive.size()])) {
                Context<?> context = ((RuntimeEngineImpl)engine).getContext();
                if (context == null || !(context instanceof ProcessInstanceIdContext) || ((ProcessInstanceIdContext)context).getContextId() == null) continue;
                engine.getKieSession().signalEvent(type, event, ((ProcessInstanceIdContext)context).getContextId().longValue());
            }
        }
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (context == null || context.getContextId() == null) {
            return;
        }
        Long ksessionId = this.mapper.findMapping(context, this.identifier);
        if (ksessionId == null) {
            Object contextId = this.mapper.findContextId(Long.valueOf(ksession.getIdentifier()), this.identifier);
            if (contextId != null) {
                throw new IllegalStateException("KieSession with id " + ksession.getIdentifier() + " is already used by another context");
            }
            return;
        }
        if (ksession.getIdentifier() != ksessionId.longValue()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (this.canDispose(runtime)) {
            this.removeLocalRuntime(runtime);
            if (runtime instanceof Disposable) {
                if (this.mapper instanceof InMemoryMapper && ((InMemoryMapper)this.mapper).hasContext(runtime.getKieSession().getIdentifier())) {
                    return;
                }
                ((Disposable)runtime).dispose();
            }
            this.releaseAndCleanLock(runtime);
        }
    }

    @Override
    public void softDispose(RuntimeEngine runtimeEngine) {
        super.softDispose(runtimeEngine);
        this.removeLocalRuntime(runtimeEngine);
    }

    @Override
    public void close() {
        try {
            if (!(this.taskServiceFactory instanceof LocalTaskServiceFactory)) {
                this.removeRuntimeFromTaskService();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this.factory.close();
    }

    public boolean validate(Long ksessionId, Long processInstanceId) {
        Long mapped = this.mapper.findMapping((Context)ProcessInstanceIdContext.get((Long)processInstanceId), this.identifier);
        return mapped == ksessionId;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected RuntimeEngine findLocalRuntime(Object processInstanceId) {
        if (processInstanceId == null) {
            return null;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            return null;
        }
        RuntimeEngine engine = map.get(processInstanceId);
        if (engine != null && ((RuntimeEngineImpl)engine).isDisposed()) {
            map.remove(processInstanceId);
            return null;
        }
        return engine;
    }

    protected void saveLocalRuntime(Object processInstanceId, RuntimeEngine runtime) {
        if (processInstanceId == null || !(processInstanceId instanceof Long)) {
            return;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            map = new HashMap<Object, RuntimeEngine>();
            local.set(map);
        }
        map.put(processInstanceId, runtime);
    }

    protected void removeLocalRuntime(RuntimeEngine runtime) {
        Map<Object, RuntimeEngine> map = local.get();
        Object keyToRemove = -1L;
        if (map != null) {
            for (Map.Entry<Object, RuntimeEngine> entry : map.entrySet()) {
                if (!runtime.equals(entry.getValue())) continue;
                keyToRemove = entry.getKey();
                break;
            }
            map.remove(keyToRemove);
        }
    }

    @Override
    public void init() {
        TaskContentRegistry.get().addMarshallerContext(this.getIdentifier(), new ContentMarshallerContext(this.environment.getEnvironment(), this.environment.getClassLoader()));
        KieSession initialKsession = this.factory.newKieSession();
        initialKsession.execute((Command)new DestroyKSessionCommand(initialKsession, this));
        if (!"false".equalsIgnoreCase(System.getProperty("org.jbpm.rm.init.timer")) && this.mapper instanceof JPAMapper) {
            List<Long> ksessionsToInit = ((JPAMapper)this.mapper).findKSessionToInit(this.identifier);
            for (Long id : ksessionsToInit) {
                initialKsession = this.factory.findKieSessionById(id);
                initialKsession.execute((Command)new DisposeKSessionCommand(initialKsession, this));
            }
        }
    }

    protected void createLockOnGetEngine(Context<?> context, RuntimeEngine runtime) {
        Long piId;
        if (!this.useLocking) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        if (context instanceof ProcessInstanceIdContext && (piId = ((ProcessInstanceIdContext)context).getContextId()) != null) {
            ReentrantLock newLock = new ReentrantLock();
            ReentrantLock lock = this.engineLocks.putIfAbsent(piId, newLock);
            if (lock == null) {
                lock = newLock;
            }
            logger.debug("Trying to get a lock {} for {} by {}", new Object[]{lock, context, runtime});
            lock.lock();
            logger.debug("Lock {} taken for {} by {} for waiting threads by {}", new Object[]{lock, context, runtime, lock.hasQueuedThreads()});
        }
    }

    protected void createLockOnNewProcessInstance(Long processInstanceId, RuntimeEngine runtime) {
        if (!this.useLocking) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        ReentrantLock newLock = new ReentrantLock();
        ReentrantLock lock = this.engineLocks.putIfAbsent(processInstanceId, newLock);
        if (lock == null) {
            lock = newLock;
        }
        lock.lock();
        logger.debug("[MaintainMappingListener] Lock {} created and stored in list by {}", (Object)lock, (Object)runtime);
    }

    protected void releaseAndCleanLock(RuntimeEngine runtime) {
        Long piId;
        if (!this.useLocking) {
            logger.debug("Locking on runtime manager disabled");
            return;
        }
        if (((RuntimeEngineImpl)runtime).getContext() instanceof ProcessInstanceIdContext && (piId = ((ProcessInstanceIdContext)((RuntimeEngineImpl)runtime).getContext()).getContextId()) != null) {
            ReentrantLock lock = (ReentrantLock)this.engineLocks.get(piId);
            if (!lock.hasQueuedThreads()) {
                logger.debug("Removing lock {} from list as non is waiting for it by {}", (Object)lock, (Object)runtime);
                this.engineLocks.remove(piId);
            }
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
                logger.debug("{} unlocked by {}", (Object)lock, (Object)runtime);
            }
        }
    }

    private class PerProcessInstanceInitializer
    implements RuntimeEngineInitlializer {
        private PerProcessInstanceInitializer() {
        }

        @Override
        public KieSession initKieSession(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            Long found;
            Object contextId = context.getContextId();
            if (contextId != null && !(context instanceof EmptyContext) && (found = PerProcessInstanceRuntimeManager.this.mapper.findMapping(context, manager.getIdentifier())) == null) {
                PerProcessInstanceRuntimeManager.this.removeLocalRuntime(engine);
                throw new SessionNotFoundException("No session found for context " + context.getContextId());
            }
            KieSession ksession = null;
            Long ksessionId = null;
            if (contextId == null || context instanceof EmptyContext) {
                ksession = PerProcessInstanceRuntimeManager.this.factory.newKieSession();
                ksessionId = ksession.getIdentifier();
            } else {
                RuntimeEngine localRuntime = ((PerProcessInstanceRuntimeManager)manager).findLocalRuntime(contextId);
                if (localRuntime != null && ((RuntimeEngineImpl)engine).internalGetKieSession() != null) {
                    return localRuntime.getKieSession();
                }
                ksessionId = PerProcessInstanceRuntimeManager.this.mapper.findMapping(context, manager.getIdentifier());
                if (ksessionId == null) {
                    throw new SessionNotFoundException("No session found for context " + context.getContextId());
                }
                ksession = PerProcessInstanceRuntimeManager.this.factory.findKieSessionById(ksessionId);
            }
            ((RuntimeEngineImpl)engine).internalSetKieSession(ksession);
            PerProcessInstanceRuntimeManager.this.registerItems(engine);
            PerProcessInstanceRuntimeManager.this.attachManager(engine);
            PerProcessInstanceRuntimeManager.this.registerDisposeCallback(engine, (TransactionSynchronization)new DisposeSessionTransactionSynchronization((RuntimeManager)manager, engine));
            ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, engine, manager.getIdentifier()));
            return ksession;
        }

        @Override
        public TaskService initTaskService(Context<?> context, InternalRuntimeManager manager, RuntimeEngine engine) {
            InternalTaskService internalTaskService = (InternalTaskService)PerProcessInstanceRuntimeManager.this.taskServiceFactory.newTaskService();
            PerProcessInstanceRuntimeManager.this.configureRuntimeOnTaskService(internalTaskService, engine);
            return internalTaskService;
        }
    }

    private static class DisposeKSessionCommand
    implements GenericCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DisposeKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.internal.command.Context context) {
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                this.initialKsession.dispose();
                return null;
            }
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PPIRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int arg0) {
                        DisposeKSessionCommand.this.initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.dispose();
            }
            return null;
        }
    }

    private static class DestroyKSessionCommand
    implements GenericCommand<Void> {
        private static final long serialVersionUID = 1L;
        private KieSession initialKsession;
        private AbstractRuntimeManager manager;

        public DestroyKSessionCommand(KieSession initialKsession, AbstractRuntimeManager manager) {
            this.initialKsession = initialKsession;
            this.manager = manager;
        }

        public Void execute(org.kie.internal.command.Context context) {
            TransactionManager tm = (TransactionManager)this.initialKsession.getEnvironment().get("org.kie.transaction.TransactionManager");
            if (this.manager.hasEnvironmentEntry("IS_JTA_TRANSACTION", false)) {
                if (this.initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                    CommandService commandService = ((CommandBasedStatefulKnowledgeSession)this.initialKsession).getCommandService();
                    ((SingleSessionCommandService)commandService).destroy();
                } else {
                    ((KnowledgeCommandContext)context).getKieSession().destroy();
                }
                return null;
            }
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                TransactionManagerHelper.registerTransactionSyncInContainer((TransactionManager)tm, (OrderedTransactionSynchronization)new OrderedTransactionSynchronization(5, "PPIRM-" + this.initialKsession.getIdentifier()){

                    public void beforeCompletion() {
                        if (DestroyKSessionCommand.this.initialKsession instanceof CommandBasedStatefulKnowledgeSession) {
                            CommandService commandService = ((CommandBasedStatefulKnowledgeSession)DestroyKSessionCommand.this.initialKsession).getCommandService();
                            ((SingleSessionCommandService)commandService).destroy();
                        }
                    }

                    public void afterCompletion(int arg0) {
                        DestroyKSessionCommand.this.initialKsession.dispose();
                    }
                });
            } else {
                this.initialKsession.destroy();
            }
            return null;
        }
    }

    private class MaintainMappingListener
    extends DefaultProcessEventListener {
        private Long ksessionId;
        private RuntimeEngine runtime;
        private String managerId;

        MaintainMappingListener(Long ksessionId, RuntimeEngine runtime, String managerId) {
            this.ksessionId = ksessionId;
            this.runtime = runtime;
            this.managerId = managerId;
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.removeMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.managerId);
            PerProcessInstanceRuntimeManager.this.removeLocalRuntime(this.runtime);
            PerProcessInstanceRuntimeManager.this.registerDisposeCallback(this.runtime, (TransactionSynchronization)new DestroySessionTransactionSynchronization(this.runtime.getKieSession()));
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.saveMapping((Context)new EnvironmentAwareProcessInstanceContext(event.getKieRuntime().getEnvironment(), event.getProcessInstance().getId()), this.ksessionId, this.managerId);
            PerProcessInstanceRuntimeManager.this.saveLocalRuntime(event.getProcessInstance().getId(), this.runtime);
            ((RuntimeEngineImpl)this.runtime).setContext((Context<?>)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()));
            PerProcessInstanceRuntimeManager.this.createLockOnNewProcessInstance(event.getProcessInstance().getId(), this.runtime);
        }
    }
}

