/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor.security;

import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SecurityToken;
import org.apache.cxf.common.security.TokenType;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.NamePasswordCallbackHandler;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;

public class JAASLoginInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ROLE_CLASSIFIER_PREFIX = "prefix";
    public static final String ROLE_CLASSIFIER_CLASS_NAME = "classname";
    private static final Logger LOG = LogUtils.getL7dLogger(JAASLoginInterceptor.class);
    private String contextName = "";
    private Configuration loginConfig;
    private String roleClassifier;
    private String roleClassifierType = "prefix";
    private boolean reportFault;
    private boolean useDoAs = true;

    public JAASLoginInterceptor() {
        super("unmarshal");
    }

    public JAASLoginInterceptor(String phase) {
        super(phase);
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    public String getContextName() {
        return this.contextName;
    }

    @Deprecated
    public void setRolePrefix(String name) {
        this.setRoleClassifier(name);
    }

    public void setRoleClassifier(String value) {
        this.roleClassifier = value;
    }

    public String getRoleClassifier() {
        return this.roleClassifier;
    }

    public void setRoleClassifierType(String value) {
        if (!ROLE_CLASSIFIER_PREFIX.equals(value) && !ROLE_CLASSIFIER_CLASS_NAME.equals(value)) {
            throw new IllegalArgumentException("Unsupported role classifier");
        }
        this.roleClassifierType = value;
    }

    public String getRoleClassifierType() {
        return this.roleClassifierType;
    }

    public void setReportFault(boolean reportFault) {
        this.reportFault = reportFault;
    }

    public void setUseDoAs(boolean useDoAs) {
        this.useDoAs = useDoAs;
    }

    public void handleMessage(final Message message) throws Fault {
        String name = null;
        String password = null;
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy != null) {
            name = policy.getUserName();
            password = policy.getPassword();
        } else {
            SecurityToken token = (SecurityToken)message.get(SecurityToken.class);
            if (token != null && token.getTokenType() == TokenType.UsernameToken) {
                UsernameToken ut = (UsernameToken)token;
                name = ut.getName();
                password = ut.getPassword();
            }
        }
        if (name == null || password == null) {
            throw new AuthenticationException("Authentication required but no user or password was supplied");
        }
        try {
            CallbackHandler handler = this.getCallbackHandler(name, password);
            LoginContext ctx = new LoginContext(this.getContextName(), null, handler, this.loginConfig);
            ctx.login();
            Subject subject = ctx.getSubject();
            message.put(SecurityContext.class, (Object)this.createSecurityContext(name, subject));
            if (this.useDoAs) {
                Subject.doAs(subject, new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        InterceptorChain chain = message.getInterceptorChain();
                        if (chain != null) {
                            chain.doIntercept(message);
                        }
                        return null;
                    }
                });
            }
        }
        catch (LoginException ex) {
            String errorMessage = "Authentication failed for user " + name + " : " + ex.getMessage();
            LOG.fine(errorMessage);
            if (this.reportFault) {
                throw new AuthenticationException(errorMessage);
            }
            throw new AuthenticationException("Authentication failed (details can be found in server log)");
        }
    }

    protected CallbackHandler getCallbackHandler(String name, String password) {
        return new NamePasswordCallbackHandler(name, password);
    }

    protected SecurityContext createSecurityContext(String name, Subject subject) {
        if (this.getRoleClassifier() != null) {
            return new RolePrefixSecurityContextImpl(subject, this.getRoleClassifier(), this.getRoleClassifierType());
        }
        return new DefaultSecurityContext(name, subject);
    }

    public Configuration getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(Configuration loginConfig) {
        this.loginConfig = loginConfig;
    }
}

