/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.compiler.xml.ProcessDataEventListener;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptor;
import org.jbpm.kie.services.impl.bpmn2.UserTaskDefinitionImpl;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesProcessDataEventListener
implements ProcessDataEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ServicesProcessDataEventListener.class);
    private ProcessDescriptor processDescriptor = new ProcessDescriptor();
    private Map<String, ItemDefinition> itemDefinitions;
    private List<Variable> variables = new ArrayList<Variable>();

    public void onNodeAdded(Node node) {
        logger.debug("Added node " + node);
        if (node instanceof HumanTaskNode) {
            HumanTaskNode humanTaskNode = (HumanTaskNode)node;
            String name = humanTaskNode.getName();
            UserTaskDefinitionImpl task = (UserTaskDefinitionImpl)this.processDescriptor.getTasks().get(name);
            if (task == null) {
                task = new UserTaskDefinitionImpl();
                task.setName(name);
                this.processDescriptor.getTasks().put(task.getName(), task);
            }
            Map parameters = humanTaskNode.getWork().getParameters();
            Collection<String> currentAssignment = this.processDescriptor.getTaskAssignments().get(humanTaskNode.getName());
            for (Object parameter : parameters.keySet()) {
                if (!((String)parameter).equals("GroupId") && !((String)parameter).equals("ActorId")) continue;
                if (currentAssignment == null) {
                    currentAssignment = new ArrayList<String>();
                    this.processDescriptor.getTaskAssignments().put(humanTaskNode.getName(), currentAssignment);
                }
                currentAssignment.add(humanTaskNode.getWork().getParameter((String)parameter).toString());
            }
            ((UserTaskDefinitionImpl)this.processDescriptor.getTasks().get(humanTaskNode.getName())).setAssociatedEntities(currentAssignment);
            HashMap<String, String> inputParams = new HashMap<String, String>();
            for (Map.Entry entry : ((Map)humanTaskNode.getMetaData("DataInputs")).entrySet()) {
                inputParams.put((String)entry.getKey(), (String)entry.getValue());
            }
            HashMap<String, String> outputParams = new HashMap<String, String>();
            for (Map.Entry out : ((Map)humanTaskNode.getMetaData("DataOutputs")).entrySet()) {
                outputParams.put((String)out.getKey(), (String)out.getValue());
            }
            task.setTaskInputMappings(inputParams);
            task.setTaskOutputMappings(outputParams);
            task.setComment(this.asString(humanTaskNode.getWork().getParameter("Comment")));
            task.setCreatedBy(this.asString(humanTaskNode.getWork().getParameter("CreatedBy")));
            task.setPriority(this.asInt(humanTaskNode.getWork().getParameter("Priority")));
            task.setSkippable(this.asBoolean(humanTaskNode.getWork().getParameter("Skippable")));
            this.processDescriptor.getTaskInputMappings().put(task.getName(), inputParams);
            this.processDescriptor.getTaskOutputMappings().put(task.getName(), outputParams);
        } else if (node instanceof RuleSetNode) {
            RuleSetNode ruleSetNode = (RuleSetNode)node;
            String ruleFlowGroup = ruleSetNode.getRuleFlowGroup();
            if (ruleFlowGroup != null) {
                this.processDescriptor.getReferencedRules().add(ruleFlowGroup);
            }
        } else if (node instanceof WorkItemNode) {
            this.processDescriptor.getServiceTasks().put(node.getName(), ((WorkItemNode)node).getWork().getName());
        } else if (node instanceof SubProcessNode) {
            SubProcessNode subProcess = (SubProcessNode)node;
            String processId = subProcess.getProcessId();
            if (subProcess.getProcessName() != null) {
                this.processDescriptor.addReusableSubProcessName(subProcess.getProcessName());
            } else {
                this.processDescriptor.getReusableSubProcesses().add(processId);
            }
        }
    }

    public void onProcessAdded(Process process) {
        logger.debug("Added process with id {} and name {}", (Object)process.getId(), (Object)process.getName());
        ProcessAssetDesc processDesc = new ProcessAssetDesc(process.getId(), process.getName(), process.getVersion(), process.getPackageName(), process.getType(), process.getKnowledgeType().name(), process.getNamespace(), "");
        this.processDescriptor.setProcess(processDesc);
        process.getMetaData().put("ProcessDescriptor", this.processDescriptor);
    }

    public void onMetaDataAdded(String name, Object data) {
        if (name.equals("Variable")) {
            this.variables.add((Variable)data);
        } else if ("ItemDefinitions".equals(name)) {
            this.itemDefinitions = (Map)data;
        }
    }

    public void onComplete(Process process) {
        Set imports;
        Map globals;
        if (this.itemDefinitions != null) {
            for (ItemDefinition item : this.itemDefinitions.values()) {
                String id = item.getId();
                String structureRef = item.getStructureRef();
                String itemDefinitionId = this.processDescriptor.getGlobalItemDefinitions().get(id);
                if (itemDefinitionId != null) continue;
                this.processDescriptor.getGlobalItemDefinitions().put(id, structureRef);
                if (structureRef.contains(".")) {
                    this.processDescriptor.getReferencedClasses().add(structureRef);
                    continue;
                }
                this.processDescriptor.getUnqualifiedClasses().add(structureRef);
            }
        }
        if ((globals = ((RuleFlowProcess)process).getGlobals()) != null) {
            for (String type : globals.values()) {
                if (type.contains(".")) {
                    this.processDescriptor.getReferencedClasses().add(type);
                    continue;
                }
                this.processDescriptor.getUnqualifiedClasses().add(type);
            }
        }
        if ((imports = ((RuleFlowProcess)process).getImports()) != null) {
            for (String type : imports) {
                if (type.contains(".")) {
                    this.processDescriptor.getReferencedClasses().add(type);
                    continue;
                }
                this.processDescriptor.getUnqualifiedClasses().add(type);
            }
        }
    }

    private Integer getInteger(String value) {
        int priority = 0;
        if (value != null) {
            try {
                priority = new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return priority;
    }

    protected void resolveUnqualifiedClasses() {
        HashSet<String> qualifiedClassSimpleNames = new HashSet<String>();
        for (String className : this.processDescriptor.getReferencedClasses()) {
            qualifiedClassSimpleNames.add(className.substring(className.lastIndexOf(46) + 1));
        }
        Iterator<String> iter = this.processDescriptor.getUnqualifiedClasses().iterator();
        while (iter.hasNext()) {
            if (!qualifiedClassSimpleNames.contains(iter.next())) continue;
            iter.remove();
        }
        iter = this.processDescriptor.getUnqualifiedClasses().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!"Object".equals(name) && !"String".equals(name) && !"Float".equals(name) && !"Integer".equals(name) && !"Boolean".equals(name)) continue;
            this.processDescriptor.getReferencedClasses().add("java.lang." + name);
            iter.remove();
        }
        for (String className : this.processDescriptor.getUnqualifiedClasses()) {
            logger.warn("Unable to resolve unqualified class name, adding to list of classes: '{}'", (Object)className);
            this.processDescriptor.getReferencedClasses().add(className);
        }
    }

    public void onBuildComplete(Process process) {
        Set unqualifiedClasses;
        Set referencedTypes = (Set)process.getMetaData().get("JavaDialectReferencedTypes");
        if (referencedTypes != null && !referencedTypes.isEmpty()) {
            this.processDescriptor.getReferencedClasses().addAll(referencedTypes);
        }
        if ((unqualifiedClasses = (Set)process.getMetaData().get("JavaDialectUnqualifiedTypes")) != null && !unqualifiedClasses.isEmpty()) {
            this.processDescriptor.getUnqualifiedClasses().addAll(unqualifiedClasses);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("JavaReturnValueReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.processDescriptor.getReferencedClasses().addAll(referencedTypes);
        }
        if ((unqualifiedClasses = (Set)process.getMetaData().get("JavaReturnValueUnqualifiedTypes")) != null && !unqualifiedClasses.isEmpty()) {
            this.processDescriptor.getUnqualifiedClasses().addAll(unqualifiedClasses);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("MVELDialectReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.processDescriptor.getReferencedClasses().addAll(referencedTypes);
        }
        if ((referencedTypes = (Set)process.getMetaData().get("MVELReturnValueReferencedTypes")) != null && !referencedTypes.isEmpty()) {
            this.processDescriptor.getReferencedClasses().addAll(referencedTypes);
        }
        this.resolveUnqualifiedClasses();
        if (this.variables != null) {
            for (Variable data : this.variables) {
                String type = data.getType().getStringType();
                String itemSubjectRef = (String)data.getMetaData("ItemSubjectRef");
                if (itemSubjectRef != null && this.itemDefinitions != null) {
                    ItemDefinition itemDef = this.itemDefinitions.get(itemSubjectRef);
                    type = itemDef.getStructureRef();
                }
                this.processDescriptor.getInputs().put(data.getName(), type);
            }
        }
    }

    protected Integer asInt(Object value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected Boolean asBoolean(Object value) {
        if (value == null) {
            return true;
        }
        return Boolean.valueOf(value.toString());
    }

    protected String asString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

