/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.factmodel.traits.TypeWrapper;

public class TypeCache
implements Externalizable {
    private Map<String, TypeWrapper> typeCache = new LinkedHashMap<String, TypeWrapper>();
    private boolean needsInit = false;

    public boolean needsInit() {
        return this.needsInit;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.typeCache.size());
        ArrayList<String> keys = new ArrayList<String>(this.typeCache.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            out.writeObject(k);
            out.writeObject(this.typeCache.get(k));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeCache = new HashMap<String, TypeWrapper>();
        int n = in.readInt();
        for (int j = 0; j < n; ++j) {
            String k = (String)in.readObject();
            TypeWrapper tf = (TypeWrapper)in.readObject();
            this.typeCache.put(k, tf);
        }
        this.needsInit = true;
    }

    public TypeWrapper get(String name) {
        return this.typeCache.get(name);
    }

    public void put(String name, TypeWrapper wrapper) {
        this.typeCache.put(name, wrapper);
    }

    public void init(WorkingMemory wm) {
        this.needsInit = false;
        for (TypeWrapper wrapper : this.typeCache.values()) {
            if (wrapper.getKlass() != null) continue;
            try {
                wrapper.setKlass(Class.forName(wrapper.getName(), false, wm.getKnowledgeBase().getRootClassLoader()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

