/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.ejb.TaskServiceEJBLocal;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.impl.TaskSummaryQueryBuilderImpl;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.kie.api.command.Command;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.kie.internal.task.api.model.TaskDef;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;

@Stateless
public class TaskServiceEJBImpl
implements InternalTaskService,
TaskService,
TaskServiceEJBLocal {
    private InternalTaskService delegate;
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;

    private static <T> T unsupported(Class<T> returnType) {
        String methodName = new Throwable().getStackTrace()[1].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the TaskService EJB implementation, please use the " + UserTaskService.class + " implementation instead!");
    }

    @PostConstruct
    public void configureDelegate() {
        UserGroupCallback callback = UserDataServiceProvider.getUserGroupCallback();
        HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).userGroupCallback(callback);
        DeploymentDescriptorManager manager = new DeploymentDescriptorManager("org.jbpm.domain");
        DeploymentDescriptor descriptor = manager.getDefaultDescriptor();
        if (!descriptor.getAuditMode().equals((Object)AuditMode.NONE)) {
            JPATaskLifeCycleEventListener listener = new JPATaskLifeCycleEventListener(false);
            BAMTaskEventListener bamListener = new BAMTaskEventListener(false);
            if (!"org.jbpm.domain".equals(descriptor.getAuditPersistenceUnit())) {
                EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit());
                listener = new JPATaskLifeCycleEventListener(emf);
                bamListener = new BAMTaskEventListener(emf);
            }
            configurator.listener((TaskLifeCycleEventListener)listener);
            configurator.listener((TaskLifeCycleEventListener)bamListener);
        }
        this.delegate = (InternalTaskService)configurator.getTaskService();
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, String language) {
        return this.delegate.getTasksAssignedAsBusinessAdministrator(userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministratorByStatus(String userId, String language, List<Status> statuses) {
        return this.delegate.getTasksAssignedAsBusinessAdministratorByStatus(userId, language, statuses);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, String language) {
        return this.delegate.getTasksAssignedAsPotentialOwner(userId, language);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language) {
        return this.delegate.getTasksAssignedAsPotentialOwnerByStatus(userId, status, language);
    }

    public List<TaskSummary> getTasksOwned(String userId, String language) {
        return this.delegate.getTasksOwned(userId, language);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, String language) {
        return this.delegate.getTasksOwnedByStatus(userId, status, language);
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(long processInstanceId, List<Status> status, String language) {
        return this.delegate.getTasksByStatusByProcessInstanceId(processInstanceId, status, language);
    }

    public List<Long> getTasksByProcessInstanceId(long processInstanceId) {
        return this.delegate.getTasksByProcessInstanceId(processInstanceId);
    }

    public List<TaskSummary> getActiveTasks() {
        return this.delegate.getActiveTasks();
    }

    public List<TaskSummary> getActiveTasks(Date since) {
        return this.delegate.getActiveTasks(since);
    }

    public List<TaskSummary> getTasksOwned(String userId, List<Status> status, QueryFilter filter) {
        return this.delegate.getTasksOwned(userId, status, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        return this.delegate.getTasksAssignedAsPotentialOwner(userId, groupIds, status, filter);
    }

    public List<TaskSummary> getArchivedTasks() {
        return this.delegate.getArchivedTasks();
    }

    public List<TaskSummary> getCompletedTasks() {
        return this.delegate.getCompletedTasks();
    }

    public List<TaskSummary> getCompletedTasks(Date since) {
        return this.delegate.getCompletedTasks(since);
    }

    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        return this.delegate.getCompletedTasksByProcessId(processId);
    }

    public List<TaskSummary> getSubTasksAssignedAsPotentialOwner(long parentId, String userId) {
        return this.delegate.getSubTasksAssignedAsPotentialOwner(parentId, userId);
    }

    public List<TaskSummary> getSubTasksByParent(long parentId) {
        return this.delegate.getSubTasksByParent(parentId);
    }

    public int getPendingSubTasksByParent(long parentId) {
        return this.delegate.getPendingSubTasksByParent(parentId);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDate(String userId, List<Status> statuses, Date expirationDate) {
        return this.delegate.getTasksAssignedAsPotentialOwnerByExpirationDate(userId, statuses, expirationDate);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> statuses, Date expirationDate) {
        return this.delegate.getTasksAssignedAsPotentialOwnerByExpirationDateOptional(userId, statuses, expirationDate);
    }

    public List<TaskSummary> getTasksOwnedByExpirationDate(String userId, List<Status> statuses, Date expirationDate) {
        return this.delegate.getTasksOwnedByExpirationDate(userId, statuses, expirationDate);
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> statuses, Date expirationDate) {
        return this.delegate.getTasksOwnedByExpirationDateOptional(userId, statuses, expirationDate);
    }

    public List<TaskSummary> getTasksAssignedAsExcludedOwner(String userId) {
        return this.delegate.getTasksAssignedAsExcludedOwner(userId);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds) {
        return this.delegate.getTasksAssignedAsPotentialOwner(userId, groupIds);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResults) {
        return this.delegate.getTasksAssignedAsPotentialOwner(userId, groupIds, language, firstResult, maxResults);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status) {
        return this.delegate.getTasksAssignedAsPotentialOwnerByStatusByGroup(userId, groupIds, status);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByProcessId(String userId, String processId) {
        return this.delegate.getTasksAssignedAsPotentialOwnerByProcessId(userId, processId);
    }

    public List<TaskSummary> getTasksAssignedAsRecipient(String userId) {
        return this.delegate.getTasksAssignedAsRecipient(userId);
    }

    public List<TaskSummary> getTasksAssignedAsTaskInitiator(String userId) {
        return this.delegate.getTasksAssignedAsTaskInitiator(userId);
    }

    public List<TaskSummary> getTasksAssignedAsTaskStakeholder(String userId) {
        return this.delegate.getTasksAssignedAsTaskStakeholder(userId);
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateBeforeSpecifiedDate(String userId, List<Status> status, Date date) {
        return this.delegate.getTasksOwnedByExpirationDateBeforeSpecifiedDate(userId, status, date);
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceIdByTaskName(long processInstanceId, List<Status> status, String taskName) {
        return this.delegate.getTasksByStatusByProcessInstanceIdByTaskName(processInstanceId, status, taskName);
    }

    public Map<Long, List<OrganizationalEntity>> getPotentialOwnersForTaskIds(List<Long> taskIds) {
        return this.delegate.getPotentialOwnersForTaskIds(taskIds);
    }

    public List<TaskSummary> getTasksAssignedByGroup(String groupId) {
        return this.delegate.getTasksAssignedByGroup(groupId);
    }

    public List<TaskSummary> getTasksAssignedByGroups(List<String> groupIds) {
        return this.delegate.getTasksAssignedByGroups(groupIds);
    }

    public List<TaskSummary> getTasksByVariousFields(String userId, List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> status, List<String> languages, boolean union) {
        return this.delegate.getTasksByVariousFields(userId, workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, status, languages, union);
    }

    public List<TaskSummary> getTasksByVariousFields(String userId, Map<String, List<?>> parameters, boolean union) {
        return this.delegate.getTasksByVariousFields(userId, parameters, union);
    }

    public void activate(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void claim(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void claimNextAvailable(String userId, String language) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void complete(long taskId, String userId, Map<String, Object> data) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void delegate(long taskId, String userId, String targetUserId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void exit(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void fail(long taskId, String userId, Map<String, Object> faultData) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void forward(long taskId, String userId, String targetEntityId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public Task getTaskByWorkItemId(long workItemId) {
        return TaskServiceEJBImpl.unsupported(Task.class);
    }

    public Task getTaskById(long taskId) {
        return TaskServiceEJBImpl.unsupported(Task.class);
    }

    public long addTask(Task task, Map<String, Object> params) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public void release(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void resume(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void skip(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void start(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void stop(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void suspend(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public Content getContentById(long contentId) {
        return TaskServiceEJBImpl.unsupported(Content.class);
    }

    public Attachment getAttachmentById(long attachId) {
        return TaskServiceEJBImpl.unsupported(Attachment.class);
    }

    public Map<String, Object> getTaskContent(long taskId) {
        return TaskServiceEJBImpl.unsupported(Map.class);
    }

    public <T> T execute(Command<T> command) {
        return (T)this.delegate.execute(command);
    }

    public void addGroup(Group group) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void addUser(User user) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public int archiveTasks(List<TaskSummary> tasks) {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public void deleteFault(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void deleteOutput(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void deployTaskDef(TaskDef def) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public List<TaskDef> getAllTaskDef(String filter) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public Group getGroupById(String groupId) {
        return TaskServiceEJBImpl.unsupported(Group.class);
    }

    public List<Group> getGroups() {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public TaskDef getTaskDefById(String id) {
        return TaskServiceEJBImpl.unsupported(TaskDef.class);
    }

    public User getUserById(String userId) {
        return TaskServiceEJBImpl.unsupported(User.class);
    }

    public List<User> getUsers() {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public long addTask(Task task, ContentData data) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public void remove(long taskId, String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void removeGroup(String groupId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public int removeTasks(List<TaskSummary> tasks) {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public void removeUser(String userId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setFault(long taskId, String userId, FaultData fault) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setOutput(long taskId, String userId, Object outputContentData) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setPriority(long taskId, int priority) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setTaskNames(long taskId, List<I18NText> taskNames) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void undeployTaskDef(String id) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public List<TaskEvent> getTaskEventsById(long taskId) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public UserInfo getUserInfo() {
        return TaskServiceEJBImpl.unsupported(UserInfo.class);
    }

    public void setUserInfo(UserInfo userInfo) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void addUsersAndGroups(Map<String, User> users, Map<String, Group> groups) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public int removeAllTasks() {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public long addContent(long taskId, Content content) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public long addContent(long taskId, Map<String, Object> params) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public void deleteContent(long taskId, long contentId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public long addAttachment(long taskId, Attachment attachment, Content content) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public void deleteAttachment(long taskId, long attachmentId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public List<Attachment> getAllAttachmentsByTaskId(long taskId) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public void removeTaskEventsById(long taskId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public OrganizationalEntity getOrganizationalEntityById(String entityId) {
        return TaskServiceEJBImpl.unsupported(OrganizationalEntity.class);
    }

    public void setExpirationDate(long taskId, Date date) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setDescriptions(long taskId, List<I18NText> descriptions) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setSkipable(long taskId, boolean skipable) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void setSubTaskStrategy(long taskId, SubTasksStrategy strategy) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public int getPriority(long taskId) {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public Date getExpirationDate(long taskId) {
        return TaskServiceEJBImpl.unsupported(Date.class);
    }

    public List<I18NText> getDescriptions(long taskId) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public boolean isSkipable(long taskId) {
        return TaskServiceEJBImpl.unsupported(Boolean.TYPE);
    }

    public SubTasksStrategy getSubTaskStrategy(long taskId) {
        return TaskServiceEJBImpl.unsupported(SubTasksStrategy.class);
    }

    public Task getTaskInstanceById(long taskId) {
        return TaskServiceEJBImpl.unsupported(Task.class);
    }

    public int getCompletedTaskByUserId(String userId) {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public int getPendingTaskByUserId(String userId) {
        return TaskServiceEJBImpl.unsupported(Integer.TYPE);
    }

    public Long addComment(long taskId, Comment comment) {
        return TaskServiceEJBImpl.unsupported(Long.class);
    }

    public void deleteComment(long taskId, long commentId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public List<Comment> getAllCommentsByTaskId(long taskId) {
        return TaskServiceEJBImpl.unsupported(List.class);
    }

    public Comment getCommentById(long commentId) {
        return TaskServiceEJBImpl.unsupported(Comment.class);
    }

    public void addMarshallerContext(String ownerId, ContentMarshallerContext context) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public void removeMarshallerContext(String ownerId) {
        TaskServiceEJBImpl.unsupported(Void.class);
    }

    public ContentMarshallerContext getMarshallerContext(Task task) {
        return TaskServiceEJBImpl.unsupported(ContentMarshallerContext.class);
    }

    public TaskSummaryQueryBuilder taskSummaryQuery(String userId) {
        return new TaskSummaryQueryBuilderImpl(userId, (TaskService)this.delegate);
    }

    public void executeReminderForTask(long taskId, String initiator) {
        this.delegate.executeReminderForTask(taskId, initiator);
    }

    public Long addComment(long taskId, String addedByUserId, String commentText) {
        return TaskServiceEJBImpl.unsupported(Long.class);
    }

    public long setDocumentContentFromUser(long taskId, String userId, byte[] byteContent) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public long addOutputContentFromUser(long taskId, String userId, Map<String, Object> params) {
        return TaskServiceEJBImpl.unsupported(Long.TYPE);
    }

    public Content getContentByIdForUser(long contentId, String userId) {
        return TaskServiceEJBImpl.unsupported(Content.class);
    }

    public Map<String, Object> getOutputContentMapForUser(long taskId, String userId) {
        return TaskServiceEJBImpl.unsupported(Map.class);
    }

    public List<TaskSummary> getTasksByGroup(List<String> groupIds) {
        return this.delegate.getTasksByGroup(groupIds);
    }
}

