/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jbpm.kie.services.impl.query.preprocessor.UserTasksPreprocessor;
import org.kie.internal.identity.IdentityProvider;

public class PotOwnerTasksPreprocessor
extends UserTasksPreprocessor {
    private IdentityProvider identityProvider;

    public PotOwnerTasksPreprocessor(IdentityProvider identityProvider, DataSetMetadata metadata) {
        super(metadata);
        this.identityProvider = identityProvider;
    }

    @Override
    public void preprocess(DataSetLookup lookup) {
        if (this.identityProvider == null) {
            return;
        }
        ArrayList<String> orgEntities = new ArrayList<String>(this.identityProvider.getRoles());
        orgEntities.add(this.identityProvider.getName());
        ArrayList<ColumnFilter> condList = new ArrayList<ColumnFilter>();
        condList.add(FilterFactory.equalsTo((String)"ACTUALOWNER", (Comparable)((Object)this.identityProvider.getName())));
        condList.add(FilterFactory.equalsTo((String)"OEID", orgEntities));
        if (lookup.getFirstFilterOp() != null) {
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(condList)});
        } else {
            DataSetFilter filter = new DataSetFilter();
            filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(condList)});
            lookup.addOperation(new DataSetOp[]{filter});
        }
        super.preprocess(lookup);
    }
}

