/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.dialect;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.ResultSetConsumer;
import org.dashbuilder.dataprovider.sql.dialect.DefaultDialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.dashbuilder.dataprovider.sql.model.SortColumn;

public class SQLServerDialect
extends DefaultDialect {
    SimpleDateFormat sqlServerDateFormat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");

    @Override
    public String getColumnTypeSQL(Column column) {
        switch (column.getType()) {
            case NUMBER: {
                return "NUMERIC(28,2)";
            }
            case DATE: {
                return "DATETIME";
            }
        }
        return "VARCHAR(" + column.getLength() + ")";
    }

    @Override
    public String getConcatFunctionSQL(Column[] columns) {
        return super.getConcatFunctionSQL(columns, "CONCAT(", ")", ",");
    }

    @Override
    public String getDatePartFunctionSQL(String part, Column column) {
        String columnSQL = this.getColumnSQL(column);
        return "DATEPART(" + part + "," + columnSQL + ")";
    }

    @Override
    public String getDateParameterSQL(Date param) {
        return "'" + this.sqlServerDateFormat.format(param) + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCountQuerySQL(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        if (limit <= 0 && offset <= 0 && !select.getOrderBys().isEmpty()) {
            ArrayList<SortColumn> sortColumns = new ArrayList<SortColumn>();
            sortColumns.addAll(select.getOrderBys());
            try {
                select.getOrderBys().clear();
                String string = "SELECT COUNT(*) FROM (" + select.getSQL() + ") \"dbSQL\"";
                return string;
            }
            finally {
                select.orderBy(sortColumns);
            }
        }
        return "SELECT COUNT(*) FROM (" + select.getSQL() + ") \"dbSQL\"";
    }

    @Override
    public String getSQL(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        if ((limit > 0 || offset > 0) && select.getOrderBys().isEmpty()) {
            List<Column> columns = select.getColumns();
            if (columns.isEmpty()) {
                columns = this.fetchColumns(select);
            }
            if (!columns.isEmpty()) {
                select.orderBy(columns.get(0).asc());
            }
        }
        return super.getSQL(select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Column> fetchColumns(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        try {
            select.limit(0).offset(0);
            List<Column> list = select.fetch(new ResultSetConsumer<List<Column>>(){

                @Override
                public List<Column> consume(ResultSet rs) {
                    try {
                        return JDBCUtils.getColumns(rs, null);
                    }
                    catch (Exception e) {
                        return Collections.emptyList();
                    }
                }
            });
            return list;
        }
        finally {
            select.limit(limit).offset(offset);
        }
    }

    @Override
    public String getSelectStatement(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        if (offset <= 0 && limit > 0) {
            return "SELECT TOP " + limit;
        }
        return "SELECT";
    }

    @Override
    public String getOffsetLimitSQL(Select select) {
        int offset = select.getOffset();
        int limit = select.getLimit();
        StringBuilder out = new StringBuilder();
        if (offset > 0) {
            if (offset > 0) {
                out.append(" OFFSET ").append(offset).append(" ROWS");
            }
            if (limit > 0) {
                out.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY");
            }
        }
        return out.toString();
    }
}

