/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.SwimlaneContext;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.workflow.core.impl.NodeContainerImpl;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;

public class RuleFlowProcess
extends WorkflowProcessImpl {
    public static final String RULEFLOW_TYPE = "RuleFlow";
    private static final long serialVersionUID = 510L;

    public RuleFlowProcess() {
        this.setType(RULEFLOW_TYPE);
        VariableScope variableScope = new VariableScope();
        this.addContext(variableScope);
        this.setDefaultContext(variableScope);
        SwimlaneContext swimLaneContext = new SwimlaneContext();
        this.addContext(swimLaneContext);
        this.setDefaultContext(swimLaneContext);
        ExceptionScope exceptionScope = new ExceptionScope();
        this.addContext(exceptionScope);
        this.setDefaultContext(exceptionScope);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getDefaultContext("VariableScope");
    }

    public SwimlaneContext getSwimlaneContext() {
        return (SwimlaneContext)this.getDefaultContext("SwimlaneScope");
    }

    public ExceptionScope getExceptionScope() {
        return (ExceptionScope)this.getDefaultContext("ExceptionScope");
    }

    public CompensationScope getCompensationScope() {
        return (CompensationScope)this.getDefaultContext("CompensationScope");
    }

    @Override
    protected NodeContainer createNodeContainer() {
        return new WorkflowProcessNodeContainer();
    }

    public List<Node> getStartNodes() {
        return RuleFlowProcess.getStartNodes(this.getNodes());
    }

    public static List<Node> getStartNodes(Node[] nodes) {
        ArrayList<Node> startNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!(node instanceof StartNode)) continue;
            startNodes.add(node);
        }
        return startNodes;
    }

    public List<Node> getEndNodes() {
        return RuleFlowProcess.getEndNodes(this.getNodes());
    }

    public static List<Node> getEndNodes(Node[] nodes) {
        ArrayList<Node> endNodes = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!(node instanceof EndNode) && !(node instanceof FaultNode)) continue;
            endNodes.add(node);
        }
        return endNodes;
    }

    public StartNode getStart(String trigger) {
        Node[] nodes = this.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof StartNode)) continue;
            StartNode start = (StartNode)nodes[i];
            if (trigger == null && (start.getTriggers() == null || start.getTriggers().isEmpty()) && start.getTimer() == null) {
                return start;
            }
            if (start.getTriggers() != null) {
                for (Trigger t : start.getTriggers()) {
                    if (t instanceof EventTrigger) {
                        for (EventFilter filter : ((EventTrigger)t).getEventFilters()) {
                            if (!filter.acceptsEvent(trigger, null)) continue;
                            return start;
                        }
                        continue;
                    }
                    if (!(t instanceof ConstraintTrigger) || !"conditional".equals(trigger)) continue;
                    return start;
                }
                continue;
            }
            if (start.getTimer() == null || !"timer".equals(trigger)) continue;
            return start;
        }
        return null;
    }

    public List<StartNode> getTimerStart() {
        Node[] nodes = this.getNodes();
        ArrayList<StartNode> timerStartNodes = new ArrayList<StartNode>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof StartNode) || ((StartNode)nodes[i]).getTimer() == null) continue;
            timerStartNodes.add((StartNode)nodes[i]);
        }
        return timerStartNodes;
    }

    private class WorkflowProcessNodeContainer
    extends NodeContainerImpl {
        private static final long serialVersionUID = 510L;

        private WorkflowProcessNodeContainer() {
        }

        @Override
        protected void validateAddNode(Node node) {
            super.validateAddNode(node);
            StartNode startNode = RuleFlowProcess.this.getStart(null);
            if (node instanceof StartNode && startNode != null && startNode.getTriggers() == null && startNode.getTimer() == null && (((StartNode)node).getTriggers() == null || ((StartNode)node).getTriggers().isEmpty()) && ((StartNode)node).getTimer() == null) {
                throw new IllegalArgumentException("A RuleFlowProcess cannot have more than one start node!");
            }
        }
    }
}

