/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerHelper;
import org.drools.persistence.Transformable;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationKey;

public class JpaProcessPersistenceContext
extends JpaPersistenceContext
implements ProcessPersistenceContext {
    public JpaProcessPersistenceContext(EntityManager em, TransactionManager txm) {
        super(em, txm);
    }

    public JpaProcessPersistenceContext(EntityManager em, boolean useJTA, boolean locking, TransactionManager txm) {
        super(em, useJTA, locking, txm);
    }

    @Override
    public ProcessInstanceInfo persist(ProcessInstanceInfo processInstanceInfo) {
        EntityManager em = this.getEntityManager();
        em.persist((Object)processInstanceInfo);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        if (this.pessimisticLocking) {
            em.flush();
            return (ProcessInstanceInfo)em.find(ProcessInstanceInfo.class, (Object)processInstanceInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return processInstanceInfo;
    }

    @Override
    public ProcessInstanceInfo findProcessInstanceInfo(Long processId) {
        EntityManager em = this.getEntityManager();
        if (this.pessimisticLocking) {
            return (ProcessInstanceInfo)em.find(ProcessInstanceInfo.class, (Object)processId, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return (ProcessInstanceInfo)em.find(ProcessInstanceInfo.class, (Object)processId);
    }

    @Override
    public void remove(ProcessInstanceInfo processInstanceInfo) {
        this.getEntityManager().remove((Object)processInstanceInfo);
        TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        List correlations = this.getEntityManager().createNamedQuery("GetCorrelationKeysByProcessInstanceId").setParameter("pId", (Object)processInstanceInfo.getId()).getResultList();
        if (correlations != null) {
            for (CorrelationKeyInfo key : correlations) {
                this.getEntityManager().remove((Object)key);
            }
        }
    }

    @Override
    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager != null) {
            Query processInstancesForEvent = this.getEntityManager().createNamedQuery("ProcessInstancesWaitingForEvent");
            processInstancesForEvent.setParameter("type", (Object)type);
            return processInstancesForEvent.getResultList();
        }
        return new ArrayList<Long>();
    }

    @Override
    public CorrelationKeyInfo persist(CorrelationKeyInfo correlationKeyInfo) {
        Long processInstanceId = this.getProcessInstanceByCorrelationKey(correlationKeyInfo);
        if (processInstanceId != null) {
            throw new RuntimeException(correlationKeyInfo + " already exists");
        }
        EntityManager em = this.getEntityManager();
        em.persist((Object)correlationKeyInfo);
        if (this.pessimisticLocking) {
            em.flush();
            return (CorrelationKeyInfo)em.find(CorrelationKeyInfo.class, (Object)correlationKeyInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return correlationKeyInfo;
    }

    @Override
    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        Query processInstancesForEvent = this.getEntityManager().createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("ckey", (Object)correlationKey.toExternalForm());
        try {
            return (Long)processInstancesForEvent.getSingleResult();
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

