/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.json.DataSetLookupJSONMarshaller;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;

public class DataSetDefJSONMarshaller {
    public static final String UUID = "uuid";
    public static final String NAME = "name";
    public static final String PROVIDER = "provider";
    public static final String ISPUBLIC = "isPublic";
    public static final String PUSH_ENABLED = "pushEnabled";
    public static final String PUSH_MAXSIZE = "pushMaxSize";
    public static final String COLUMNS = "columns";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_TYPE = "type";
    public static final String COLUMN_PATTERN = "pattern";
    public static final String FILTERS = "filters";
    public static final String ALL_COLUMNS = "allColumns";
    public static final String FILEURL = "fileURL";
    public static final String FILEPATH = "filePath";
    public static final String SEPARATORCHAR = "separatorChar";
    public static final String QUOTECHAR = "quoteChar";
    public static final String ESCAPECHAR = "escapeChar";
    public static final String DATEPATTERN = "datePattern";
    public static final String NUMBERPATTERN = "numberPattern";
    public static final String DATA_SOURCE = "dataSource";
    public static final String DB_SCHEMA = "dbSchema";
    public static final String DB_TABLE = "dbTable";
    public static final String DB_SQL = "dbSQL";
    public static final String CACHE_ENABLED = "cacheEnabled";
    public static final String CACHE_MAXROWS = "cacheMaxRows";
    public static final String REFRESH_TIME = "refreshTime";
    public static final String REFRESH_ALWAYS = "refreshAlways";
    public static final String SERVER_URL = "serverURL";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String INDEX = "index";
    public static final String TYPE = "type";
    public static final String QUERY = "query";
    public static final String RELEVANCE = "relevance";
    public static final String CACHE_SYNCED = "cacheSynced";
    public static final String GENERATOR_CLASS = "generatorClass";
    public static final String GENERATOR_PARAMS = "generatorParams";
    public static final String PARAM = "param";
    public static final String VALUE = "value";
    private static DataSetDefJSONMarshaller SINGLETON = new DataSetDefJSONMarshaller();
    protected DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller;

    public static DataSetDefJSONMarshaller get() {
        return SINGLETON;
    }

    public DataSetDefJSONMarshaller() {
        this(DataSetLookupJSONMarshaller.get());
    }

    public DataSetDefJSONMarshaller(DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller) {
        this.dataSetLookupJSONMarshaller = dataSetLookupJSONMarshaller;
    }

    public DataSetDef fromJson(String jsonString) throws Exception {
        JsonObject json = Json.parse((String)jsonString);
        DataSetProviderType providerType = this.readProviderType(json);
        DataSetDef dataSetDef = DataSetProviderType.createDataSetDef(providerType);
        this.readGeneralSettings(dataSetDef, json);
        switch (providerType) {
            case CSV: {
                this.readCSVSettings((CSVDataSetDef)dataSetDef, json);
                break;
            }
            case SQL: {
                this.readSQLSettings((SQLDataSetDef)dataSetDef, json);
                break;
            }
            case ELASTICSEARCH: {
                this.readElasticSearchSettings((ElasticSearchDataSetDef)dataSetDef, json);
                break;
            }
            case BEAN: {
                this.readBeanSettings((BeanDataSetDef)dataSetDef, json);
            }
        }
        return dataSetDef;
    }

    public ElasticSearchDataSetDef readElasticSearchSettings(ElasticSearchDataSetDef dataSetDef, JsonObject json) throws Exception {
        String serverURL = json.getString(SERVER_URL);
        String clusterName = json.getString(CLUSTER_NAME);
        String index = json.getString(INDEX);
        String type = json.getString("type");
        String query = json.getString(QUERY);
        String relevance = json.getString(RELEVANCE);
        String cacheEnabled = json.getString(CACHE_ENABLED);
        String cacheMaxRows = json.getString(CACHE_MAXROWS);
        String cacheSynced = json.getString(CACHE_SYNCED);
        if (this.isBlank(serverURL)) {
            throw new IllegalArgumentException("The serverURL property is missing.");
        }
        dataSetDef.setServerURL(serverURL);
        if (this.isBlank(clusterName)) {
            throw new IllegalArgumentException("The clusterName property is missing.");
        }
        dataSetDef.setClusterName(clusterName);
        if (this.isBlank(index)) {
            throw new IllegalArgumentException("The index property is missing.");
        }
        dataSetDef.setIndex(index);
        if (!this.isBlank(type)) {
            dataSetDef.setType(type);
        }
        if (!this.isBlank(query)) {
            dataSetDef.setQuery(query);
        }
        if (!this.isBlank(relevance)) {
            dataSetDef.setRelevance(relevance);
        }
        if (!this.isBlank(cacheEnabled)) {
            dataSetDef.setCacheEnabled(Boolean.parseBoolean(cacheEnabled));
        }
        if (!this.isBlank(cacheMaxRows)) {
            dataSetDef.setCacheMaxRows(Integer.parseInt(cacheMaxRows));
        }
        return dataSetDef;
    }

    public DataSetProviderType readProviderType(JsonObject json) throws Exception {
        String provider = json.getString(PROVIDER);
        if (this.isBlank(provider)) {
            throw new IllegalArgumentException("Missing 'provider' property");
        }
        DataSetProviderType type = DataSetProviderType.getByName(provider);
        if (type == null) {
            throw new IllegalArgumentException("Provider not supported: " + provider);
        }
        return type;
    }

    public DataSetDef readGeneralSettings(DataSetDef def, JsonObject json) throws Exception {
        JsonArray array;
        String uuid = json.getString(UUID);
        String name = json.getString(NAME);
        String isPublic = json.getString(ISPUBLIC);
        String pushEnabled = json.getString(PUSH_ENABLED);
        String pushMaxSize = json.getString(PUSH_MAXSIZE);
        String cacheEnabled = json.getString(CACHE_ENABLED);
        String cacheMaxRows = json.getString(CACHE_MAXROWS);
        String refreshTime = json.getString(REFRESH_TIME);
        String refreshAlways = json.getString(REFRESH_ALWAYS);
        String allColumns = json.getString(ALL_COLUMNS);
        if (!this.isBlank(uuid)) {
            def.setUUID(uuid);
        }
        if (!this.isBlank(name)) {
            def.setName(name);
        }
        if (!this.isBlank(isPublic)) {
            def.setPublic(Boolean.parseBoolean(isPublic));
        }
        if (!this.isBlank(pushEnabled)) {
            def.setPushEnabled(Boolean.parseBoolean(pushEnabled));
        }
        if (!this.isBlank(pushMaxSize)) {
            def.setPushMaxSize(Integer.parseInt(pushMaxSize));
        }
        if (!this.isBlank(cacheEnabled)) {
            def.setCacheEnabled(Boolean.parseBoolean(cacheEnabled));
        }
        if (!this.isBlank(cacheMaxRows)) {
            def.setCacheMaxRows(Integer.parseInt(cacheMaxRows));
        }
        if (!this.isBlank(refreshTime)) {
            def.setRefreshTime(refreshTime);
        }
        if (!this.isBlank(refreshAlways)) {
            def.setRefreshAlways(Boolean.parseBoolean(refreshAlways));
        }
        if (!this.isBlank(allColumns)) {
            def.setAllColumnsEnabled(Boolean.parseBoolean(allColumns));
        }
        if (json.has(COLUMNS)) {
            array = json.getArray(COLUMNS);
            for (int i = 0; i < array.length(); ++i) {
                JsonObject column = array.getObject(i);
                String columnId = column.getString(COLUMN_ID);
                String columnType = column.getString("type");
                String columnPattern = column.getString(COLUMN_PATTERN);
                if (this.isBlank(columnId)) {
                    throw new IllegalArgumentException("Column id. attribute is mandatory.");
                }
                if (this.isBlank(columnType)) {
                    throw new IllegalArgumentException("Missing column 'type' attribute: " + columnId);
                }
                ColumnType type = ColumnType.TEXT;
                if (columnType.equalsIgnoreCase("label")) {
                    type = ColumnType.LABEL;
                } else if (columnType.equalsIgnoreCase("date")) {
                    type = ColumnType.DATE;
                } else if (columnType.equalsIgnoreCase("number")) {
                    type = ColumnType.NUMBER;
                }
                def.addColumn(columnId, type);
                if (this.isBlank(columnPattern)) continue;
                def.setPattern(columnId, columnPattern);
            }
        }
        if (json.has(FILTERS)) {
            array = json.getArray(FILTERS);
            DataSetFilter dataSetFilter = this.dataSetLookupJSONMarshaller.parseFilterOperation(array);
            def.setDataSetFilter(dataSetFilter);
        }
        return def;
    }

    public DataSetDef readBeanSettings(BeanDataSetDef def, JsonObject json) throws Exception {
        String generator = json.getString(GENERATOR_CLASS);
        if (!this.isBlank(generator)) {
            def.setGeneratorClass(generator);
        }
        if (json.has(GENERATOR_PARAMS)) {
            JsonArray array = json.getArray(GENERATOR_PARAMS);
            for (int i = 0; i < array.length(); ++i) {
                JsonObject param = array.getObject(i);
                String paramId = param.getString(PARAM);
                String value = param.getString(VALUE);
                if (this.isBlank(paramId)) continue;
                def.getParamaterMap().put(paramId, value);
            }
        }
        return def;
    }

    public CSVDataSetDef readCSVSettings(CSVDataSetDef def, JsonObject json) throws Exception {
        String fileURL = json.getString(FILEURL);
        String filePath = json.getString(FILEPATH);
        String separatorChar = this.parseCodePoint(json.getString(SEPARATORCHAR));
        String quoteChar = this.parseCodePoint(json.getString(QUOTECHAR));
        String escapeChar = this.parseCodePoint(json.getString(ESCAPECHAR));
        String datePattern = json.getString(DATEPATTERN);
        String numberPattern = json.getString(NUMBERPATTERN);
        if (!this.isBlank(fileURL)) {
            def.setFileURL(fileURL);
        }
        if (!this.isBlank(filePath)) {
            def.setFilePath(filePath);
        }
        if (!this.isBlank(separatorChar)) {
            def.setSeparatorChar(Character.valueOf(separatorChar.charAt(0)));
        }
        if (!this.isBlank(quoteChar)) {
            def.setQuoteChar(Character.valueOf(quoteChar.charAt(0)));
        }
        if (!this.isBlank(escapeChar)) {
            def.setEscapeChar(Character.valueOf(escapeChar.charAt(0)));
        }
        if (!this.isBlank(numberPattern)) {
            def.setNumberPattern(numberPattern);
        }
        if (!this.isBlank(datePattern)) {
            def.setDatePattern(datePattern);
        }
        return def;
    }

    public String parseCodePoint(String codePoint) {
        try {
            if (!this.isBlank(codePoint)) {
                return String.valueOf(Character.toChars(Integer.parseInt(codePoint)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codePoint;
    }

    public SQLDataSetDef readSQLSettings(SQLDataSetDef def, JsonObject json) throws Exception {
        String dataSource = json.getString(DATA_SOURCE);
        String dbTable = json.getString(DB_TABLE);
        String dbSchema = json.getString(DB_SCHEMA);
        String dbSQL = json.getString(DB_SQL);
        if (!this.isBlank(dataSource)) {
            def.setDataSource(dataSource);
        }
        if (!this.isBlank(dbSchema)) {
            def.setDbSchema(dbSchema);
        }
        if (!this.isBlank(dbTable)) {
            def.setDbTable(dbTable);
        }
        if (!this.isBlank(dbSQL)) {
            def.setDbSQL(dbSQL);
        }
        return def;
    }

    public String toJsonString(DataSetDef dataSetDef) throws JsonException {
        return this.toJsonObject(dataSetDef).toString();
    }

    public JsonObject toJsonObject(DataSetDef dataSetDef) throws JsonException {
        DataSetFilter filter;
        JsonArray columnsArray;
        JsonObject json = Json.createObject();
        json.put(UUID, dataSetDef.getUUID());
        json.put(NAME, dataSetDef.getName());
        json.put(PROVIDER, dataSetDef.getProvider().name());
        json.put(ISPUBLIC, dataSetDef.isPublic());
        json.put(CACHE_ENABLED, dataSetDef.isCacheEnabled());
        json.put(CACHE_MAXROWS, (double)dataSetDef.getCacheMaxRows().intValue());
        json.put(PUSH_ENABLED, dataSetDef.isPushEnabled());
        json.put(PUSH_MAXSIZE, (double)dataSetDef.getPushMaxSize().intValue());
        json.put(REFRESH_ALWAYS, dataSetDef.isRefreshAlways());
        json.put(REFRESH_TIME, dataSetDef.getRefreshTime());
        if (dataSetDef instanceof BeanDataSetDef) {
            this.toJsonObject((BeanDataSetDef)dataSetDef, json);
        } else if (dataSetDef instanceof CSVDataSetDef) {
            this.toJsonObject((CSVDataSetDef)dataSetDef, json);
        } else if (dataSetDef instanceof SQLDataSetDef) {
            this.toJsonObject((SQLDataSetDef)dataSetDef, json);
        } else if (dataSetDef instanceof ElasticSearchDataSetDef) {
            this.toJsonObject((ElasticSearchDataSetDef)dataSetDef, json);
        }
        List<DataColumnDef> columns = dataSetDef.getColumns();
        if (columns != null && (columnsArray = this.toJsonObject(columns, dataSetDef)) != null) {
            json.put(COLUMNS, (JsonValue)columnsArray);
        }
        if ((filter = dataSetDef.getDataSetFilter()) != null) {
            try {
                JsonArray filters = this.dataSetLookupJSONMarshaller.formatColumnFilters(filter.getColumnFilterList());
                if (filters != null) {
                    json.put(FILTERS, (JsonValue)filters);
                }
            }
            catch (Exception e) {
                throw new JsonException(e);
            }
        }
        return json;
    }

    protected JsonArray toJsonObject(Collection<DataColumnDef> columnList, DataSetDef dataSetDef) throws JsonException {
        JsonArray result = null;
        if (columnList != null && !columnList.isEmpty()) {
            result = Json.createArray();
            int idx = 0;
            for (DataColumnDef column : columnList) {
                String id = column.getId();
                ColumnType type = column.getColumnType();
                JsonObject columnObject = Json.createObject();
                columnObject.put(COLUMN_ID, id);
                columnObject.put("type", type.name().toLowerCase());
                String pattern = dataSetDef.getPattern(id);
                if (pattern != null && pattern.trim().length() > 0) {
                    columnObject.put(COLUMN_PATTERN, pattern);
                }
                result.set(idx++, (JsonValue)columnObject);
            }
        }
        return result;
    }

    protected void toJsonObject(BeanDataSetDef dataSetDef, JsonObject json) throws JsonException {
        json.put(GENERATOR_CLASS, dataSetDef.getGeneratorClass());
        Map<String, String> parameters = dataSetDef.getParamaterMap();
        if (parameters != null && !parameters.isEmpty()) {
            JsonArray array = Json.createArray();
            int idx = 0;
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                JsonObject paramObject = this.toJsonParameter(param.getKey(), param.getValue());
                array.set(idx++, (JsonValue)paramObject);
            }
            json.put(GENERATOR_PARAMS, (JsonValue)array);
        }
    }

    protected void toJsonObject(CSVDataSetDef dataSetDef, JsonObject json) throws JsonException {
        if (dataSetDef.getFilePath() != null) {
            json.put(FILEPATH, dataSetDef.getFilePath());
        }
        if (dataSetDef.getFileURL() != null) {
            json.put(FILEURL, dataSetDef.getFileURL());
        }
        json.put(SEPARATORCHAR, String.valueOf(dataSetDef.getSeparatorChar()));
        json.put(QUOTECHAR, String.valueOf(dataSetDef.getQuoteChar()));
        json.put(ESCAPECHAR, String.valueOf(dataSetDef.getEscapeChar()));
        json.put(DATEPATTERN, dataSetDef.getDatePattern());
        json.put(NUMBERPATTERN, dataSetDef.getNumberPattern());
        json.put(ALL_COLUMNS, dataSetDef.isAllColumnsEnabled());
    }

    protected void toJsonObject(SQLDataSetDef dataSetDef, JsonObject json) throws JsonException {
        json.put(DATA_SOURCE, dataSetDef.getDataSource());
        json.put(DB_SCHEMA, dataSetDef.getDbSchema());
        if (dataSetDef.getDbTable() != null) {
            json.put(DB_TABLE, dataSetDef.getDbTable());
        }
        if (dataSetDef.getDbSQL() != null) {
            json.put(DB_SQL, dataSetDef.getDbSQL());
        }
        json.put(ALL_COLUMNS, dataSetDef.isAllColumnsEnabled());
    }

    protected void toJsonObject(ElasticSearchDataSetDef dataSetDef, JsonObject json) throws JsonException {
        json.put(SERVER_URL, dataSetDef.getServerURL());
        json.put(CLUSTER_NAME, dataSetDef.getClusterName());
        json.put(INDEX, dataSetDef.getIndex());
        json.put("type", dataSetDef.getType());
        json.put(ALL_COLUMNS, dataSetDef.isAllColumnsEnabled());
    }

    protected JsonObject toJsonParameter(String key, String value) throws JsonException {
        JsonObject json = Json.createObject();
        json.put(PARAM, key);
        json.put(VALUE, value);
        return json;
    }

    protected boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

