/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;

public class PeopleAssignmentHelper {
    public static final String ACTOR_ID = "ActorId";
    public static final String GROUP_ID = "GroupId";
    public static final String BUSINESSADMINISTRATOR_ID = "BusinessAdministratorId";
    public static final String BUSINESSADMINISTRATOR_GROUP_ID = "BusinessAdministratorGroupId";
    public static final String TASKSTAKEHOLDER_ID = "TaskStakeholderId";
    public static final String EXCLUDED_OWNER_ID = "ExcludedOwnerId";
    public static final String RECIPIENT_ID = "RecipientId";
    private String separator;

    public PeopleAssignmentHelper() {
        this.separator = System.getProperty("org.jbpm.ht.user.separator", ",");
    }

    public PeopleAssignmentHelper(String separator) {
        this.separator = separator;
    }

    public void handlePeopleAssignments(WorkItem workItem, InternalTask task, InternalTaskData taskData) {
        InternalPeopleAssignments peopleAssignments = this.getNullSafePeopleAssignments((Task)task);
        this.assignActors(workItem, (PeopleAssignments)peopleAssignments, taskData);
        this.assignGroups(workItem, (PeopleAssignments)peopleAssignments);
        this.assignBusinessAdministrators(workItem, (PeopleAssignments)peopleAssignments);
        this.assignTaskStakeholders(workItem, peopleAssignments);
        this.assignExcludedOwners(workItem, peopleAssignments);
        this.assignRecipients(workItem, peopleAssignments);
        task.setPeopleAssignments((PeopleAssignments)peopleAssignments);
    }

    protected void assignActors(WorkItem workItem, PeopleAssignments peopleAssignments, InternalTaskData taskData) {
        String actorIds = (String)workItem.getParameter(ACTOR_ID);
        List potentialOwners = peopleAssignments.getPotentialOwners();
        this.processPeopleAssignments(actorIds, potentialOwners, true);
        if (potentialOwners.size() > 0 && taskData.getCreatedBy() == null) {
            OrganizationalEntity firstPotentialOwner = (OrganizationalEntity)potentialOwners.get(0);
            taskData.setCreatedBy((User)firstPotentialOwner);
        }
    }

    protected void assignGroups(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String groupIds = (String)workItem.getParameter(GROUP_ID);
        List potentialOwners = peopleAssignments.getPotentialOwners();
        this.processPeopleAssignments(groupIds, potentialOwners, false);
    }

    protected void assignBusinessAdministrators(WorkItem workItem, PeopleAssignments peopleAssignments) {
        String businessAdminGroupIds = (String)workItem.getParameter(BUSINESSADMINISTRATOR_GROUP_ID);
        String businessAdministratorIds = (String)workItem.getParameter(BUSINESSADMINISTRATOR_ID);
        List businessAdministrators = peopleAssignments.getBusinessAdministrators();
        if (!this.hasAdminAssigned(businessAdministrators)) {
            User administrator = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)administrator).setId("Administrator");
            businessAdministrators.add(administrator);
            Group adminGroup = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)adminGroup).setId("Administrators");
            businessAdministrators.add(adminGroup);
        }
        this.processPeopleAssignments(businessAdministratorIds, businessAdministrators, true);
        this.processPeopleAssignments(businessAdminGroupIds, businessAdministrators, false);
    }

    protected void assignTaskStakeholders(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        String taskStakehodlerIds = (String)workItem.getParameter(TASKSTAKEHOLDER_ID);
        List taskStakeholders = peopleAssignments.getTaskStakeholders();
        this.processPeopleAssignments(taskStakehodlerIds, taskStakeholders, true);
    }

    protected void assignExcludedOwners(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        String excludedOwnerIds = (String)workItem.getParameter(EXCLUDED_OWNER_ID);
        List excludedOwners = peopleAssignments.getExcludedOwners();
        this.processPeopleAssignments(excludedOwnerIds, excludedOwners, true);
    }

    protected void assignRecipients(WorkItem workItem, InternalPeopleAssignments peopleAssignments) {
        String recipientIds = (String)workItem.getParameter(RECIPIENT_ID);
        List recipients = peopleAssignments.getRecipients();
        this.processPeopleAssignments(recipientIds, recipients, true);
    }

    protected void processPeopleAssignments(String peopleAssignmentIds, List<OrganizationalEntity> organizationalEntities, boolean user) {
        if (peopleAssignmentIds != null && peopleAssignmentIds.trim().length() > 0) {
            String[] ids;
            for (String id : ids = peopleAssignmentIds.split(this.separator)) {
                if ((id = id.trim()).length() == 0) continue;
                boolean exists = false;
                for (OrganizationalEntity orgEntity : organizationalEntities) {
                    if (!orgEntity.getId().equals(id)) continue;
                    exists = true;
                }
                if (exists) continue;
                User organizationalEntity = null;
                if (user) {
                    organizationalEntity = TaskModelProvider.getFactory().newUser();
                    ((InternalOrganizationalEntity)organizationalEntity).setId(id);
                } else {
                    organizationalEntity = TaskModelProvider.getFactory().newGroup();
                    ((InternalOrganizationalEntity)organizationalEntity).setId(id);
                }
                organizationalEntities.add((OrganizationalEntity)organizationalEntity);
            }
        }
    }

    protected InternalPeopleAssignments getNullSafePeopleAssignments(Task task) {
        InternalPeopleAssignments peopleAssignments = (InternalPeopleAssignments)task.getPeopleAssignments();
        if (peopleAssignments == null) {
            peopleAssignments = (InternalPeopleAssignments)TaskModelProvider.getFactory().newPeopleAssignments();
            peopleAssignments.setPotentialOwners(new ArrayList());
            peopleAssignments.setBusinessAdministrators(new ArrayList());
            peopleAssignments.setExcludedOwners(new ArrayList());
            peopleAssignments.setRecipients(new ArrayList());
            peopleAssignments.setTaskStakeholders(new ArrayList());
        }
        return peopleAssignments;
    }

    protected boolean hasAdminAssigned(Collection<OrganizationalEntity> businessAdmins) {
        for (OrganizationalEntity entity : businessAdmins) {
            if (!"Administrator".equals(entity.getId()) && !"Administrators".equals(entity.getId())) continue;
            return true;
        }
        return false;
    }
}

