/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.ClassUtils;

public class DroolsObjectInputStream
extends ObjectInputStream
implements DroolsObjectInput {
    private ClassLoader classLoader;
    private InternalKnowledgeBase kBase;
    private InternalWorkingMemory workingMemory;
    private Package pkg;
    private ClassFieldAccessorStore store;
    private Map<AccessorKey, List<Consumer<InternalReadAccessor>>> extractorBinders = new HashMap<AccessorKey, List<Consumer<InternalReadAccessor>>>();

    public DroolsObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public DroolsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    protected Class resolveClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClassFromName(className, true, this.classLoader);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.resolveClass(desc.getName());
    }

    public static InvalidClassException newInvalidClassException(Class clazz, Throwable cause) {
        InvalidClassException exception = new InvalidClassException(clazz.getName());
        exception.initCause(cause);
        return exception;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    @Override
    public void setKnowledgeBase(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.classLoader = this.kBase.getRootClassLoader();
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.classLoader;
    }

    public void setStore(ClassFieldAccessorStore store) {
        this.store = store;
    }

    public void readExtractor(Consumer<InternalReadAccessor> binder) throws ClassNotFoundException, IOException {
        Object accessor = this.readObject();
        if (accessor instanceof AccessorKey) {
            ClassFieldReader reader;
            ClassFieldReader classFieldReader = reader = this.store != null ? this.store.getReader((AccessorKey)accessor) : null;
            if (reader == null) {
                List<Consumer<InternalReadAccessor>> list = this.extractorBinders.get((AccessorKey)accessor);
                if (list == null) {
                    list = new ArrayList<Consumer<InternalReadAccessor>>();
                    this.extractorBinders.put((AccessorKey)accessor, list);
                }
                list.add(binder);
            } else {
                binder.accept(reader);
            }
        } else {
            binder.accept((InternalReadAccessor)accessor);
        }
    }

    public void bindAllExtractors(InternalKnowledgeBase kbase) {
        block0: for (Map.Entry<AccessorKey, List<Consumer<InternalReadAccessor>>> entry : this.extractorBinders.entrySet()) {
            for (InternalKnowledgePackage pkg : kbase.getPackagesMap().values()) {
                ClassFieldReader reader = pkg.getClassFieldAccessorStore().getReader(entry.getKey());
                if (reader == null) continue;
                for (Consumer<InternalReadAccessor> consumer : entry.getValue()) {
                    consumer.accept(reader);
                }
                continue block0;
            }
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public static interface Consumer<T> {
        public void accept(T var1);
    }
}

