/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.persistence.SessionNotFoundException;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.runtime.manager.impl.migration.MigrationEntry;
import org.jbpm.runtime.manager.impl.migration.MigrationReport;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.kie.api.KieBase;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationManager {
    private static final Logger logger = LoggerFactory.getLogger(MigrationManager.class);
    private MigrationReport report;
    private MigrationSpec migrationSpec;

    public MigrationManager(MigrationSpec migrationSpec) {
        this.report = new MigrationReport(migrationSpec);
        this.migrationSpec = migrationSpec;
    }

    public MigrationReport migrate() {
        return this.migrate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationReport migrate(Map<String, String> nodeMapping) {
        this.validate();
        StatefulKnowledgeSession current = null;
        StatefulKnowledgeSession tobe = null;
        TransactionManager txm = null;
        boolean transactionOwner = false;
        InternalRuntimeManager currentManager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(this.migrationSpec.getDeploymentId());
        InternalRuntimeManager toBeManager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(this.migrationSpec.getToDeploymentId());
        Map<Long, List<TimerInstance>> timerMigrated = null;
        try {
            timerMigrated = this.cancelActiveTimersBeforeMigration((RuntimeManager)currentManager);
            txm = TransactionManagerFactory.get().newTransactionManager(currentManager.getEnvironment().getEnvironment());
            transactionOwner = txm.begin();
            Process toBeProcess = toBeManager.getEnvironment().getKieBase().getProcess(this.migrationSpec.getToProcessId());
            String auditPu = currentManager.getDeploymentDescriptor().getAuditPersistenceUnit();
            EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(auditPu);
            EntityManager em = emf.createEntityManager();
            try {
                Query varLogQuery = em.createQuery("update VariableInstanceLog set externalId = :depId, processId = :procId where processInstanceId = :procInstanceId");
                varLogQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                int varsUpdated = varLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Variable instances updated = " + varsUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                Query nodeLogQuery = em.createQuery("update NodeInstanceLog set externalId = :depId, processId = :procId where processInstanceId = :procInstanceId");
                nodeLogQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                int nodesUpdated = nodeLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Node instances updated = " + nodesUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                Query pInstanceLogQuery = em.createQuery("update ProcessInstanceLog set externalId = :depId, processId = :procId, processName = :procName, processVersion= :procVersion where processInstanceId = :procInstanceId");
                pInstanceLogQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procName", (Object)toBeProcess.getName()).setParameter("procVersion", (Object)toBeProcess.getVersion()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                int pInstancesUpdated = pInstanceLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Process instances updated = " + pInstancesUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                try {
                    Query taskVarLogQuery = em.createQuery("update TaskVariableImpl set processId = :procId where processInstanceId = :procInstanceId");
                    taskVarLogQuery.setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                    int taskVarUpdated = taskVarLogQuery.executeUpdate();
                    this.report.addEntry(MigrationEntry.Type.INFO, "Task variables updated = " + taskVarUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                }
                catch (Throwable e) {
                    logger.warn("Unexpected error during migration", e);
                    this.report.addEntry(MigrationEntry.Type.WARN, "Cannot update task variables (added in version 6.3) due to " + e.getMessage());
                }
                Query auditTaskLogQuery = em.createQuery("update AuditTaskImpl set deploymentId = :depId, processId = :procId where processInstanceId = :procInstanceId");
                auditTaskLogQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                int auditTaskUpdated = auditTaskLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Task audit updated = " + auditTaskUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                Query taskLogQuery = em.createQuery("update TaskImpl set deploymentId = :depId, processId = :procId where processInstanceId = :procInstanceId");
                taskLogQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procId", (Object)this.migrationSpec.getToProcessId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId());
                int taskUpdated = taskLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Tasks updated = " + taskUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                try {
                    Query contextInfoQuery = em.createQuery("update ContextMappingInfo set ownerId = :depId where contextId = :procInstanceId");
                    contextInfoQuery.setParameter("depId", (Object)this.migrationSpec.getToDeploymentId()).setParameter("procInstanceId", (Object)this.migrationSpec.getProcessInstanceId().toString());
                    int contextInfoUpdated = contextInfoQuery.executeUpdate();
                    this.report.addEntry(MigrationEntry.Type.INFO, "Context info updated = " + contextInfoUpdated + " for process instance id " + this.migrationSpec.getProcessInstanceId());
                }
                catch (Throwable e) {
                    logger.warn("Unexpected error during migration", e);
                    this.report.addEntry(MigrationEntry.Type.WARN, "Cannot update context mapping owner (added in version 6.2) due to " + e.getMessage());
                }
                current = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)currentManager.getEnvironment().getKieBase(), null, (Environment)currentManager.getEnvironment().getEnvironment());
                tobe = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)toBeManager.getEnvironment().getKieBase(), null, (Environment)toBeManager.getEnvironment().getEnvironment());
                this.upgradeProcessInstance((KieRuntime)current, (KieRuntime)tobe, this.migrationSpec.getProcessInstanceId(), this.migrationSpec.getToProcessId(), nodeMapping, em, toBeManager.getIdentifier());
                if (!timerMigrated.isEmpty()) {
                    this.rescheduleTimersAfterMigration((RuntimeManager)toBeManager, timerMigrated);
                }
                em.flush();
            }
            finally {
                em.clear();
                em.close();
            }
            txm.commit(transactionOwner);
            this.report.addEntry(MigrationEntry.Type.INFO, "Migration of process instance (" + this.migrationSpec.getProcessInstanceId() + ") completed successfully to process " + this.migrationSpec.getToProcessId());
            this.report.setSuccessful(true);
            this.report.setEndDate(new Date());
        }
        catch (Throwable e) {
            txm.rollback(transactionOwner);
            logger.error("Unexpected error during migration", e);
            if (timerMigrated != null && !timerMigrated.isEmpty()) {
                this.rescheduleTimersAfterMigration((RuntimeManager)currentManager, timerMigrated);
            }
            this.report.addEntry(MigrationEntry.Type.ERROR, "Migration of process instance (" + this.migrationSpec.getProcessInstanceId() + ") failed due to " + e.getMessage());
        }
        finally {
            if (current != null) {
                try {
                    current.destroy();
                }
                catch (SessionNotFoundException toBeProcess) {}
            }
            if (tobe != null) {
                try {
                    tobe.destroy();
                }
                catch (SessionNotFoundException toBeProcess) {}
            }
        }
        return this.report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() {
        InternalRuntimeManager sourceManager;
        InternalRuntimeManager manager;
        if (this.migrationSpec == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "no process data given for migration");
        }
        if (this.isEmpty(this.migrationSpec.getDeploymentId())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No deployment id set");
        }
        if (this.migrationSpec.getProcessInstanceId() == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No process instance id set");
        }
        if (this.isEmpty(this.migrationSpec.getToDeploymentId())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No target deployment id set");
        }
        if (this.isEmpty(this.migrationSpec.getToProcessId())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No target process id set");
        }
        if (!RuntimeManagerRegistry.get().isRegistered(this.migrationSpec.getDeploymentId())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No deployment found for " + this.migrationSpec.getDeploymentId());
        }
        if (!RuntimeManagerRegistry.get().isRegistered(this.migrationSpec.getToDeploymentId())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No target deployment found for " + this.migrationSpec.getToDeploymentId());
        }
        if ((manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(this.migrationSpec.getToDeploymentId())).getEnvironment().getKieBase().getProcess(this.migrationSpec.getToProcessId()) == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "No process found for " + this.migrationSpec.getToProcessId() + " in deployment " + this.migrationSpec.getToDeploymentId());
        }
        if (!(sourceManager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(this.migrationSpec.getDeploymentId())).getClass().isAssignableFrom(manager.getClass())) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "Source (" + sourceManager.getClass().getName() + ") and target (" + manager.getClass().getName() + ") deployments are of different type (they represent different runtime strategies)");
        }
        String auditPu = manager.getDeploymentDescriptor().getAuditPersistenceUnit();
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(auditPu);
        JPAAuditLogService auditService = new JPAAuditLogService(emf);
        try {
            ProcessInstanceLog log = auditService.findProcessInstance(this.migrationSpec.getProcessInstanceId().longValue());
            if (log == null || log.getStatus() != 1) {
                this.report.addEntry(MigrationEntry.Type.ERROR, "No process instance found or it is not active (id " + this.migrationSpec.getProcessInstanceId() + " in status " + (log == null ? "-1" : log.getStatus()));
            }
        }
        finally {
            auditService.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeProcessInstance(KieRuntime oldkruntime, KieRuntime kruntime, long processInstanceId, String processId, Map<String, String> nodeMapping, EntityManager em, String deploymentId) {
        WorkflowProcess process;
        WorkflowProcessInstanceImpl processInstance;
        if (nodeMapping == null) {
            nodeMapping = new HashMap<String, String>();
        }
        if ((processInstance = (WorkflowProcessInstanceImpl)oldkruntime.getProcessInstance(processInstanceId)) == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "Null process id");
        }
        if ((process = (WorkflowProcess)kruntime.getKieBase().getProcess(processId)) == null) {
            this.report.addEntry(MigrationEntry.Type.ERROR, "Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            this.report.addEntry(MigrationEntry.Type.WARN, "Source and target process id is exactly the same (" + processId + ") it's recommended to use unique process ids");
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            this.updateNodeInstances((NodeInstanceContainer)processInstance, nodeMapping, (NodeContainer)process, em);
            processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)this.extractIfNeeded(kruntime));
            processInstance.setDeploymentId(deploymentId);
            processInstance.setProcess((Process)process);
            processInstance.reconnect();
        }
    }

    private void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, String> nodeMapping, NodeContainer nodeContainer, EntityManager em) {
        for (NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            Node upgradedNode;
            String oldNodeId;
            Long upgradedNodeId;
            block7: {
                if (nodeInstance.getNode() == null) continue;
                if (nodeInstance instanceof NodeInstanceContainer) {
                    this.updateNodeInstances((NodeInstanceContainer)nodeInstance, nodeMapping, nodeContainer, em);
                }
                upgradedNodeId = null;
                oldNodeId = (String)((NodeImpl)((org.jbpm.workflow.instance.NodeInstance)nodeInstance).getNode()).getMetaData().get("UniqueId");
                String newNodeId = nodeMapping.get(oldNodeId);
                if (newNodeId == null) {
                    newNodeId = oldNodeId;
                }
                if ((upgradedNode = this.findNodeByUniqueId(newNodeId, nodeContainer)) == null) {
                    try {
                        upgradedNodeId = Long.parseLong(newNodeId);
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                upgradedNodeId = upgradedNode.getId();
            }
            ((NodeInstanceImpl)nodeInstance).setNodeId(upgradedNodeId.longValue());
            if (upgradedNode == null) continue;
            Query nodeInstanceIdQuery = em.createQuery("select nodeInstanceId from NodeInstanceLog nil where nil.nodeId = :oldNodeId and processInstanceId = :processInstanceId  GROUP BY nil.nodeInstanceId HAVING sum(nil.type) = 0");
            nodeInstanceIdQuery.setParameter("oldNodeId", (Object)oldNodeId).setParameter("processInstanceId", (Object)nodeInstance.getProcessInstance().getId());
            List nodeInstanceIds = nodeInstanceIdQuery.getResultList();
            this.report.addEntry(MigrationEntry.Type.INFO, "Mapping: Node instance logs to be updated  = " + nodeInstanceIds);
            if (!nodeInstanceIds.isEmpty()) {
                Query nodeLogQuery = em.createQuery("update NodeInstanceLog set nodeId = :nodeId, nodeName = :nodeName, nodeType = :nodeType where nodeInstanceId in (:ids) and processInstanceId = :processInstanceId");
                nodeLogQuery.setParameter("nodeId", (Object)((String)upgradedNode.getMetaData().get("UniqueId"))).setParameter("nodeName", (Object)upgradedNode.getName()).setParameter("nodeType", (Object)upgradedNode.getClass().getSimpleName()).setParameter("ids", (Object)nodeInstanceIds).setParameter("processInstanceId", (Object)nodeInstance.getProcessInstance().getId());
                int nodesUpdated = nodeLogQuery.executeUpdate();
                this.report.addEntry(MigrationEntry.Type.INFO, "Mapping: Node instance logs updated = " + nodesUpdated + " for node instance id " + nodeInstance.getId());
            }
            if (!(upgradedNode instanceof HumanTaskNode) || !(nodeInstance instanceof HumanTaskNodeInstance)) continue;
            Long taskId = (Long)em.createQuery("select id from TaskImpl where workItemId = :workItemId").setParameter("workItemId", (Object)((HumanTaskNodeInstance)nodeInstance).getWorkItemId()).getSingleResult();
            String name = ((HumanTaskNode)upgradedNode).getName();
            String description = (String)((HumanTaskNode)upgradedNode).getWork().getParameter("Description");
            Query auditTaskLogQuery = em.createQuery("update AuditTaskImpl set name = :name, description = :description where taskId = :taskId");
            auditTaskLogQuery.setParameter("name", (Object)name).setParameter("description", (Object)description).setParameter("taskId", (Object)taskId);
            int auditTaskUpdated = auditTaskLogQuery.executeUpdate();
            this.report.addEntry(MigrationEntry.Type.INFO, "Mapping: Task audit updated = " + auditTaskUpdated + " for task id " + taskId);
            Query taskLogQuery = em.createQuery("update TaskImpl set name = :name, description = :description where id = :taskId");
            taskLogQuery.setParameter("name", (Object)name).setParameter("description", (Object)description).setParameter("taskId", (Object)taskId);
            int taskUpdated = taskLogQuery.executeUpdate();
            this.report.addEntry(MigrationEntry.Type.INFO, "Mapping: Task updated = " + taskUpdated + " for task id " + taskId);
        }
    }

    private Node findNodeByUniqueId(String uniqueId, NodeContainer nodeContainer) {
        Node result = null;
        for (Node node : nodeContainer.getNodes()) {
            if (uniqueId.equals(node.getMetaData().get("UniqueId"))) {
                return node;
            }
            if (!(node instanceof NodeContainer) || (result = this.findNodeByUniqueId(uniqueId, (NodeContainer)node)) == null) continue;
            return result;
        }
        return result;
    }

    private KieRuntime extractIfNeeded(KieRuntime ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            return ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession();
        }
        return ksession;
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    protected TimerManager getTimerManager(KieSession ksession) {
        KieSession internal = ksession;
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            internal = ((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService().getContext()).getKieSession();
        }
        return ((InternalProcessRuntime)((StatefulKnowledgeSessionImpl)internal).getProcessRuntime()).getTimerManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, List<TimerInstance>> cancelActiveTimersBeforeMigration(RuntimeManager manager) {
        RuntimeEngine engineBefore = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.migrationSpec.getProcessInstanceId()));
        try {
            Map timerMigrated;
            Map map = timerMigrated = (Map)engineBefore.getKieSession().execute((Command)new GenericCommand<Map<Long, List<TimerInstance>>>(){
                private static final long serialVersionUID = 7144271692067781976L;

                public Map<Long, List<TimerInstance>> execute(org.kie.internal.command.Context context) {
                    LinkedHashMap<Long, List<TimerInstance>> result = new LinkedHashMap<Long, List<TimerInstance>>();
                    KieSession kieSession = ((KnowledgeCommandContext)context).getKieSession();
                    TimerManager timerManager = MigrationManager.this.getTimerManager(kieSession);
                    WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)kieSession.getProcessInstance(MigrationManager.this.migrationSpec.getProcessInstanceId().longValue());
                    Collection activeInstances = processInstance.getNodeInstances(true);
                    for (org.jbpm.workflow.instance.NodeInstance active : activeInstances) {
                        List timers;
                        if (active instanceof TimerNodeInstance) {
                            TimerInstance timerInstance = (TimerInstance)timerManager.getTimerMap().get(((TimerNodeInstance)active).getTimerId());
                            timerManager.cancelTimer(timerInstance.getId());
                            result.put(active.getId(), Arrays.asList(timerInstance));
                            continue;
                        }
                        if (!(active instanceof StateBasedNodeInstance) || (timers = ((StateBasedNodeInstance)active).getTimerInstances()) == null || timers.isEmpty()) continue;
                        ArrayList<TimerInstance> collected = new ArrayList<TimerInstance>();
                        for (Long timerId : timers) {
                            TimerInstance timerInstance = (TimerInstance)timerManager.getTimerMap().get(timerId);
                            timerManager.cancelTimer(timerInstance.getId());
                            collected.add(timerInstance);
                        }
                        result.put(active.getId(), collected);
                    }
                    return result;
                }
            });
            return map;
        }
        finally {
            manager.disposeRuntimeEngine(engineBefore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleTimersAfterMigration(RuntimeManager manager, final Map<Long, List<TimerInstance>> timerMigrated) {
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.migrationSpec.getProcessInstanceId()));
        try {
            engine.getKieSession().execute((Command)new GenericCommand<Void>(){
                private static final long serialVersionUID = 7144657913971146080L;

                public Void execute(org.kie.internal.command.Context context) {
                    KieSession kieSession = ((KnowledgeCommandContext)context).getKieSession();
                    TimerManager timerManager = MigrationManager.this.getTimerManager(kieSession);
                    WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)kieSession.getProcessInstance(MigrationManager.this.migrationSpec.getProcessInstanceId().longValue());
                    for (Map.Entry entry : timerMigrated.entrySet()) {
                        org.jbpm.workflow.instance.NodeInstance active = processInstance.getNodeInstance(((Long)entry.getKey()).longValue(), true);
                        if (active instanceof TimerNodeInstance) {
                            TimerInstance timerInstance = (TimerInstance)((List)entry.getValue()).get(0);
                            long delay = timerInstance.getDelay() - (System.currentTimeMillis() - timerInstance.getActivated().getTime());
                            timerInstance.setDelay(delay);
                            MigrationManager.this.updateBasedOnTrigger(timerInstance);
                            timerManager.registerTimer(timerInstance, (ProcessInstance)processInstance);
                            ((TimerNodeInstance)active).internalSetTimerId(timerInstance.getId());
                            continue;
                        }
                        if (!(active instanceof StateBasedNodeInstance)) continue;
                        List timerInstances = (List)entry.getValue();
                        ArrayList<Long> timers = new ArrayList<Long>();
                        for (TimerInstance timerInstance : timerInstances) {
                            long delay = timerInstance.getDelay() - (System.currentTimeMillis() - timerInstance.getActivated().getTime());
                            timerInstance.setDelay(delay);
                            MigrationManager.this.updateBasedOnTrigger(timerInstance);
                            timerManager.registerTimer(timerInstance, (ProcessInstance)processInstance);
                            timers.add(timerInstance.getId());
                        }
                        ((StateBasedNodeInstance)active).internalSetTimerInstances(timers);
                    }
                    return null;
                }
            });
        }
        finally {
            manager.disposeRuntimeEngine(engine);
        }
    }

    protected void updateBasedOnTrigger(TimerInstance timerInstance) {
        Trigger trigger = ((DefaultJobHandle)timerInstance.getJobHandle()).getTimerJobInstance().getTrigger();
        if (trigger instanceof IntervalTrigger && timerInstance.getPeriod() > 0L) {
            IntervalTrigger intervalTrigger = (IntervalTrigger)trigger;
            if (timerInstance.getRepeatLimit() > 0) {
                timerInstance.setRepeatLimit(intervalTrigger.getRepeatLimit() - intervalTrigger.getRepeatCount() + 1);
            }
            long delay = intervalTrigger.getLastFireTime() != null ? timerInstance.getPeriod() - (System.currentTimeMillis() - intervalTrigger.getLastFireTime().getTime()) : timerInstance.getDelay() - (System.currentTimeMillis() - intervalTrigger.getCreatedTime().getTime());
            timerInstance.setDelay(delay);
        }
    }
}

