/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;

@XmlRootElement(name="get-user-task-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetUserTaskCommand
extends TaskCommand<Task> {
    private static final long serialVersionUID = -3066272693452263188L;

    public GetUserTaskCommand() {
    }

    public GetUserTaskCommand(String userId, long taskId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    public Task execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (task == null) {
            throw new IllegalStateException("Unable to find task with id " + this.taskId);
        }
        if (!this.checkUserPermissions(this.userId, task, context)) {
            throw new PermissionDeniedException("User " + this.userId + " isn't allowed to see the task " + this.taskId);
        }
        return task;
    }

    protected boolean checkUserPermissions(String userId, Task task, TaskContext context) {
        List usersGroup = context.getUserGroupCallback().getGroupsForUser(userId, null, null);
        usersGroup.add(userId);
        if (this.checkUserPermissions(usersGroup, task.getPeopleAssignments().getPotentialOwners())) {
            return true;
        }
        return this.checkUserPermissions(usersGroup, task.getPeopleAssignments().getBusinessAdministrators());
    }

    protected boolean checkUserPermissions(List<String> userGroups, List<OrganizationalEntity> organizationalEntities) {
        for (OrganizationalEntity oe : organizationalEntities) {
            if (!userGroups.contains(oe.getId())) continue;
            return true;
        }
        return false;
    }
}

