/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.impl.model.xml.JaxbFaultData;
import org.jbpm.services.task.impl.model.xml.JaxbI18NText;
import org.kie.api.task.model.I18NText;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.model.FaultData;
import org.kie.internal.task.api.model.SubTasksStrategy;

@XmlRootElement(name="set-task-property-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SetTaskPropertyCommand
extends UserGroupCallbackTaskCommand<Void> {
    public static final int FAULT_PROPERTY = 1;
    public static final int OUTPUT_PROPERTY = 2;
    public static final int PRIORITY_PROPERTY = 3;
    public static final int TASK_NAMES_PROPERTY = 4;
    public static final int EXPIRATION_DATE_PROPERTY = 5;
    public static final int DESCRIPTION_PROPERTY = 6;
    public static final int SKIPPABLE_PROPERTY = 7;
    public static final int SUB_TASK_STRATEGY_PROPERTY = 8;
    private static final long serialVersionUID = -836520791223188840L;
    @XmlElement(required=true)
    @XmlSchemaType(name="integer")
    private Integer property;
    @XmlElement
    private JaxbFaultData faultData;
    @XmlElement
    private Object output;
    @XmlElement
    @XmlSchemaType(name="int")
    private Integer priority;
    @XmlElement(name="names-or-descriptions")
    private List<JaxbI18NText> namesOrDescriptions;
    @XmlElement(name="expiration-date")
    @XmlSchemaType(name="dateTime")
    private Date expirationDate;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean skippable;
    @XmlElement(name="sub-tasks-strategy")
    private SubTasksStrategy subTasksStrategy;

    public SetTaskPropertyCommand() {
    }

    public SetTaskPropertyCommand(long taskId, String userId, Integer property, Object value) {
        this.taskId = taskId;
        this.userId = userId;
        this.property = property;
        JaxbFaultData newValue = null;
        List<JaxbI18NText> newListValue = null;
        switch (property) {
            case 1: {
                if (value != null) {
                    this.checkValueType(value, FaultData.class, property, true, false);
                    newValue = new JaxbFaultData((FaultData)value);
                }
                this.faultData = newValue;
                break;
            }
            case 2: {
                this.output = value;
                break;
            }
            case 3: {
                this.checkValueType(value, Integer.class, property, false, false);
                this.priority = (Integer)value;
                break;
            }
            case 4: {
                if (value != null) {
                    this.checkValueType(value, I18NText.class, property, true, true);
                    newListValue = JaxbI18NText.convertListFromInterfaceToJaxbImpl((List)value, I18NText.class, JaxbI18NText.class);
                }
                this.namesOrDescriptions = newListValue;
                break;
            }
            case 5: {
                this.checkValueType(value, Date.class, property, false, false);
                this.expirationDate = (Date)value;
                break;
            }
            case 6: {
                if (value != null) {
                    this.checkValueType(value, I18NText.class, property, true, true);
                    newListValue = JaxbI18NText.convertListFromInterfaceToJaxbImpl((List)value, I18NText.class, JaxbI18NText.class);
                }
                this.namesOrDescriptions = newListValue;
                break;
            }
            case 7: {
                this.checkValueType(value, Boolean.class, property, false, false);
                this.skippable = (Boolean)value;
                break;
            }
            case 8: {
                this.checkValueType(value, SubTasksStrategy.class, property, false, false);
                this.subTasksStrategy = (SubTasksStrategy)value;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property in " + this.getClass().getSimpleName() + " constructor: " + property);
            }
        }
    }

    private void checkValueType(Object value, Class expectedClass, int property, boolean assignable, boolean list) {
        if (value == null) {
            return;
        }
        String propType = null;
        switch (property) {
            case 1: {
                propType = "FAULT_PROPERTY (" + property + ")";
                break;
            }
            case 2: {
                propType = "OUTPUT_PROPERTY (" + property + ")";
                break;
            }
            case 3: {
                propType = "PRIORITY_PROPERTY (" + property + ")";
                break;
            }
            case 4: {
                propType = "TASK_NAMES_PROPERTY (" + property + ")";
                break;
            }
            case 5: {
                propType = "EXPIRATION_DATE_PROPERTY (" + property + ")";
                break;
            }
            case 6: {
                propType = "DESCRIPTION_PROPERTY (" + property + ")";
                break;
            }
            case 7: {
                propType = "SKIPPABLE_PROPERTY (" + property + ")";
                break;
            }
            case 8: {
                propType = "SUB_TASK_STRATEGY_PROPERTY (" + property + ")";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property in " + this.getClass().getSimpleName() + " constructor check: " + property);
            }
        }
        Class<?> valueClass = value.getClass();
        if (list) {
            if (!List.class.isAssignableFrom(valueClass)) {
                throw new IllegalStateException("Expected a " + expectedClass.getSimpleName() + " for property " + propType + ", not a " + valueClass.getName());
            }
            List listVal = (List)value;
            if (listVal.isEmpty()) {
                return;
            }
            value = listVal.get(0);
            valueClass = value.getClass();
        }
        if (assignable ? !expectedClass.isAssignableFrom(valueClass) : !expectedClass.isInstance(value)) {
            throw new IllegalStateException("Expected a " + expectedClass.getSimpleName() + " for property " + propType + ", not a " + valueClass.getName());
        }
    }

    public Integer getProperty() {
        return this.property;
    }

    public void setProperty(Integer name) {
        this.property = name;
    }

    public JaxbFaultData getFaultData() {
        return this.faultData;
    }

    public void setFaultData(JaxbFaultData faultData) {
        this.faultData = faultData;
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public List<JaxbI18NText> getNamesOrDescriptions() {
        return this.namesOrDescriptions;
    }

    public void setNamesOrDescriptions(List<JaxbI18NText> namesOrDescriptions) {
        this.namesOrDescriptions = namesOrDescriptions;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean getSkippable() {
        return this.skippable;
    }

    public void setSkippable(Boolean skippable) {
        this.skippable = skippable;
    }

    public SubTasksStrategy getSubTasksStrategy() {
        return this.subTasksStrategy;
    }

    public void setSubTasksStrategy(SubTasksStrategy subTasksStrategy) {
        this.subTasksStrategy = subTasksStrategy;
    }

    @Override
    public Void execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        TaskInstanceService service = context.getTaskInstanceService();
        switch (this.property) {
            case 1: {
                this.doCallbackUserOperation(this.userId, context, true);
                service.setFault(this.taskId.longValue(), this.userId, (FaultData)this.faultData);
                break;
            }
            case 2: {
                this.doCallbackUserOperation(this.userId, context, true);
                service.setOutput(this.taskId.longValue(), this.userId, this.output);
                break;
            }
            case 3: {
                service.setPriority(this.taskId.longValue(), this.priority.intValue());
                break;
            }
            case 4: {
                List<I18NText> names = null;
                if (this.namesOrDescriptions != null) {
                    names = JaxbI18NText.convertListFromJaxbImplToInterface(this.namesOrDescriptions);
                }
                service.setTaskNames(this.taskId.longValue(), names);
                break;
            }
            case 5: {
                service.setExpirationDate(this.taskId.longValue(), this.expirationDate);
                break;
            }
            case 6: {
                List<I18NText> descriptions = null;
                if (this.namesOrDescriptions != null) {
                    descriptions = JaxbI18NText.convertListFromJaxbImplToInterface(this.namesOrDescriptions);
                }
                service.setDescriptions(this.taskId.longValue(), descriptions);
                break;
            }
            case 7: {
                service.setSkipable(this.taskId.longValue(), this.skippable.booleanValue());
                break;
            }
            case 8: {
                service.setSubTaskStrategy(this.taskId.longValue(), this.subTasksStrategy);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property in " + this.getClass().getSimpleName() + " execute: " + this.property);
            }
        }
        return null;
    }
}

