/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.drools.core.factmodel.ClassBuilder;
import org.drools.core.factmodel.ClassBuilderFactory;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.Fact;
import org.drools.core.factmodel.Field;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.util.IoUtils;

public class Jenerator {
    private final ClassLoader classLoader;

    public Jenerator() {
        this(Jenerator.class.getClassLoader());
    }

    public Jenerator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public byte[] createJar(Fact[] facts, String packageName) throws SecurityException, IllegalArgumentException, IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        JarOutputStream jout = new JarOutputStream(result);
        JarEntry metaModel = new JarEntry("factmodel.xml");
        jout.putNextEntry(metaModel);
        jout.write(this.toXML(facts));
        jout.closeEntry();
        String packagePath = packageName.replace('.', '/');
        for (int i = 0; i < facts.length; ++i) {
            ClassBuilder cb = new ClassBuilderFactory().getBeanClassBuilder();
            ClassDefinition classDef = new ClassDefinition(packageName, null, new String[]{"java.io.Serializable"});
            for (int j = 0; j < facts[i].fields.size(); ++j) {
                Field fd = (Field)facts[i].fields.get(j);
                classDef.addField(new FieldDefinition(fd.name, fd.type));
            }
            JarEntry je = new JarEntry(packagePath + "/" + facts[i].name + ".class");
            jout.putNextEntry(je);
            jout.write(cb.buildClass(classDef, this.classLoader));
            jout.closeEntry();
        }
        jout.flush();
        jout.close();
        return result.toByteArray();
    }

    private byte[] toXML(Fact[] facts) {
        XStream x = new XStream((HierarchicalStreamDriver)new DomDriver());
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        x.denyTypes(voidDeny);
        return x.toXML((Object)facts).getBytes(IoUtils.UTF8_CHARSET);
    }

    public Fact[] loadMetaModel(JarInputStream jis) throws Exception {
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.getName().equals("factmodel.xml")) continue;
            return this.fromXML(jis);
        }
        throw new IllegalArgumentException("This is not a valid drools model jar - no factmodel.xml found.");
    }

    private Fact[] fromXML(JarInputStream jis) {
        XStream x = new XStream((HierarchicalStreamDriver)new DomDriver());
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        x.denyTypes(voidDeny);
        return (Fact[])x.fromXML((InputStream)jis);
    }
}

