/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.function;

import java.util.List;
import org.dashbuilder.dataset.engine.function.AbstractFunction;
import org.dashbuilder.dataset.group.AggregateFunctionType;

public class SumFunction
extends AbstractFunction {
    public AggregateFunctionType getType() {
        return AggregateFunctionType.SUM;
    }

    public double aggregate(List values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (Number n : values) {
            if (n == null) continue;
            sum += n.doubleValue();
        }
        return this.round(sum, this.precission);
    }

    public double aggregate(List values, List<Integer> rows) {
        if (rows == null) {
            return this.aggregate(values);
        }
        if (rows.isEmpty()) {
            return 0.0;
        }
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (Integer row : rows) {
            Number n = (Number)values.get(row);
            if (n == null) continue;
            sum += n.doubleValue();
        }
        return this.round(sum, this.precission);
    }
}

