/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.kie.services.impl.admin.TaskReassignmentImpl;
import org.jbpm.services.api.admin.TaskReassignment;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTaskReassignmentsCommand
extends UserGroupCallbackTaskCommand<List<TaskReassignment>> {
    private static final long serialVersionUID = -1856489382099976731L;
    private static final Logger logger = LoggerFactory.getLogger(ListTaskReassignmentsCommand.class);
    private boolean activeOnly;

    public ListTaskReassignmentsCommand(String userId, long taskId, boolean activeOnly) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.activeOnly = activeOnly;
    }

    public List<TaskReassignment> execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        Deadlines deadlines = ((InternalTask)task).getDeadlines();
        List reassignmantsNotStarted = deadlines.getStartDeadlines().stream().filter(d -> !d.getEscalations().isEmpty() && !((Escalation)d.getEscalations().get(0)).getReassignments().isEmpty()).map(d -> {
            Reassignment r = (Reassignment)((Escalation)d.getEscalations().get(0)).getReassignments().get(0);
            return new TaskReassignmentImpl(d.getId(), this.get(r.getDocumentation()), d.getDate(), r.getPotentialOwners(), d.isEscalated() == false);
        }).collect(Collectors.toList());
        List reassignmantsNotCompleted = deadlines.getEndDeadlines().stream().filter(d -> !d.getEscalations().isEmpty() && !((Escalation)d.getEscalations().get(0)).getReassignments().isEmpty()).map(d -> {
            Reassignment r = (Reassignment)((Escalation)d.getEscalations().get(0)).getReassignments().get(0);
            return new TaskReassignmentImpl(d.getId(), this.get(r.getDocumentation()), d.getDate(), r.getPotentialOwners(), d.isEscalated() == false);
        }).collect(Collectors.toList());
        List<Object> result = new ArrayList<TaskReassignment>();
        result.addAll(reassignmantsNotStarted);
        result.addAll(reassignmantsNotCompleted);
        if (this.activeOnly) {
            logger.debug("Removing already completed deadlines from the result");
            result = result.stream().filter(t -> t.isActive()).collect(Collectors.toList());
        }
        return result;
    }

    protected String get(List<I18NText> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return list.get(0).getText();
    }
}

