/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalContent;
import org.kie.internal.task.api.model.InternalTaskData;

public class RemoveTaskDataCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private boolean input;
    private List<String> variableNames;

    public RemoveTaskDataCommand(String userId, long taskId, List<String> variableNames, boolean input) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.variableNames = variableNames;
        this.input = input;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        TaskEventSupport taskEventSupport = context.getTaskEventSupport();
        TaskPersistenceContext persistenceContext = context.getPersistenceContext();
        Task task = persistenceContext.findTask(this.taskId);
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        long contentId = task.getTaskData().getDocumentContentId();
        if (!this.input) {
            contentId = task.getTaskData().getOutputContentId();
        }
        Content outputContent = persistenceContext.findContent(Long.valueOf(contentId));
        HashMap mergedContent = new HashMap();
        if (outputContent != null) {
            ContentMarshallerContext mcontext = context.getTaskContentService().getMarshallerContext(task);
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall((byte[])outputContent.getContent(), (Environment)mcontext.getEnvironment(), (ClassLoader)mcontext.getClassloader());
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                mergedContent.putAll((Map)unmarshalledObject);
                this.variableNames.forEach(name -> mergedContent.remove(name));
            }
            ContentData outputContentData = ContentMarshallerHelper.marshal((Task)task, mergedContent, (Environment)mcontext.getEnvironment());
            ((InternalContent)outputContent).setContent(outputContentData.getContent());
            persistenceContext.persistContent(outputContent);
        }
        if (this.input) {
            ((InternalTaskData)task.getTaskData()).setTaskInputVariables(mergedContent);
            taskEventSupport.fireAfterTaskInputVariablesChanged(task, (TaskContext)context, mergedContent);
        } else {
            ((InternalTaskData)task.getTaskData()).setTaskOutputVariables(mergedContent);
            taskEventSupport.fireAfterTaskOutputVariablesChanged(task, (TaskContext)context, mergedContent);
        }
        return null;
    }
}

