/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Date;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.InternalTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTaskDeadlineCommand
extends UserGroupCallbackTaskCommand<Long> {
    private static final long serialVersionUID = -1856489382099976731L;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleTaskDeadlineCommand.class);
    private TaskDeadlinesService.DeadlineType type;
    private Deadline deadline;
    private String timeExpression;

    public ScheduleTaskDeadlineCommand(String userId, long taskId, TaskDeadlinesService.DeadlineType type, Deadline deadline, String timeExpression) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.type = type;
        this.deadline = deadline;
        this.timeExpression = timeExpression;
    }

    public Long execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        TaskPersistenceContext persistenceContext = context.getPersistenceContext();
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        logger.debug("About to schedule {} on a task {}", (Object)this.deadline, (Object)task);
        Deadlines deadlines = ((InternalTask)task).getDeadlines();
        if (this.type.equals((Object)TaskDeadlinesService.DeadlineType.START)) {
            deadlines.getStartDeadlines().add(this.deadline);
        } else {
            deadlines.getEndDeadlines().add(this.deadline);
        }
        this.doCallbackOperationForTaskDeadlines(deadlines, (TaskContext)context);
        persistenceContext.persistDeadline(this.deadline);
        persistenceContext.updateTask(task);
        logger.debug("Task updated and deadline stored with id {}", (Object)this.deadline.getId());
        TaskDeadlinesService deadlinesService = context.getTaskDeadlinesService();
        long fireAfterDuration = DateTimeUtils.parseDuration((String)this.timeExpression);
        this.deadline.setDate(new Date(System.currentTimeMillis() + fireAfterDuration));
        logger.debug("Deadline expiration time set to {} and duration {}", (Object)this.deadline.getDate(), (Object)fireAfterDuration);
        deadlinesService.schedule(this.taskId.longValue(), this.deadline.getId(), fireAfterDuration, this.type);
        logger.debug("Deadline on task {} successfully scheduled to fire at {}", (Object)task, (Object)this.deadline.getDate());
        return this.deadline.getId();
    }
}

