/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl.manager;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.util.CDIHelper;
import org.drools.core.util.StringUtils;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.api.qualifiers.Agenda;
import org.jbpm.runtime.manager.api.qualifiers.Process;
import org.jbpm.runtime.manager.api.qualifiers.Task;
import org.jbpm.runtime.manager.api.qualifiers.WorkingMemory;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.manager.EventListenerProducer;
import org.kie.internal.runtime.manager.GlobalProducer;
import org.kie.internal.runtime.manager.WorkItemHandlerProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectableRegisterableItemsFactory
extends DefaultRegisterableItemsFactory {
    private static final String DEFAULT_KIE_SESSION = "defaultKieSession";
    private static final Logger logger = LoggerFactory.getLogger(InjectableRegisterableItemsFactory.class);
    @Inject
    @Any
    private Instance<GlobalProducer> globalProducer;
    @Inject
    @Any
    private Instance<WorkItemHandlerProducer> workItemHandlerProducer;
    @Inject
    @Process
    private Instance<EventListenerProducer<ProcessEventListener>> processListenerProducer;
    @Inject
    @Agenda
    private Instance<EventListenerProducer<AgendaEventListener>> agendaListenerProducer;
    @Inject
    @WorkingMemory
    private Instance<EventListenerProducer<RuleRuntimeEventListener>> wmListenerProducer;
    @Inject
    @Task
    private Instance<EventListenerProducer<TaskLifeCycleEventListener>> taskListenerProducer;
    @Inject
    private Instance<ExecutorService> executorService;
    private AbstractAuditLogger auditlogger;
    private KieContainer kieContainer;
    private String ksessionName;

    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> handler = new HashMap<String, WorkItemHandler>();
        handler.put("Human Task", this.getHTWorkItemHandler(runtime));
        RuntimeManager manager = ((RuntimeEngineImpl)runtime).getManager();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ksession", runtime.getKieSession());
        parameters.put("taskService", runtime.getTaskService());
        parameters.put("runtimeManager", manager);
        parameters.put("kieContainer", this.getRuntimeManager().getKieContainer());
        try {
            parameters.put("executorService", this.executorService.get());
        }
        catch (Exception e) {
            logger.debug("Executor service not available due to {}", (Object)e.getMessage());
        }
        if (this.kieContainer != null) {
            parameters.put("classLoader", this.kieContainer.getClassLoader());
            Iterator ksessionModel = null;
            if (StringUtils.isEmpty((CharSequence)this.ksessionName)) {
                ksessionModel = ((KieContainerImpl)this.kieContainer).getKieProject().getDefaultKieSession();
                if (ksessionModel == null) {
                    ksessionModel = ((KieContainerImpl)this.kieContainer).getKieSessionModel(DEFAULT_KIE_SESSION);
                }
            } else {
                ksessionModel = ((KieContainerImpl)this.kieContainer).getKieSessionModel(this.ksessionName);
            }
            if (ksessionModel == null) {
                throw new IllegalStateException("Cannot find ksession, either it does not exist or there are multiple default ksession in kmodule.xml");
            }
            try {
                CDIHelper.wireListnersAndWIHs((KieSessionModel)ksessionModel, (KieSession)runtime.getKieSession(), parameters);
            }
            catch (Throwable e) {
                CDIHelper.wireListnersAndWIHs((KieSessionModel)ksessionModel, (KieSession)runtime.getKieSession());
            }
        }
        try {
            for (WorkItemHandlerProducer producer : this.workItemHandlerProducer) {
                handler.putAll(producer.getWorkItemHandlers(manager.getIdentifier(), parameters));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while evalutating work item handler prodcuers {}", (Object)e.getMessage());
        }
        handler.putAll(this.getWorkItemHandlersFromDescriptor(runtime));
        return handler;
    }

    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        Object aLogger;
        ArrayList<ProcessEventListener> defaultListeners = new ArrayList<ProcessEventListener>();
        if (this.auditlogger != null) {
            defaultListeners.add((ProcessEventListener)this.auditlogger);
        } else if (this.getAuditBuilder() != null && (aLogger = this.getAuditLoggerInstance(runtime)) != null) {
            defaultListeners.add((ProcessEventListener)aLogger);
        }
        try {
            for (EventListenerProducer producer : this.processListenerProducer) {
                defaultListeners.addAll(producer.getEventListeners(((RuntimeEngineImpl)runtime).getManager().getIdentifier(), this.getParametersMap(runtime)));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while evaluating ProcessEventListener producers {}", (Object)e.getMessage());
        }
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, ProcessEventListener.class));
        return defaultListeners;
    }

    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        ArrayList<RuleRuntimeEventListener> defaultListeners = new ArrayList<RuleRuntimeEventListener>();
        try {
            for (EventListenerProducer producer : this.wmListenerProducer) {
                defaultListeners.addAll(producer.getEventListeners(((RuntimeEngineImpl)runtime).getManager().getIdentifier(), this.getParametersMap(runtime)));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while evaluating WorkingMemoryEventListener producers {}", (Object)e.getMessage());
        }
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, RuleRuntimeEventListener.class));
        return defaultListeners;
    }

    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> defaultListeners = new ArrayList<AgendaEventListener>();
        try {
            for (EventListenerProducer producer : this.agendaListenerProducer) {
                defaultListeners.addAll(producer.getEventListeners(((RuntimeEngineImpl)runtime).getManager().getIdentifier(), this.getParametersMap(runtime)));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while evaluating WorkingMemoryEventListener producers {}", (Object)e.getMessage());
        }
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, AgendaEventListener.class));
        return defaultListeners;
    }

    public List<TaskLifeCycleEventListener> getTaskListeners() {
        ArrayList<TaskLifeCycleEventListener> defaultListeners = new ArrayList<TaskLifeCycleEventListener>();
        try {
            for (EventListenerProducer producer : this.taskListenerProducer) {
                defaultListeners.addAll(producer.getEventListeners(null, null));
            }
        }
        catch (Exception e) {
            logger.warn("Cannot add listeners to task service due to {}", (Object)e.getMessage());
        }
        defaultListeners.addAll(this.getTaskListenersFromDescriptor());
        return defaultListeners;
    }

    public Map<String, Object> getGlobals(RuntimeEngine runtime) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        RuntimeManager manager = ((RuntimeEngineImpl)runtime).getManager();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ksession", runtime.getKieSession());
        parameters.put("taskService", runtime.getTaskService());
        parameters.put("runtimeManager", manager);
        parameters.put("kieContainer", this.getRuntimeManager().getKieContainer());
        try {
            parameters.put("executorService", this.executorService.get());
        }
        catch (Exception e) {
            logger.debug("Executor service not available due to {}", (Object)e.getMessage());
        }
        try {
            for (GlobalProducer producer : this.globalProducer) {
                globals.putAll(producer.getGlobals(manager.getIdentifier(), parameters));
            }
        }
        catch (Exception e) {
            logger.warn("Exception while evalutating globals prodcuers {}", (Object)e.getMessage());
        }
        globals.putAll(this.getGlobalsFromDescriptor(runtime));
        return globals;
    }

    public static RegisterableItemsFactory getFactory(BeanManager beanManager, AbstractAuditLogger auditlogger) {
        InjectableRegisterableItemsFactory instance = InjectableRegisterableItemsFactory.getInstanceByType(beanManager, InjectableRegisterableItemsFactory.class, new Annotation[0]);
        instance.setAuditlogger(auditlogger);
        return instance;
    }

    public static RegisterableItemsFactory getFactory(BeanManager beanManager, AbstractAuditLogger auditlogger, KieContainer kieContainer, String ksessionName) {
        InjectableRegisterableItemsFactory instance = InjectableRegisterableItemsFactory.getInstanceByType(beanManager, InjectableRegisterableItemsFactory.class, new Annotation[0]);
        instance.setAuditlogger(auditlogger);
        instance.setKieContainer(kieContainer);
        instance.setKsessionName(ksessionName);
        return instance;
    }

    public static RegisterableItemsFactory getFactory(BeanManager beanManager, AuditEventBuilder eventBuilder) {
        InjectableRegisterableItemsFactory instance = InjectableRegisterableItemsFactory.getInstanceByType(beanManager, InjectableRegisterableItemsFactory.class, new Annotation[0]);
        instance.setAuditBuilder(eventBuilder);
        return instance;
    }

    public static RegisterableItemsFactory getFactory(BeanManager beanManager, AuditEventBuilder eventBuilder, KieContainer kieContainer, String ksessionName) {
        InjectableRegisterableItemsFactory instance = InjectableRegisterableItemsFactory.getInstanceByType(beanManager, InjectableRegisterableItemsFactory.class, new Annotation[0]);
        instance.setAuditBuilder(eventBuilder);
        instance.setKieContainer(kieContainer);
        instance.setKsessionName(ksessionName);
        return instance;
    }

    protected static <T> T getInstanceByType(BeanManager manager, Class<T> type, Annotation ... bindings) {
        Bean bean = manager.resolve(manager.getBeans(type, bindings));
        if (bean == null) {
            throw new UnsatisfiedResolutionException("Unable to resolve a bean for " + type + " with bindings " + Arrays.asList(bindings));
        }
        CreationalContext cc = manager.createCreationalContext(null);
        return type.cast(manager.getReference(bean, type, cc));
    }

    public AbstractAuditLogger getAuditlogger() {
        return this.auditlogger;
    }

    public void setAuditlogger(AbstractAuditLogger auditlogger) {
        this.auditlogger = auditlogger;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    public void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    protected AbstractAuditLogger getAuditLoggerInstance(RuntimeEngine engine) {
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        Object auditLogger = null;
        if ("true".equals(System.getProperty("jbpm.audit.jms.enabled")) || descriptor.getAuditMode() == AuditMode.JMS) {
            try {
                Properties properties = new Properties();
                properties.load(this.getRuntimeManager().getEnvironment().getClassLoader().getResourceAsStream("/jbpm.audit.jms.properties"));
                auditLogger = AuditLoggerFactory.newJMSInstance((Map)properties);
            }
            catch (IOException e) {
                logger.error("Unable to load jms audit properties from {}", (Object)"/jbpm.audit.jms.properties", (Object)e);
            }
            auditLogger.setBuilder(this.getAuditBuilder(engine));
        } else if (descriptor.getAuditMode() == AuditMode.JPA) {
            auditLogger = descriptor.getPersistenceUnit().equals(descriptor.getAuditPersistenceUnit()) ? AuditLoggerFactory.newJPAInstance((Environment)engine.getKieSession().getEnvironment()) : new JPAWorkingMemoryDbLogger(EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit()));
            auditLogger.setBuilder(this.getAuditBuilder(engine));
        }
        return auditLogger;
    }
}

