/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Arrays;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class RemovePeopleAssignmentsCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private int type;
    private OrganizationalEntity[] entities;

    public RemovePeopleAssignmentsCommand(String userId, long taskId, int type, OrganizationalEntity[] entities) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.type = type;
        this.entities = entities;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        switch (this.type) {
            case 0: {
                task.getPeopleAssignments().getPotentialOwners().removeAll(Arrays.asList(this.entities));
                break;
            }
            case 1: {
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().removeAll(Arrays.asList(this.entities));
                break;
            }
            case 2: {
                task.getPeopleAssignments().getBusinessAdministrators().removeAll(Arrays.asList(this.entities));
                break;
            }
        }
        return null;
    }
}

