/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.command.Context;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriggerNodeInstanceCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -8252686458877022331L;
    private static final Logger logger = LoggerFactory.getLogger(RetriggerNodeInstanceCommand.class);
    private long processInstanceId;
    private long nodeInstanceId;

    public RetriggerNodeInstanceCommand(long processInstanceId, long nodeInstanceId) {
        this.processInstanceId = processInstanceId;
        this.nodeInstanceId = nodeInstanceId;
    }

    public Void execute(Context context) {
        KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        logger.debug("About to retrigger node instance with id {} on process instance {}", (Object)this.nodeInstanceId, (Object)this.processInstanceId);
        RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)kieSession.getProcessInstance(this.processInstanceId, false);
        if (wfp == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + this.processInstanceId + " not found");
        }
        NodeInstance nodeInstance = wfp.getNodeInstances(true).stream().filter(ni -> ni.getId() == this.nodeInstanceId).findFirst().orElse(null);
        if (nodeInstance == null) {
            throw new NodeInstanceNotFoundException("Node instance with id " + this.nodeInstanceId + " not found");
        }
        logger.debug("Found node instance {} to be retriggered", (Object)nodeInstance);
        ((NodeInstanceImpl)nodeInstance).retrigger(true);
        logger.debug("Node instance {} retriggered successfully", (Object)nodeInstance);
        return null;
    }

    public void setProcessInstanceId(Long procInstId) {
        this.processInstanceId = procInstId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }
}

