/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.List;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.engine.DataSetHandler;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public class IntervalBuilderDynamicLabel
implements IntervalBuilder {
    @Override
    public IntervalList build(DataSetHandler ctx, ColumnGroup columnGroup) {
        IntervalListLabel intervalList = new IntervalListLabel(columnGroup);
        String columnId = columnGroup.getSourceId();
        List values = ctx.getDataSet().getColumnById(columnId).getValues();
        List<Integer> rows = ctx.getRows();
        return intervalList.indexValues(values, rows);
    }

    @Override
    public IntervalList build(DataColumn dataColumn) {
        ColumnGroup columnGroup = dataColumn.getColumnGroup();
        IntervalListLabel intervalList = new IntervalListLabel(columnGroup);
        List values = dataColumn.getValues();
        return intervalList.indexValues(values, null);
    }

    @Override
    public Interval locate(DataColumn column, Integer intervalIndex) {
        ColumnGroup columnGroup = column.getColumnGroup();
        if (columnGroup == null) {
            return null;
        }
        if (intervalIndex == null) {
            return null;
        }
        IntervalListLabel intervalList = new IntervalListLabel(columnGroup);
        intervalList.indexValues(column.getValues(), null);
        if (intervalIndex >= intervalList.size()) {
            return null;
        }
        return (Interval)intervalList.get(intervalIndex);
    }

    private class IntervalListLabel
    extends IntervalList {
        private IntervalListLabel(ColumnGroup columnGroup) {
            super(columnGroup);
        }

        @Override
        public void indexValue(Object value, int row) {
            Interval interval = this.locateInterval(value);
            if (interval == null) {
                String name = value == null ? null : value.toString();
                int index = this.size();
                interval = new Interval(name, index);
                this.add(interval);
            }
            interval.getRows().add(row);
        }

        @Override
        public Interval locateInterval(Object value) {
            for (Interval interval : this) {
                String name;
                if (interval.getName() == value) {
                    return interval;
                }
                if (interval.getName() == null) continue;
                String string = name = value == null ? null : value.toString();
                if (!interval.getName().equals(name)) continue;
                return interval;
            }
            return null;
        }
    }
}

