/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryParameterIdentifiers;

@XmlRootElement(name="get-tasks-by-various-fields-command")
@XmlAccessorType(value=XmlAccessType.NONE)
@Deprecated
public class GetTasksByVariousFieldsCommand
extends UserGroupCallbackTaskCommand<List<TaskSummary>> {
    private static final long serialVersionUID = -4894264083829084547L;
    @XmlElement
    private List<Long> workItemIds;
    @XmlElement
    private List<Long> taskIds;
    @XmlElement
    private List<Long> processInstanceIds;
    @XmlElement
    private List<String> businessAdmins;
    @XmlElement
    private List<String> potentialOwners;
    @XmlElement
    private List<String> taskOwners;
    @XmlElement
    private List<Status> statuses;
    @XmlElement
    @XmlSchemaType(name="boolean")
    private Boolean union;
    @XmlElement
    private List<String> languages;
    @XmlElement
    private Integer maxResults;

    public GetTasksByVariousFieldsCommand() {
    }

    public GetTasksByVariousFieldsCommand(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, boolean union) {
        this(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, null, union);
    }

    public GetTasksByVariousFieldsCommand(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, List<String> language, boolean union) {
        this(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, language, union, null);
    }

    public GetTasksByVariousFieldsCommand(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, List<String> language, boolean union, Integer maxResults) {
        this.workItemIds = workItemIds;
        this.taskIds = taskIds;
        this.processInstanceIds = procInstIds;
        this.businessAdmins = busAdmins;
        this.potentialOwners = potOwners;
        this.taskOwners = taskOwners;
        this.statuses = statuses;
        this.languages = language;
        this.union = union;
        this.maxResults = maxResults;
    }

    public GetTasksByVariousFieldsCommand(Map<String, List<?>> params, boolean union) {
        this(params, union, null);
    }

    public GetTasksByVariousFieldsCommand(Map<String, List<?>> params, boolean union, Integer maxResults) {
        this.union = union;
        this.maxResults = maxResults;
        if (params == null) {
            params = new HashMap();
        } else {
            this.workItemIds = params.get(QueryParameterIdentifiers.WORK_ITEM_ID_LIST);
            this.taskIds = params.get(QueryParameterIdentifiers.TASK_ID_LIST);
            this.processInstanceIds = params.get(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST);
            this.businessAdmins = params.get(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST);
            this.potentialOwners = params.get(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST);
            this.taskOwners = params.get(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST);
            this.statuses = params.get(QueryParameterIdentifiers.TASK_STATUS_LIST);
        }
    }

    public List<Long> getWorkItemIds() {
        return this.workItemIds;
    }

    public void setWorkItemIds(List<Long> workItemIds) {
        this.workItemIds = workItemIds;
    }

    public List<Long> getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public List<Long> getProcInstIds() {
        return this.processInstanceIds;
    }

    public void setProcInstIds(List<Long> procInstIds) {
        this.processInstanceIds = procInstIds;
    }

    public List<String> getBusAdmins() {
        return this.businessAdmins;
    }

    public void setBusAdmins(List<String> busAdmins) {
        this.businessAdmins = busAdmins;
    }

    public List<String> getPotOwners() {
        return this.potentialOwners;
    }

    public void setPotOwners(List<String> potOwners) {
        this.potentialOwners = potOwners;
    }

    public List<String> getTaskOwners() {
        return this.taskOwners;
    }

    public void setTaskOwners(List<String> taskOwners) {
        this.taskOwners = taskOwners;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public List<String> getLanguage() {
        return this.languages;
    }

    public void setLanguage(List<String> language) {
        this.languages = language;
    }

    public Boolean getUnion() {
        return this.union;
    }

    public void setUnion(Boolean union) {
        this.union = union;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public List<TaskSummary> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        this.potentialOwners = this.populateOrganizationalEntityWithGroupInfo(this.potentialOwners, context);
        this.businessAdmins = this.populateOrganizationalEntityWithGroupInfo(this.businessAdmins, context);
        List<String> stakeHolders = new ArrayList<String>();
        stakeHolders = this.populateOrganizationalEntityWithGroupInfo(stakeHolders, context);
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
        params.put(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, this.workItemIds);
        params.put(QueryParameterIdentifiers.TASK_ID_LIST, this.taskIds);
        params.put(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, this.processInstanceIds);
        params.put(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, this.businessAdmins);
        params.put(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, this.potentialOwners);
        params.put(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, stakeHolders);
        params.put(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, this.taskOwners);
        params.put(QueryParameterIdentifiers.TASK_STATUS_LIST, this.statuses);
        if (this.maxResults != null && this.maxResults > 0) {
            Integer[] maxResultsArr = new Integer[]{this.maxResults};
            params.put("maxResults", Arrays.asList(maxResultsArr));
        }
        if (this.userId == null || this.userId.isEmpty()) {
            throw new IllegalStateException("A user id is required for this operation: " + GetTasksByVariousFieldsCommand.class.getSimpleName());
        }
        return context.getTaskQueryService().getTasksByVariousFields(this.userId, params, this.union.booleanValue());
    }

    protected List<String> populateOrganizationalEntityWithGroupInfo(List<String> entities, TaskContext context) {
        if (entities != null && entities.size() > 0) {
            HashSet<String> groupIds = new HashSet<String>();
            for (String userId : entities) {
                List<String> tmp = this.doUserGroupCallbackOperation(userId, null, context);
                if (tmp == null) continue;
                groupIds.addAll(tmp);
            }
            groupIds.addAll(entities);
            return new ArrayList<String>(groupIds);
        }
        return entities;
    }
}

