/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryParameterIdentifiersUtil;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.service.QueryModificationService;
import org.jbpm.services.task.impl.model.I18NTextImpl_;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl;
import org.jbpm.services.task.impl.model.OrganizationalEntityImpl_;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl_;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl_;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.TaskImpl_;
import org.jbpm.services.task.impl.model.UserImpl_;
import org.jbpm.services.task.persistence.AbstractTaskQueryCriteriaUtil;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.SubTasksStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSummaryQueryCriteriaUtil
extends AbstractTaskQueryCriteriaUtil {
    public static final Logger logger = LoggerFactory.getLogger(TaskSummaryQueryCriteriaUtil.class);
    public static final Map<Class, Map<String, Attribute>> criteriaAttributes = new ConcurrentHashMap<Class, Map<String, Attribute>>();
    private ServiceLoader<QueryModificationService> queryModificationServiceLoader = ServiceLoader.load(QueryModificationService.class);
    private static final Set<String> taskUserRoleLimitingListIds = new HashSet<String>();

    @Override
    protected synchronized boolean initializeCriteriaAttributes() {
        if (TaskImpl_.id == null) {
            return false;
        }
        if (!criteriaAttributes.isEmpty()) {
            return true;
        }
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, TaskImpl.class, TaskDataImpl_.activationTime);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.ARCHIVED, TaskImpl_.archived);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.CREATED_ON_LIST, TaskImpl.class, TaskDataImpl_.createdOn);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, TaskImpl.class, TaskDataImpl_.deploymentId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.EXPIRATION_TIME_LIST, TaskImpl.class, TaskDataImpl_.expirationTime);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_FORM_NAME_LIST, TaskImpl_.formName);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_ID_LIST, TaskImpl.class, TaskDataImpl_.processId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, TaskImpl.class, TaskDataImpl_.processInstanceId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.PROCESS_SESSION_ID_LIST, TaskImpl.class, TaskDataImpl_.processSessionId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.SKIPPABLE, TaskImpl.class, TaskDataImpl_.skipable);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_STATUS_LIST, TaskImpl.class, TaskDataImpl_.status);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.SUB_TASKS_STRATEGY, TaskImpl_.subTaskStrategy);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_ID_LIST, TaskImpl_.id);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_PARENT_ID_LIST, TaskImpl.class, TaskDataImpl_.parentId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TYPE_LIST, TaskImpl_.taskType);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.WORK_ITEM_ID_LIST, TaskImpl.class, TaskDataImpl_.workItemId);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_PRIORITY_LIST, TaskImpl.class, TaskImpl_.priority);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_DESCRIPTION_LIST, TaskImpl_.descriptions);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_NAME_LIST, TaskImpl_.names);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.TASK_SUBJECT_LIST, TaskImpl_.subjects);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, TaskImpl.class, TaskDataImpl_.actualOwner);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.CREATED_BY_LIST, TaskImpl.class, TaskDataImpl_.createdBy);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, TaskImpl.class, PeopleAssignmentsImpl_.businessAdministrators);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, TaskImpl.class, PeopleAssignmentsImpl_.potentialOwners);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, TaskImpl.class, PeopleAssignmentsImpl_.taskStakeholders);
        TaskSummaryQueryCriteriaUtil.addCriteria(criteriaAttributes, (String)QueryParameterIdentifiers.EXCLUDED_OWNER_ID_LIST, TaskImpl.class, PeopleAssignmentsImpl_.excludedOwners);
        return true;
    }

    public TaskSummaryQueryCriteriaUtil(TaskPersistenceContext persistenceContext) {
        super(persistenceContext);
        this.initialize(criteriaAttributes);
    }

    public TaskSummaryQueryCriteriaUtil() {
        this.initialize(criteriaAttributes);
    }

    public List<TaskSummary> doCriteriaQuery(String userId, UserGroupCallback userGroupCallback, QueryWhere queryWhere) {
        CriteriaBuilder builder = this.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createTupleQuery();
        Root taskRoot = criteriaQuery.from(TaskImpl.class);
        criteriaQuery = criteriaQuery.multiselect(new Selection[]{taskRoot.get(TaskImpl_.id), taskRoot.get(TaskImpl_.name), taskRoot.get(TaskImpl_.subject), taskRoot.get(TaskImpl_.description), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.status), taskRoot.get(TaskImpl_.priority), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.skipable), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.actualOwner).get(UserImpl_.id), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.createdBy).get(UserImpl_.id), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.createdOn), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.activationTime), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.expirationTime), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processId), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processSessionId), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processInstanceId), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.deploymentId), taskRoot.get(TaskImpl_.subTaskStrategy), taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.parentId)});
        taskRoot.join(TaskImpl_.taskData);
        this.checkExistingCriteriaForUserBasedLimit(queryWhere, userId, userGroupCallback);
        for (QueryModificationService queryModificationService : this.queryModificationServiceLoader) {
            queryModificationService.optimizeCriteria(queryWhere);
        }
        this.fillCriteriaQuery(criteriaQuery, queryWhere, builder, TaskImpl.class);
        this.useDistinctWhenLefOuterJoinsPresent(criteriaQuery);
        List result = this.createQueryAndCallApplyMetaCriteriaAndGetResult(queryWhere, criteriaQuery, builder);
        ArrayList<TaskSummary> taskSummaryList = new ArrayList<TaskSummary>(result.size());
        for (Tuple tupleRow : result) {
            int i = 0;
            TaskSummaryImpl taskSummaryImpl = new TaskSummaryImpl((long)((Long)tupleRow.get(i++, Long.class)), (String)tupleRow.get(i++, String.class), (String)tupleRow.get(i++, String.class), (String)tupleRow.get(i++, String.class), (Status)tupleRow.get(i++, Status.class), (int)((Integer)tupleRow.get(i++, Integer.class)), (boolean)((Boolean)tupleRow.get(i++, Boolean.class)), (String)tupleRow.get(i++, String.class), (String)tupleRow.get(i++, String.class), (Date)tupleRow.get(i++, Date.class), (Date)tupleRow.get(i++, Date.class), (Date)tupleRow.get(i++, Date.class), (String)tupleRow.get(i++, String.class), (long)((Long)tupleRow.get(i++, Long.class)), (long)((Long)tupleRow.get(i++, Long.class)), (String)tupleRow.get(i++, String.class), (SubTasksStrategy)tupleRow.get(i++, SubTasksStrategy.class), (long)((Long)tupleRow.get(i++, Long.class)));
            taskSummaryList.add((TaskSummary)taskSummaryImpl);
        }
        return taskSummaryList;
    }

    private void checkExistingCriteriaForUserBasedLimit(QueryWhere queryWhere, String userId, UserGroupCallback userGroupCallback) {
        List groupIds = userGroupCallback.getGroupsForUser(userId);
        HashSet<String> userAndGroupIds = new HashSet<String>();
        if (groupIds != null) {
            userAndGroupIds.addAll(groupIds);
        }
        userAndGroupIds.add(userId);
        if (!TaskSummaryQueryCriteriaUtil.criteriaListForcesUserLimitation(userAndGroupIds, queryWhere.getCriteria())) {
            this.addUserRolesLimitCriteria(queryWhere, userId, groupIds);
        }
    }

    private static boolean criteriaListForcesUserLimitation(Set<String> userAndGroupIds, List<QueryCriteria> criteriaList) {
        boolean userLimitiationIntersection = false;
        if (criteriaList.isEmpty()) {
            return false;
        }
        for (QueryCriteria criteria : criteriaList) {
            if (criteria.isUnion()) {
                return false;
            }
            if (criteria.isGroupCriteria()) {
                if (!TaskSummaryQueryCriteriaUtil.criteriaListForcesUserLimitation(userAndGroupIds, criteria.getCriteria())) continue;
                return true;
            }
            if (!taskUserRoleLimitingListIds.contains(criteria.getListId())) continue;
            for (Object param : criteria.getParameters()) {
                if (!userAndGroupIds.contains(param)) continue;
                return true;
            }
        }
        return userLimitiationIntersection;
    }

    private void addUserRolesLimitCriteria(QueryWhere queryWhere, String userId, List<String> groupIds) {
        ArrayList<QueryCriteria> newBaseCriteriaList = new ArrayList<QueryCriteria>(2);
        QueryCriteria userRolesLimitingCriteria = new QueryCriteria(QueryParameterIdentifiers.TASK_USER_ROLES_LIMIT_LIST, false, QueryWhere.QueryCriteriaType.NORMAL, 2);
        userRolesLimitingCriteria.setFirst(true);
        userRolesLimitingCriteria.getValues().add(userId);
        userRolesLimitingCriteria.getValues().add(groupIds);
        newBaseCriteriaList.add(userRolesLimitingCriteria);
        if (!queryWhere.getCriteria().isEmpty()) {
            QueryCriteria originalBaseCriteriaGroup = new QueryCriteria(false);
            originalBaseCriteriaGroup.setCriteria(queryWhere.getCriteria());
            newBaseCriteriaList.add(originalBaseCriteriaGroup);
        }
        queryWhere.setCriteria(newBaseCriteriaList);
    }

    protected <T> Expression getEntityField(CriteriaQuery<T> query, String listId, Attribute attr) {
        if (attr == null) {
            return null;
        }
        Root taskRoot = null;
        Join taskDataJoin = null;
        Join peopAssignJoin = null;
        for (Root root : query.getRoots()) {
            if (!TaskImpl.class.equals((Object)root.getJavaType())) continue;
            taskRoot = root;
            for (Join join : taskRoot.getJoins()) {
                if (TaskDataImpl.class.equals((Object)join.getJavaType())) {
                    taskDataJoin = join;
                    continue;
                }
                if (!PeopleAssignmentsImpl.class.equals((Object)join.getJavaType())) continue;
                peopAssignJoin = join;
            }
        }
        assert (taskRoot != null) : "Unable to find TaskImpl Root in query!";
        if (taskDataJoin == null) {
            taskDataJoin = taskRoot.join(TaskImpl_.taskData);
        }
        assert (taskDataJoin != null) : "Unable to find TaskDataImpl Join in query!";
        return TaskSummaryQueryCriteriaUtil.taskImplSpecificGetEntityField(query, (Root<TaskImpl>)taskRoot, (Join<TaskImpl, TaskDataImpl>)taskDataJoin, peopAssignJoin, listId, attr);
    }

    public static <T> Expression taskImplSpecificGetEntityField(CriteriaQuery<T> query, Root<TaskImpl> taskRoot, Join<TaskImpl, TaskDataImpl> taskDataJoin, Join<TaskImpl, PeopleAssignmentsImpl> peopleAssignJoin, String listId, Attribute attr) {
        Expression entityField = null;
        if (attr != null) {
            if (listId.equals(QueryParameterIdentifiers.TASK_DESCRIPTION_LIST) || listId.equals(QueryParameterIdentifiers.TASK_NAME_LIST) || listId.equals(QueryParameterIdentifiers.TASK_SUBJECT_LIST)) {
                entityField = TaskSummaryQueryCriteriaUtil.getJoinedEntityField(taskRoot, attr, I18NTextImpl_.shortText);
            } else if (listId.equals(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST) || listId.equals(QueryParameterIdentifiers.CREATED_BY_LIST)) {
                if (taskDataJoin == null) {
                    taskDataJoin = taskRoot.join(TaskImpl_.taskData);
                }
                entityField = TaskSummaryQueryCriteriaUtil.getJoinedEntityField(taskDataJoin, attr, UserImpl_.id);
            } else if (listId.equals(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST) || listId.equals(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST) || listId.equals(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST) || listId.equals(QueryParameterIdentifiers.EXCLUDED_OWNER_ID_LIST)) {
                if (peopleAssignJoin == null) {
                    peopleAssignJoin = taskRoot.join(TaskImpl_.peopleAssignments);
                }
                entityField = TaskSummaryQueryCriteriaUtil.getJoinedEntityField(peopleAssignJoin, attr, OrganizationalEntityImpl_.id);
            } else {
                From[] taskRoots;
                if (taskDataJoin == null) {
                    taskDataJoin = taskRoot.join(TaskImpl_.taskData);
                }
                Class attrType = attr.getDeclaringType().getJavaType();
                for (From from : taskRoots = new From[]{taskRoot, taskDataJoin}) {
                    if (!from.getJavaType().equals(attrType) || attr == null) continue;
                    if (attr instanceof SingularAttribute) {
                        entityField = from.get((SingularAttribute)attr);
                        break;
                    }
                    if (attr instanceof PluralAttribute) {
                        entityField = from.get((PluralAttribute)attr);
                        break;
                    }
                    throw new IllegalStateException("Unexpected attribute type when processing criteria with list id " + listId + ": " + attr.getClass().getName());
                }
            }
        }
        return entityField;
    }

    public static <F, T> Expression getJoinedEntityField(From<?, F> grandparentJoin, Attribute<?, T> parentJoinAttr, SingularAttribute fieldAttr) {
        Class toAttrJoinType;
        if (parentJoinAttr instanceof SingularAttribute) {
            toAttrJoinType = parentJoinAttr.getJavaType();
        } else if (parentJoinAttr instanceof PluralAttribute) {
            toAttrJoinType = ((PluralAttribute)parentJoinAttr).getElementType().getJavaType();
        } else {
            String joinName = parentJoinAttr.getDeclaringType().getJavaType().getSimpleName() + "." + parentJoinAttr.getName();
            throw new IllegalStateException("Unknown attribute type encountered when trying to join " + joinName);
        }
        Join fieldParentJoin = null;
        for (Join join : grandparentJoin.getJoins()) {
            if (!join.getJavaType().equals(toAttrJoinType) || !join.getAttribute().equals(parentJoinAttr)) continue;
            fieldParentJoin = join;
            if (JoinType.INNER.equals((Object)fieldParentJoin.getJoinType())) break;
            fieldParentJoin = null;
            break;
        }
        if (fieldParentJoin == null) {
            if (parentJoinAttr instanceof SingularAttribute) {
                fieldParentJoin = grandparentJoin.join((SingularAttribute)parentJoinAttr);
            } else if (parentJoinAttr instanceof CollectionAttribute) {
                fieldParentJoin = grandparentJoin.join((CollectionAttribute)parentJoinAttr);
            } else if (parentJoinAttr instanceof ListAttribute) {
                fieldParentJoin = grandparentJoin.join((ListAttribute)parentJoinAttr);
            } else if (parentJoinAttr instanceof SetAttribute) {
                fieldParentJoin = grandparentJoin.join((SetAttribute)parentJoinAttr);
            } else {
                throw new IllegalStateException("Unknown attribute type encountered when trying to join" + parentJoinAttr.getName());
            }
        }
        return fieldParentJoin.get(fieldAttr);
    }

    @Override
    protected <R, T> Predicate implSpecificCreatePredicateFromSingleCriteria(CriteriaQuery<R> query, CriteriaBuilder builder, Class queryType, QueryCriteria criteria, QueryWhere queryWhere) {
        Predicate predicate = null;
        String listId = criteria.getListId();
        if (!QueryParameterIdentifiers.TASK_USER_ROLES_LIMIT_LIST.equals(listId)) {
            for (QueryModificationService queryModService : this.queryModificationServiceLoader) {
                if (!queryModService.accepts(listId)) continue;
                return queryModService.createPredicate(criteria, query, builder);
            }
            throw new IllegalStateException("List id " + (String)QueryParameterIdentifiersUtil.getQueryParameterIdNameMap().get(Integer.parseInt(criteria.getListId())) + " is not supported for queries on " + TaskImpl.class.getSimpleName() + ".");
        }
        predicate = TaskSummaryQueryCriteriaUtil.createTaskUserRolesLimitPredicate(criteria, query, builder);
        return predicate;
    }

    private static <T> Predicate createTaskUserRolesLimitPredicate(QueryCriteria criteria, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        String userId = (String)criteria.getValues().get(0);
        List groupIds = (List)criteria.getValues().get(1);
        Root taskRoot = TaskSummaryQueryCriteriaUtil.getRoot(criteriaQuery, TaskImpl.class);
        assert (taskRoot != null) : "TaskImpl Root instance could not be found in query!";
        boolean groupIdsPresent = groupIds.size() > 0;
        int numPredicates = groupIdsPresent ? 5 : 2;
        Predicate[] userGroupLimitingPredicates = new Predicate[numPredicates];
        userGroupLimitingPredicates[0] = builder.equal((Expression)taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.actualOwner).get(UserImpl_.id), (Object)userId);
        userGroupLimitingPredicates[1] = builder.equal((Expression)taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.createdBy).get(UserImpl_.id), (Object)userId);
        Join taskDataJoin = null;
        Join peopleAssignJoin = null;
        if (taskRoot != null) {
            for (Join join : taskRoot.getJoins()) {
                if (join.getJavaType().equals(PeopleAssignmentsImpl.class)) {
                    peopleAssignJoin = join;
                    continue;
                }
                if (!join.getJavaType().equals(TaskDataImpl.class)) continue;
                taskDataJoin = join;
            }
        }
        assert (taskDataJoin != null) : "TaskImpl -> TaskDataImpl join could not be found in query!";
        if (groupIdsPresent) {
            if (peopleAssignJoin == null) {
                peopleAssignJoin = taskRoot.join(TaskImpl_.peopleAssignments);
            }
            ListJoin<PeopleAssignmentsImpl, OrganizationalEntityImpl>[] groupJoins = TaskSummaryQueryCriteriaUtil.getPeopleAssignmentsJoins(peopleAssignJoin);
            for (int i = 0; i < groupJoins.length; ++i) {
                userGroupLimitingPredicates[i + 2] = builder.or((Expression)builder.equal((Expression)groupJoins[i].get(OrganizationalEntityImpl_.id), (Object)userId), (Expression)groupJoins[i].get(OrganizationalEntityImpl_.id).in((Collection)groupIds));
            }
        }
        return builder.or(userGroupLimitingPredicates);
    }

    private static ListJoin<PeopleAssignmentsImpl, OrganizationalEntityImpl>[] getPeopleAssignmentsJoins(Join<TaskImpl, PeopleAssignmentsImpl> peopleAssignJoin) {
        ListJoin[] joins = new ListJoin[3];
        for (Join join : peopleAssignJoin.getJoins()) {
            String joinFieldName = join.getAttribute().getName();
            if (PeopleAssignmentsImpl_.businessAdministrators.getName().equals(joinFieldName)) {
                joins[0] = (ListJoin)join;
                continue;
            }
            if (PeopleAssignmentsImpl_.potentialOwners.getName().equals(joinFieldName)) {
                joins[1] = (ListJoin)join;
                continue;
            }
            if (!PeopleAssignmentsImpl_.taskStakeholders.getName().equals(joinFieldName)) continue;
            joins[2] = (ListJoin)join;
        }
        if (joins[0] == null) {
            joins[0] = peopleAssignJoin.join(PeopleAssignmentsImpl_.businessAdministrators, JoinType.LEFT);
        }
        if (joins[1] == null) {
            joins[1] = peopleAssignJoin.join(PeopleAssignmentsImpl_.potentialOwners, JoinType.LEFT);
        }
        if (joins[2] == null) {
            joins[2] = peopleAssignJoin.join(PeopleAssignmentsImpl_.taskStakeholders, JoinType.LEFT);
        }
        assert (joins[0] != null) : "Could not find business administrators join!";
        assert (joins[1] != null) : "Could not find potential owners join!";
        assert (joins[2] != null) : "Could not find task stakeholders join!";
        return joins;
    }

    private <T> void useDistinctWhenLefOuterJoinsPresent(CriteriaQuery<T> criteriaQuery) {
        boolean useDistinct = false;
        Root taskRoot = null;
        block0: for (Root root : criteriaQuery.getRoots()) {
            if (!TaskImpl.class.equals((Object)root.getJavaType())) continue;
            taskRoot = root;
            for (Join taskJoin : taskRoot.getJoins()) {
                if (!PeopleAssignmentsImpl.class.equals((Object)taskJoin.getJavaType())) continue;
                Join peopleAssignJoin = taskJoin;
                if (JoinType.LEFT.equals((Object)peopleAssignJoin.getJoinType())) {
                    useDistinct = true;
                    break block0;
                }
                for (Join peopleAssignJoinJoin : peopleAssignJoin.getJoins()) {
                    if (!JoinType.LEFT.equals((Object)peopleAssignJoinJoin.getJoinType())) continue;
                    useDistinct = true;
                    break block0;
                }
            }
        }
        if (useDistinct) {
            criteriaQuery.distinct(true);
        }
    }

    protected <T, R> Expression getOrderByExpression(CriteriaQuery<R> query, Class<T> queryType, String orderByListId) {
        List selections = query.getSelection().getCompoundSelectionItems();
        Selection orderBySelection = null;
        if (orderByListId.equals(QueryParameterIdentifiers.TASK_ID_LIST)) {
            orderBySelection = (Selection)selections.get(0);
        } else if (orderByListId.equals(QueryParameterIdentifiers.TASK_NAME_LIST)) {
            orderBySelection = (Selection)selections.get(1);
        } else if (orderByListId.equals(QueryParameterIdentifiers.TASK_STATUS_LIST)) {
            orderBySelection = (Selection)selections.get(4);
        } else if (orderByListId.equals(QueryParameterIdentifiers.CREATED_BY_LIST)) {
            orderBySelection = (Selection)selections.get(8);
        } else if (orderByListId.equals(QueryParameterIdentifiers.CREATED_ON_LIST)) {
            orderBySelection = (Selection)selections.get(9);
        } else if (orderByListId.equals(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST)) {
            orderBySelection = (Selection)selections.get(14);
        }
        return (Expression)orderBySelection;
    }

    public static <Q, T> Predicate taskSpecificCreatePredicateFromSingleCriteria(CriteriaQuery<Q> query, CriteriaBuilder builder, QueryCriteria criteria, QueryWhere queryWhere) {
        Predicate predicate = null;
        String listId = criteria.getListId();
        if (!QueryParameterIdentifiers.TASK_USER_ROLES_LIMIT_LIST.equals(listId)) {
            throw new IllegalStateException("List id " + (String)QueryParameterIdentifiersUtil.getQueryParameterIdNameMap().get(Integer.parseInt(criteria.getListId())) + " is not supported for queries on " + TaskImpl.class.getSimpleName() + ".");
        }
        predicate = TaskSummaryQueryCriteriaUtil.createTaskUserRolesLimitPredicate(criteria, query, builder);
        return predicate;
    }

    static {
        taskUserRoleLimitingListIds.add(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST);
        taskUserRoleLimitingListIds.add(QueryParameterIdentifiers.CREATED_BY_LIST);
        taskUserRoleLimitingListIds.add(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST);
        taskUserRoleLimitingListIds.add(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST);
        taskUserRoleLimitingListIds.add(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST);
    }
}

