/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class IoUtils {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static int findPort() {
        for (int i = 1024; i < 65535; ++i) {
            if (!IoUtils.validPort(i)) continue;
            return i;
        }
        throw new RuntimeException("No valid port could be found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validPort(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static String readFileAsString(File file) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8_CHARSET));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static void copyFile(File sourceFile, File destFile) {
        destFile.getParentFile().mkdirs();
        if (!destFile.exists()) {
            try {
                destFile.createNewFile();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create file " + destFile.getAbsolutePath(), ioe);
            }
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to copy " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath(), ioe);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = IoUtils.createBytesBuffer(input);
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static File copyInTempFile(InputStream input, String fileExtension) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), "." + fileExtension);
        tempFile.deleteOnExit();
        IoUtils.copy(input, new FileOutputStream(tempFile));
        return tempFile;
    }

    public static List<String> recursiveListFile(File folder) {
        return IoUtils.recursiveListFile(folder, "", f -> true);
    }

    public static List<String> recursiveListFile(File folder, String prefix, Predicate<File> filter) {
        ArrayList<String> files = new ArrayList<String>();
        for (File child : IoUtils.safeListFiles(folder)) {
            IoUtils.filesInFolder(files, child, prefix, filter);
        }
        return files;
    }

    private static void filesInFolder(List<String> files, File file, String relativePath, Predicate<File> filter) {
        if (file.isDirectory()) {
            relativePath = relativePath + file.getName() + "/";
            for (File child : IoUtils.safeListFiles(file)) {
                IoUtils.filesInFolder(files, child, relativePath, filter);
            }
        } else if (filter.test(file)) {
            files.add(relativePath + file.getName());
        }
    }

    private static File[] safeListFiles(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            return children;
        }
        throw new IllegalArgumentException(String.format("Unable to retrieve contents of directory '%s'.", file.getAbsolutePath()));
    }

    public static byte[] readBytesFromInputStream(InputStream input) throws IOException {
        byte[] buffer = IoUtils.createBytesBuffer(input);
        ByteArrayOutputStream output = new ByteArrayOutputStream(buffer.length);
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    private static byte[] createBytesBuffer(InputStream input) throws IOException {
        return new byte[Math.max(input.available(), 8192)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesFromZipEntry(File file, ZipEntry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        byte[] bytes = null;
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(file);
            bytes = IoUtils.readBytesFromInputStream(zipFile.getInputStream(entry));
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File f) throws IOException {
        byte[] buf = new byte[1024];
        BufferedInputStream bais = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            bais = new BufferedInputStream(new FileInputStream(f));
            baos = new ByteArrayOutputStream();
            while ((len = bais.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
        return baos.toByteArray();
    }

    public static void write(File f, byte[] data) throws IOException {
        int count;
        if (f.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to sleep");
            }
        }
        IoUtils.writeBytes(f, data);
        for (count = 0; !IoUtils.areByteArraysEqual(data, IoUtils.readBytes(f)) && count < 5; ++count) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            IoUtils.writeBytes(f, data);
        }
        if (count == 5) {
            throw new IOException("Unable to write to file:" + f.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File f, byte[] data) throws IOException {
        byte[] buf = new byte[1024];
        FilterOutputStream bos = null;
        ByteArrayInputStream bais = null;
        try {
            int len;
            bos = new BufferedOutputStream(new FileOutputStream(f));
            bais = new ByteArrayInputStream(data);
            while ((len = bais.read(buf)) > 0) {
                ((BufferedOutputStream)bos).write(buf, 0, len);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int length = b1.length;
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static String asSystemSpecificPath(String urlPath, int colonIndex) {
        String ic = urlPath.substring(Math.max(0, colonIndex - 2), colonIndex + 1);
        if (ic.matches("\\/[A-Z]:")) {
            return urlPath.substring(colonIndex - 2);
        }
        if (ic.matches("[A-Z]:")) {
            return urlPath.substring(colonIndex - 1);
        }
        return urlPath.substring(colonIndex + 1);
    }
}

