/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.admin.commands.AddPeopleAssignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.AddTaskInputsCommand;
import org.jbpm.kie.services.impl.admin.commands.CancelTaskDeadlineCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTaskNotificationsCommand;
import org.jbpm.kie.services.impl.admin.commands.ListTaskReassignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.RemovePeopleAssignmentsCommand;
import org.jbpm.kie.services.impl.admin.commands.RemoveTaskDataCommand;
import org.jbpm.kie.services.impl.admin.commands.ScheduleTaskDeadlineCommand;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.admin.TaskNotification;
import org.jbpm.services.api.admin.TaskReassignment;
import org.jbpm.services.api.admin.UserTaskAdminService;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.kie.api.command.Command;
import org.kie.api.runtime.manager.Context;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalI18NText;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;

public class UserTaskAdminServiceImpl
implements UserTaskAdminService {
    public static final int POT_OWNER = 0;
    public static final int EXCL_OWNER = 1;
    public static final int ADMIN = 2;
    private UserTaskService userTaskService;
    private RuntimeDataService runtimeDataService;
    private IdentityProvider identityProvider;

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setRuntimeDataService(RuntimeDataService runtimeDataService) {
        this.runtimeDataService = runtimeDataService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void addPotentialOwners(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(taskId, removeExisting, 0, orgEntities);
    }

    public void addExcludedOwners(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(taskId, removeExisting, 1, orgEntities);
    }

    public void addBusinessAdmins(long taskId, boolean removeExisting, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.addPeopleAssignment(taskId, removeExisting, 2, orgEntities);
    }

    public void removePotentialOwners(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(taskId, 0, orgEntities);
    }

    public void removeExcludedOwners(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        this.removePeopleAssignment(taskId, 1, orgEntities);
    }

    public void removeBusinessAdmins(long taskId, OrganizationalEntity ... orgEntities) throws TaskNotFoundException, IllegalStateException {
        this.removePeopleAssignment(taskId, 2, orgEntities);
    }

    public void addTaskInput(long taskId, String name, Object value) throws TaskNotFoundException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(name, value);
        this.addTaskInputs(taskId, data);
    }

    public void addTaskInputs(long taskId, Map<String, Object> data) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new AddTaskInputsCommand(this.identityProvider.getName(), taskId, data));
    }

    public void removeTaskInputs(long taskId, String ... name) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemoveTaskDataCommand(this.identityProvider.getName(), taskId, Arrays.asList(name), true));
    }

    public void removeTaskOutputs(long taskId, String ... name) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemoveTaskDataCommand(this.identityProvider.getName(), taskId, Arrays.asList(name), false));
    }

    public Long reassignWhenNotStarted(long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassign(taskId, timeExpression, TaskDeadlinesService.DeadlineType.START, orgEntities);
    }

    public Long reassignWhenNotCompleted(long taskId, String timeExpression, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        return this.reassign(taskId, timeExpression, TaskDeadlinesService.DeadlineType.END, orgEntities);
    }

    public Long notifyWhenNotStarted(long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notify(taskId, timeExpression, TaskDeadlinesService.DeadlineType.START, notification);
    }

    public Long notifyWhenNotCompleted(long taskId, String timeExpression, Notification notification) throws TaskNotFoundException {
        return this.notify(taskId, timeExpression, TaskDeadlinesService.DeadlineType.END, notification);
    }

    public Collection<TaskReassignment> getTaskReassignments(long taskId, boolean activeOnly) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        return (Collection)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ListTaskReassignmentsCommand(this.identityProvider.getName(), taskId, activeOnly));
    }

    public Collection<TaskNotification> getTaskNotifications(long taskId, boolean activeOnly) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        return (Collection)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ListTaskNotificationsCommand(this.identityProvider.getName(), taskId, activeOnly));
    }

    public void cancelNotification(long taskId, long notificationId) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new CancelTaskDeadlineCommand(this.identityProvider.getName(), taskId, notificationId));
    }

    public void cancelReassignment(long taskId, long reassignmentId) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new CancelTaskDeadlineCommand(this.identityProvider.getName(), taskId, reassignmentId));
    }

    public EmailNotification buildEmailNotification(String subjectStr, List<OrganizationalEntity> recipients, String bodyStr, String fromStr, String replyToStr) {
        EmailNotification emailNotification = TaskModelProvider.getFactory().newEmialNotification();
        HashMap<Language, EmailNotificationHeader> emailHeaders = new HashMap<Language, EmailNotificationHeader>();
        ArrayList<I18NText> subjects = new ArrayList<I18NText>();
        ArrayList<I18NText> names = new ArrayList<I18NText>();
        String locale = "en-UK";
        EmailNotificationHeader emailHeader = TaskModelProvider.getFactory().newEmailNotificationHeader();
        emailHeader.setBody(bodyStr);
        emailHeader.setFrom(fromStr);
        emailHeader.setReplyTo(replyToStr);
        emailHeader.setLanguage(locale);
        emailHeader.setSubject(subjectStr);
        Language lang = TaskModelProvider.getFactory().newLanguage();
        lang.setMapkey(locale);
        emailHeaders.put(lang, emailHeader);
        I18NText subject = TaskModelProvider.getFactory().newI18NText();
        ((InternalI18NText)subject).setLanguage(locale);
        ((InternalI18NText)subject).setText(emailHeader.getSubject());
        subjects.add(subject);
        names.add(subject);
        emailNotification.setEmailHeaders(emailHeaders);
        emailNotification.setNames(names);
        emailNotification.setRecipients(new ArrayList<OrganizationalEntity>(recipients));
        emailNotification.setSubjects(subjects);
        return emailNotification;
    }

    protected void addPeopleAssignment(long taskId, boolean removeExisting, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new AddPeopleAssignmentsCommand(this.identityProvider.getName(), taskId, type, orgEntities, removeExisting));
    }

    protected void removePeopleAssignment(long taskId, int type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new RemovePeopleAssignmentsCommand(this.identityProvider.getName(), taskId, type, orgEntities));
    }

    protected Long reassign(long taskId, String timeExpression, TaskDeadlinesService.DeadlineType type, OrganizationalEntity ... orgEntities) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        Deadline taskDeadline = TaskModelProvider.getFactory().newDeadline();
        taskDeadline.setEscalations(escalations);
        Escalation escalation = TaskModelProvider.getFactory().newEscalation();
        escalations.add(escalation);
        escalation.setName("Admin reassignment for task " + taskId);
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        Reassignment reassignment = TaskModelProvider.getFactory().newReassignment();
        reassignment.setPotentialOwners(new ArrayList<OrganizationalEntity>(Arrays.asList(orgEntities)));
        reassignments.add(reassignment);
        escalation.setReassignments(reassignments);
        return (Long)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ScheduleTaskDeadlineCommand(this.identityProvider.getName(), taskId, type, taskDeadline, timeExpression));
    }

    protected Long notify(long taskId, String timeExpression, TaskDeadlinesService.DeadlineType type, Notification notification) throws TaskNotFoundException {
        UserTaskInstanceDesc task = this.runtimeDataService.getTaskById(Long.valueOf(taskId));
        if (task == null) {
            throw new TaskNotFoundException("Task with id " + taskId + " not found");
        }
        ArrayList<Escalation> escalations = new ArrayList<Escalation>();
        Deadline taskDeadline = TaskModelProvider.getFactory().newDeadline();
        taskDeadline.setEscalations(escalations);
        Escalation escalation = TaskModelProvider.getFactory().newEscalation();
        escalations.add(escalation);
        escalation.setName("Admin notification for task " + taskId);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        notifications.add(notification);
        escalation.setNotifications(notifications);
        return (Long)this.userTaskService.execute(task.getDeploymentId(), (Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()), (Command)new ScheduleTaskDeadlineCommand(this.identityProvider.getName(), taskId, type, taskDeadline, timeExpression));
    }
}

