/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerHelper;
import org.drools.persistence.api.Transformable;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.api.PersistentCorrelationKey;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.api.ProcessPersistenceContext;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;

public class JpaProcessPersistenceContext
extends JpaPersistenceContext
implements ProcessPersistenceContext {
    public JpaProcessPersistenceContext(EntityManager em, TransactionManager txm) {
        super(em, txm);
    }

    public JpaProcessPersistenceContext(EntityManager em, boolean useJTA, boolean locking, TransactionManager txm) {
        super(em, useJTA, locking, txm);
    }

    public PersistentProcessInstance persist(PersistentProcessInstance processInstanceInfo) {
        EntityManager em = this.getEntityManager();
        em.persist((Object)processInstanceInfo);
        TransactionManagerHelper.addToUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        if (this.pessimisticLocking) {
            em.flush();
            return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processInstanceInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return processInstanceInfo;
    }

    public PersistentProcessInstance findProcessInstanceInfo(Long processId) {
        EntityManager em = this.getEntityManager();
        if (this.pessimisticLocking) {
            return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processId, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return (PersistentProcessInstance)em.find(ProcessInstanceInfo.class, (Object)processId);
    }

    public void remove(PersistentProcessInstance processInstanceInfo) {
        this.getEntityManager().remove((Object)processInstanceInfo);
        TransactionManagerHelper.removeFromUpdatableSet((TransactionManager)this.txm, (Transformable)processInstanceInfo);
        List correlations = this.getEntityManager().createNamedQuery("GetCorrelationKeysByProcessInstanceId").setParameter("pId", (Object)processInstanceInfo.getId()).getResultList();
        if (correlations != null) {
            for (CorrelationKeyInfo key : correlations) {
                this.getEntityManager().remove((Object)key);
            }
        }
    }

    public List<Long> getProcessInstancesWaitingForEvent(String type) {
        EntityManager entityManager = this.getEntityManager();
        if (entityManager != null) {
            Query processInstancesForEvent = this.getEntityManager().createNamedQuery("ProcessInstancesWaitingForEvent");
            processInstancesForEvent.setParameter("type", (Object)type);
            return processInstancesForEvent.getResultList();
        }
        return new ArrayList<Long>();
    }

    public PersistentCorrelationKey persist(PersistentCorrelationKey correlationKeyInfo) {
        Long processInstanceId = this.getProcessInstanceByCorrelationKey((CorrelationKey)correlationKeyInfo);
        if (processInstanceId != null) {
            throw new RuntimeException(correlationKeyInfo + " already exists");
        }
        EntityManager em = this.getEntityManager();
        em.persist((Object)correlationKeyInfo);
        if (this.pessimisticLocking) {
            em.flush();
            return (PersistentCorrelationKey)em.find(CorrelationKeyInfo.class, (Object)correlationKeyInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return correlationKeyInfo;
    }

    public Long getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        Query processInstancesForEvent = this.getEntityManager().createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("elem_count", (Object)new Long(correlationKey.getProperties().size()));
        ArrayList<Object> properties = new ArrayList<Object>();
        for (CorrelationProperty property : correlationKey.getProperties()) {
            properties.add(property.getValue());
        }
        processInstancesForEvent.setParameter("properties", properties);
        try {
            return (Long)processInstancesForEvent.getSingleResult();
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

