/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.group;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;

public enum AggregateFunctionType {
    COUNT,
    DISTINCT,
    AVERAGE,
    SUM,
    MIN,
    MAX;

    private static AggregateFunctionType[] _typeArray;
    private static List<AggregateFunctionType> _numericOnly;

    public int getIndex() {
        for (int i = 0; i < _typeArray.length; ++i) {
            AggregateFunctionType type = _typeArray[i];
            if (!this.equals((Object)type)) continue;
            return i;
        }
        return -1;
    }

    public boolean supportType(ColumnType type) {
        if (_numericOnly.contains((Object)this)) {
            return type != null && type.equals((Object)ColumnType.NUMBER);
        }
        return true;
    }

    public static AggregateFunctionType getByIndex(int index) {
        return _typeArray[index];
    }

    public static AggregateFunctionType getByName(String str) {
        try {
            return AggregateFunctionType.valueOf(str.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        _typeArray = AggregateFunctionType.values();
        _numericOnly = Arrays.asList(AVERAGE, SUM, MAX, MIN);
    }
}

