/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.InternalExecutable;
import org.drools.core.runtime.ChainableRunner;
import org.drools.core.runtime.InternalLocalRunner;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.events.TaskEventSupport;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.RequestContext;

public class TaskCommandExecutorImpl
implements InternalLocalRunner {
    private Environment environment;
    private TaskEventSupport taskEventSupport;
    private InternalLocalRunner commandService = new SelfExecutionCommandService(this);

    public TaskCommandExecutorImpl(Environment environment, TaskEventSupport taskEventSupport) {
        this.environment = environment;
        this.taskEventSupport = taskEventSupport;
    }

    public RequestContext execute(Executable executable, RequestContext ctx) {
        return (RequestContext)this.commandService.execute(executable, (Context)ctx);
    }

    public <T> T execute(Command<T> command) {
        return (T)this.commandService.execute(command);
    }

    public void addInterceptor(ChainableRunner interceptor) {
        interceptor.setNext((ExecutableRunner)this.commandService);
        this.commandService = interceptor;
    }

    public RequestContext createContext() {
        if (this.commandService instanceof SelfExecutionCommandService) {
            return new TaskContext();
        }
        return new TaskContext(this.commandService.createContext(), this.environment, this.taskEventSupport);
    }

    private class SelfExecutionCommandService
    implements InternalLocalRunner {
        private TaskCommandExecutorImpl owner;

        SelfExecutionCommandService(TaskCommandExecutorImpl owner) {
            this.owner = owner;
        }

        public RequestContext execute(Executable executable, RequestContext context) {
            for (Batch batch : ((InternalExecutable)executable).getBatches()) {
                for (Command command : batch.getCommands()) {
                    if (command instanceof TaskCommand) {
                        Object result = ((ExecutableCommand)command).execute((Context)new TaskContext((Context)context, TaskCommandExecutorImpl.this.environment, TaskCommandExecutorImpl.this.taskEventSupport));
                        context.set("Result", result);
                        continue;
                    }
                    throw new IllegalArgumentException("Task service can only execute task commands");
                }
            }
            return context;
        }

        public RequestContext createContext() {
            return this.owner.createContext();
        }
    }
}

