/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.kie.services.api.DeploymentIdResolver;
import org.jbpm.kie.services.impl.CommonUtils;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.kie.services.impl.security.DeploymentRolesManager;
import org.jbpm.runtime.manager.impl.identity.UserDataServiceProvider;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.services.task.audit.service.TaskAuditService;
import org.jbpm.services.task.impl.TaskSummaryQueryBuilderImpl;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.internal.task.query.TaskSummaryQueryBuilder;

public class RuntimeDataServiceImpl
implements RuntimeDataService,
DeploymentEventListener {
    private static final String DEPLOYMENT_ID_MUST_NOT_BE_NULL = "DeploymentId must not be null";
    private static final String TASK_NOT_FOUND = "No task found with id {0}";
    protected Set<String> deploymentIds = new HashSet<String>();
    protected Set<ProcessDefinition> availableProcesses = new HashSet<ProcessDefinition>();
    private TransactionalCommandService commandService;
    private IdentityProvider identityProvider;
    protected TaskService taskService;
    protected TaskAuditService taskAuditService;
    private DeploymentRolesManager deploymentRolesManager = new DeploymentRolesManager();
    private UserGroupCallback userGroupCallback = UserDataServiceProvider.getUserGroupCallback();
    private static final List<Status> allActiveStatus = Arrays.asList(Status.Created, Status.Ready, Status.Reserved, Status.InProgress, Status.Suspended);

    public RuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/Servicesorm.xml");
        QueryManager.get().addNamedQueries("META-INF/TaskAuditorm.xml");
        QueryManager.get().addNamedQueries("META-INF/Taskorm.xml");
        ServiceRegistry.get().register(RuntimeDataService.class.getSimpleName(), (Object)this);
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public void setTaskAuditService(TaskAuditService taskAuditService) {
        this.taskAuditService = taskAuditService;
    }

    public void setDeploymentRolesManager(DeploymentRolesManager deploymentRolesManager) {
        this.deploymentRolesManager = deploymentRolesManager;
    }

    private void addProcessDefinition(ProcessAssetDesc asset) {
        this.availableProcesses.add(asset);
        this.deploymentIds.add(asset.getDeploymentId());
    }

    private void removeAllProcessDefinitions(Collection<ProcessAssetDesc> assets) {
        for (ProcessAssetDesc asset : assets) {
            this.availableProcesses.remove(asset);
            this.deploymentIds.remove(asset.getDeploymentId());
        }
    }

    private String getLatestDeploymentId(String deploymentId) {
        String matched = deploymentId;
        if (deploymentId != null && deploymentId.toLowerCase().endsWith("latest")) {
            matched = DeploymentIdResolver.matchAndReturnLatest(deploymentId, this.deploymentIds);
        }
        return matched;
    }

    public void onDeploy(DeploymentEvent event) {
        Collection assets = event.getDeployedUnit().getDeployedAssets();
        List<String> roles = null;
        for (DeployedAsset asset : assets) {
            if (!(asset instanceof ProcessAssetDesc)) continue;
            this.addProcessDefinition((ProcessAssetDesc)asset);
            if (roles != null) continue;
            roles = ((ProcessAssetDesc)asset).getRoles();
        }
        if (roles == null) {
            roles = Collections.emptyList();
        }
        this.deploymentRolesManager.addRolesForDeployment(event.getDeploymentId(), roles);
    }

    public void onUnDeploy(DeploymentEvent event) {
        HashSet<ProcessAssetDesc> outputCollection = new HashSet<ProcessAssetDesc>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        this.removeAllProcessDefinitions(outputCollection);
        this.deploymentRolesManager.removeRolesForDeployment(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        for (ProcessAssetDesc process : outputCollection) {
            process.setActive(true);
        }
    }

    public void onDeactivate(DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new UnsecureByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        for (ProcessAssetDesc process : outputCollection) {
            process.setActive(false);
        }
    }

    protected void applyQueryContext(Map<String, Object> params, QueryContext queryContext) {
        if (queryContext != null) {
            params.put("firstResult", queryContext.getOffset());
            params.put("maxResults", queryContext.getCount());
            if (queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
                params.put("orderby", queryContext.getOrderBy());
                if (queryContext.isAscending().booleanValue()) {
                    params.put("asc", "true");
                } else {
                    params.put("desc", "true");
                }
            }
        }
    }

    protected void applyDeploymentFilter(Map<String, Object> params) {
        List<String> deploymentIdForUser = this.deploymentRolesManager.getDeploymentsForUser(this.identityProvider);
        if (deploymentIdForUser != null && !deploymentIdForUser.isEmpty()) {
            params.put("filter", " log.externalId in (:deployments) ");
            params.put("deployments", deploymentIdForUser);
        }
    }

    protected <T> Collection<T> applyPaginition(List<T> input, QueryContext queryContext) {
        if (queryContext != null) {
            int start = queryContext.getOffset();
            int end = start + queryContext.getCount();
            if (input.size() < start) {
                return new ArrayList();
            }
            if (input.size() >= end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, end)));
            }
            if (input.size() < end) {
                return Collections.unmodifiableCollection(new ArrayList<T>(input.subList(start, input.size())));
            }
        }
        return Collections.unmodifiableCollection(input);
    }

    protected void applySorting(List<ProcessDefinition> input, final QueryContext queryContext) {
        if (queryContext != null && queryContext.getOrderBy() != null && !queryContext.getOrderBy().isEmpty()) {
            Collections.sort(input, new Comparator<ProcessDefinition>(){

                @Override
                public int compare(ProcessDefinition o1, ProcessDefinition o2) {
                    if ("ProcessName".equals(queryContext.getOrderBy())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    if ("ProcessVersion".equals(queryContext.getOrderBy())) {
                        return o1.getVersion().compareTo(o2.getVersion());
                    }
                    if ("Project".equals(queryContext.getOrderBy())) {
                        return o1.getDeploymentId().compareTo(o2.getDeploymentId());
                    }
                    return 0;
                }
            });
            if (!queryContext.isAscending().booleanValue()) {
                Collections.reverse(input);
            }
        }
    }

    public Collection<ProcessDefinition> getProcessesByDeploymentId(String deploymentId, QueryContext queryContext) {
        deploymentId = this.getLatestDeploymentId(Objects.requireNonNull(deploymentId, DEPLOYMENT_ID_MUST_NOT_BE_NULL));
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(deploymentId, this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    public ProcessDefinition getProcessesByDeploymentIdProcessId(String deploymentId, String processId) {
        deploymentId = this.getLatestDeploymentId(Objects.requireNonNull(deploymentId, DEPLOYMENT_ID_MUST_NOT_BE_NULL));
        ArrayList outputCollection = new ArrayList();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdProcessIdPredicate(deploymentId, processId, this.identityProvider.getRoles(), true), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessDefinition)outputCollection.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcessesByFilter(String filter, QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new RegExPredicate("(?i)^.*" + filter + ".*$", this.identityProvider.getRoles()), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    @Deprecated
    public ProcessDefinition getProcessById(String processId) {
        Collection<ProcessDefinition> definitions = this.getProcessesById(processId);
        if (!definitions.isEmpty()) {
            return definitions.iterator().next();
        }
        return null;
    }

    public Collection<ProcessDefinition> getProcessesById(String processId) {
        HashSet<ProcessDefinition> outputCollection = new HashSet<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByProcessIdPredicate(processId, this.identityProvider.getRoles()), outputCollection);
        return outputCollection;
    }

    public Collection<ProcessDefinition> getProcesses(QueryContext queryContext) {
        ArrayList<ProcessDefinition> outputCollection = new ArrayList<ProcessDefinition>();
        CollectionUtils.select(this.availableProcesses, (Predicate)new SecurePredicate(this.identityProvider.getRoles(), false), outputCollection);
        this.applySorting(outputCollection, queryContext);
        return this.applyPaginition(outputCollection, queryContext);
    }

    public Collection<String> getProcessIds(String deploymentId, QueryContext queryContext) {
        deploymentId = this.getLatestDeploymentId(Objects.requireNonNull(deploymentId, DEPLOYMENT_ID_MUST_NOT_BE_NULL));
        ArrayList<String> processIds = new ArrayList<String>(this.availableProcesses.size());
        if (deploymentId == null || deploymentId.isEmpty()) {
            return processIds;
        }
        for (ProcessDefinition procAssetDesc : this.availableProcesses) {
            if (!((ProcessAssetDesc)procAssetDesc).getDeploymentId().equals(deploymentId) || !((ProcessAssetDesc)procAssetDesc).isActive()) continue;
            processIds.add(procAssetDesc.getId());
        }
        return this.applyPaginition(processIds, queryContext);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstances(QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstances", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states, QueryContext queryContext) {
        deploymentId = this.getLatestDeploymentId(Objects.requireNonNull(deploymentId, DEPLOYMENT_ID_MUST_NOT_BE_NULL));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("externalId", deploymentId);
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByDeploymentId", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processDefId", processDefId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessDefinition", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processDefId);
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public org.jbpm.services.api.model.ProcessInstanceDesc getProcessInstanceById(long processId) {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("processId", Long.valueOf(processId));
        params.put("maxResults", Integer.valueOf(1));
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceById", params));
        if (!processInstances.isEmpty()) {
            org.jbpm.services.api.model.ProcessInstanceDesc desc = (org.jbpm.services.api.model.ProcessInstanceDesc)processInstances.iterator().next();
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.add(Status.Ready.name());
            statuses.add(Status.Reserved.name());
            statuses.add(Status.InProgress.name());
            params = new HashMap();
            params.put("processInstanceId", desc.getId());
            params.put("statuses", statuses);
            List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstancesByProcessInstanceId", params));
            ((ProcessInstanceDesc)desc).setActiveTasks(tasks);
            return desc;
        }
        return null;
    }

    public org.jbpm.services.api.model.ProcessInstanceDesc getProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm());
        params.put("maxResults", 1);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceByCorrelationKey", params));
        if (!processInstances.isEmpty()) {
            org.jbpm.services.api.model.ProcessInstanceDesc desc = (org.jbpm.services.api.model.ProcessInstanceDesc)processInstances.iterator().next();
            ArrayList<String> statuses = new ArrayList<String>();
            statuses.add(Status.Ready.name());
            statuses.add(Status.Reserved.name());
            statuses.add(Status.InProgress.name());
            params = new HashMap();
            params.put("processInstanceId", desc.getId());
            params.put("statuses", statuses);
            List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstancesByProcessInstanceId", params));
            ((ProcessInstanceDesc)desc).setActiveTasks(tasks);
            return desc;
        }
        return null;
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByCorrelationKey(CorrelationKey correlationKey, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm() + "%");
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByCorrelationKey", params));
        return processInstances;
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByCorrelationKeyAndStatus(CorrelationKey correlationKey, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm() + "%");
        params.put("states", states);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByCorrelationKeyAndStatus", params));
        return processInstances;
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessIdAndStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator, QueryContext queryContext) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        if (initiator == null) {
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatus", params));
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByProcessNameAndStatusAndInitiator", params));
        }
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByVariable(String variableName, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (states == null || states.isEmpty()) {
            states = new ArrayList<Integer>();
            states.add(1);
        }
        params.put("states", states);
        params.put("variable", variableName);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByVariableName", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByVariableAndValue(String variableName, String variableValue, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (states == null || states.isEmpty()) {
            states = new ArrayList<Integer>();
            states.add(1);
        }
        params.put("states", states);
        params.put("variable", variableName);
        params.put("variableValue", variableValue);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByVariableNameAndValue", params));
        return Collections.unmodifiableCollection(processInstances);
    }

    public Collection<org.jbpm.services.api.model.ProcessInstanceDesc> getProcessInstancesByParent(Long parentProcessInstanceId, List<Integer> states, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (states == null || states.isEmpty()) {
            states = new ArrayList<Integer>();
            states.add(1);
        }
        params.put("states", states);
        params.put("parentId", parentProcessInstanceId);
        this.applyQueryContext(params, queryContext);
        this.applyDeploymentFilter(params);
        List processInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstancesByParent", params));
        return processInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryActive(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, false, queryContext);
    }

    public Collection<NodeInstanceDesc> getProcessInstanceHistoryCompleted(long processId, QueryContext queryContext) {
        return this.getProcessInstanceHistory(processId, true, queryContext);
    }

    protected Collection<NodeInstanceDesc> getProcessInstanceHistory(long processId, boolean completed, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = Collections.emptyList();
        nodeInstances = completed ? (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceCompletedNodes", params)) : (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceActiveNodes", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(long processId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistory", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getProcessInstanceFullHistoryByType(long processId, RuntimeDataService.EntryType type, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("type", type.getValue());
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getProcessInstanceFullHistoryByType", params));
        return nodeInstances;
    }

    public NodeInstanceDesc getNodeInstanceForWorkItem(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getNodeInstanceForWorkItem", params));
        if (!nodeInstances.isEmpty()) {
            return (NodeInstanceDesc)nodeInstances.iterator().next();
        }
        return null;
    }

    public Collection<NodeInstanceDesc> getNodeInstancesByNodeType(long processInstanceId, List<String> nodeTypes, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("nodeTypes", nodeTypes);
        this.applyQueryContext(params, queryContext);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getNodeInstancesByNodeType", params));
        return nodeInstances;
    }

    public Collection<NodeInstanceDesc> getNodeInstancesByCorrelationKeyNodeType(CorrelationKey correlationKey, List<Integer> states, List<String> nodeTypes, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("correlationKey", correlationKey.toExternalForm() + "%");
        params.put("states", states);
        params.put("nodeTypes", nodeTypes);
        List nodeInstances = (List)this.commandService.execute((Command)new QueryNameCommand("getNodeInstancesByCorrelationKeyAndNodeType", params));
        return nodeInstances;
    }

    public Collection<VariableDesc> getVariablesCurrentState(long processInstanceId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariablesCurrentState", params));
        return variablesState;
    }

    public Collection<VariableDesc> getVariableHistory(long processInstanceId, String variableId, QueryContext queryContext) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("variableId", variableId);
        this.applyQueryContext(params, queryContext);
        List variablesState = (List)this.commandService.execute((Command)new QueryNameCommand("getVariableHistory", params));
        return variablesState;
    }

    public UserTaskInstanceDesc getTaskByWorkItemId(Long workItemId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("workItemId", workItemId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceByWorkItemId", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public UserTaskInstanceDesc getTaskById(Long taskId) {
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("taskId", taskId);
        params.put("maxResults", 1);
        List tasks = (List)this.commandService.execute((Command)new QueryNameCommand("getTaskInstanceById", params));
        if (!tasks.isEmpty()) {
            return (UserTaskInstanceDesc)tasks.iterator().next();
        }
        return null;
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministrator(String userId, QueryFilter filter) {
        return this.getTasksAssignedAsBusinessAdministratorByStatus(userId, null, filter);
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        params.put("status", allActiveStatus);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("NewTasksAssignedAsPotentialOwner", params));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksAssignedAsPotentialOwnerWithGroups", params));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", this.adoptList(groupIds, CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId)));
        params.put("status", this.adoptList(status, allActiveStatus));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("NewTasksAssignedAsPotentialOwner", params));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("groupIds", CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        params.put("status", this.adoptList(status, allActiveStatus));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("NewTasksAssignedAsPotentialOwner", params));
    }

    public List<TaskSummary> getTasksAssignedAsPotentialOwnerByExpirationDateOptional(String userId, List<Status> status, Date from, QueryFilter filter) {
        List<TaskSummary> taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = this.getTasksAssignedAsPotentialOwnerByStatus(userId, status, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = this.getTasksAssignedAsPotentialOwnerByStatus(userId, status, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwnedByExpirationDateOptional(String userId, List<Status> strStatuses, Date from, QueryFilter filter) {
        List<TaskSummary> taskSummaries = null;
        if (from != null) {
            HashMap<String, Date> params = new HashMap<String, Date>();
            params.put("expirationDate", from);
            QueryFilter qf = new QueryFilter("(t.taskData.expirationTime = :expirationDate or t.taskData.expirationTime is null)", params, "order by t.id DESC", filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = this.getTasksOwnedByStatus(userId, strStatuses, qf);
        } else {
            QueryFilter qf = new QueryFilter(filter.getOffset().intValue(), filter.getCount().intValue());
            taskSummaries = this.getTasksOwnedByStatus(userId, strStatuses, qf);
        }
        return taskSummaries;
    }

    public List<TaskSummary> getTasksOwned(String userId, QueryFilter filter) {
        return this.getTasksOwnedByStatus(userId, null, filter);
    }

    public List<TaskSummary> getTasksOwnedByStatus(String userId, List<Status> status, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", this.adoptList(status, allActiveStatus));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("NewTasksOwned", params));
    }

    public List<Long> getTasksByProcessInstanceId(Long processInstanceId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("processInstanceId", processInstanceId);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksByProcessInstanceId", params));
    }

    public List<TaskSummary> getTasksByStatusByProcessInstanceId(Long processInstanceId, List<Status> status, QueryFilter filter) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Status>();
            status.add(Status.Created);
            status.add(Status.Ready);
            status.add(Status.Reserved);
            status.add(Status.InProgress);
            status.add(Status.Suspended);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processInstanceId", processInstanceId);
        params.put("status", status);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksByStatusByProcessId", params));
    }

    public List<TaskSummary> getTasksAssignedAsBusinessAdministratorByStatus(String userId, List<Status> statuses, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("status", this.adoptList(statuses, allActiveStatus));
        params.put("groupIds", CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        return (List)this.commandService.execute((Command)new QueryNameCommand("TasksAssignedAsBusinessAdministratorByStatus", params));
    }

    public TaskSummaryQueryBuilder taskSummaryQuery(String userId) {
        return new TaskSummaryQueryBuilderImpl(userId, this.taskService);
    }

    public List<TaskSummary> getTasksByVariable(String userId, String variableName, List<Status> statuses, QueryContext queryContext) {
        TaskSummaryQueryBuilder queryBuilder = (TaskSummaryQueryBuilder)new TaskSummaryQueryBuilderImpl(userId, this.taskService).intersect();
        this.addVariableNameAndVariableValueParameters(queryBuilder, variableName);
        if (statuses != null && !statuses.isEmpty()) {
            queryBuilder.status(statuses.toArray(new Status[statuses.size()]));
        }
        this.setQueryContextOptions(queryContext, queryBuilder);
        return queryBuilder.build().getResultList();
    }

    public List<TaskSummary> getTasksByVariableAndValue(String userId, String variableName, String variableValue, List<Status> statuses, QueryContext queryContext) {
        TaskSummaryQueryBuilder queryBuilder = (TaskSummaryQueryBuilder)new TaskSummaryQueryBuilderImpl(userId, this.taskService).intersect();
        this.addVariableNameAndVariableValueParameters(queryBuilder, variableName, variableValue);
        if (statuses != null && !statuses.isEmpty()) {
            queryBuilder.status(statuses.toArray(new Status[statuses.size()]));
        }
        this.setQueryContextOptions(queryContext, queryBuilder);
        return queryBuilder.build().getResultList();
    }

    private void setQueryContextOptions(QueryContext queryContext, TaskSummaryQueryBuilder queryBuilder) {
        if (queryContext != null) {
            String orderBy;
            Integer param = queryContext.getOffset();
            if (param != null) {
                queryBuilder.offset(param.intValue());
            }
            if ((param = queryContext.getCount()) != null) {
                queryBuilder.maxResults(param.intValue());
            }
            if ((orderBy = queryContext.getOrderBy()) != null) {
                orderBy = orderBy.toLowerCase();
                boolean orderBySet = false;
                for (TaskSummaryQueryBuilder.OrderBy orderByEnum : TaskSummaryQueryBuilder.OrderBy.values()) {
                    if (!orderBy.equals(orderByEnum.toString().toLowerCase())) continue;
                    if (queryContext.isAscending().booleanValue()) {
                        queryBuilder.ascending(orderByEnum);
                    } else {
                        queryBuilder.descending(orderByEnum);
                    }
                    orderBySet = true;
                    break;
                }
                if (!orderBySet) {
                    throw new IllegalArgumentException("Unsupported QueryContext.orderBy value: \"" + orderBy + "\"");
                }
            }
        }
    }

    private void addVariableNameAndVariableValueParameters(TaskSummaryQueryBuilder queryBuilder, String ... variableNameOrValue) {
        if (variableNameOrValue.length > 0) {
            if (variableNameOrValue[0].contains("*") || variableNameOrValue[0].contains("?")) {
                queryBuilder.regex();
            }
            queryBuilder.variableName(new String[]{variableNameOrValue[0]}).equals();
        }
        if (variableNameOrValue.length > 1) {
            if (variableNameOrValue[1].contains("*") || variableNameOrValue[1].contains("?")) {
                queryBuilder.regex();
            }
            queryBuilder.variableValue(new String[]{variableNameOrValue[1]}).equals();
        }
        if (variableNameOrValue.length > 2) {
            throw new IllegalStateException("Only String arguments expected for the " + Thread.currentThread().getStackTrace()[0].getMethodName() + " method!");
        }
    }

    public List<AuditTask> getAllAuditTask(String userId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", userId);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllAuditTasksByUser", params));
        return auditTasks;
    }

    public List<AuditTask> getAllAuditTaskByStatus(String userId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("owner", userId);
        params.put("statuses", filter.getParams().get("statuses"));
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllAuditTasksByStatus", params));
        return auditTasks;
    }

    public List<AuditTask> getAllGroupAuditTask(String userId, QueryFilter filter) {
        ArrayList<String> owners = new ArrayList<String>();
        owners.add(userId);
        owners.addAll(CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("potentialOwners", owners);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllGroupAuditTasksByUser", params));
        return auditTasks;
    }

    public List<AuditTask> getAllAdminAuditTask(String userId, QueryFilter filter) {
        ArrayList<String> businessAdmins = new ArrayList<String>();
        businessAdmins.add(userId);
        businessAdmins.addAll(CommonUtils.getCallbackUserRoles(this.userGroupCallback, userId));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessAdmins", businessAdmins);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List auditTasks = (List)this.commandService.execute((Command)new QueryNameCommand("getAllAdminAuditTasksByUser", params));
        return auditTasks;
    }

    public List<TaskEvent> getTaskEvents(long taskId, QueryFilter filter) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", taskId);
        this.applyQueryContext(params, (QueryContext)filter);
        this.applyQueryFilter(params, filter);
        List taskEvents = (List)this.commandService.execute((Command)new QueryNameCommand("getAllTasksEvents", params));
        if (taskEvents == null || taskEvents.size() < 1) {
            throw new TaskNotFoundException(MessageFormat.format(TASK_NOT_FOUND, taskId));
        }
        return taskEvents;
    }

    protected void applyQueryFilter(Map<String, Object> params, QueryFilter queryFilter) {
        if (queryFilter != null) {
            this.applyQueryContext(params, (QueryContext)queryFilter);
            if (queryFilter.getFilterParams() != null && !queryFilter.getFilterParams().isEmpty()) {
                params.put("filter", queryFilter.getFilterParams());
                for (String key : queryFilter.getParams().keySet()) {
                    params.put(key, queryFilter.getParams().get(key));
                }
            }
        }
    }

    protected List<?> adoptList(List<?> source, List<?> values) {
        if (source == null || source.isEmpty()) {
            ArrayList data = new ArrayList();
            for (Object value : values) {
                data.add(value);
            }
            return data;
        }
        return source;
    }

    private class ActiveOnlyPredicate
    implements Predicate {
        private ActiveOnlyPredicate() {
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).isActive();
        }
    }

    private class UnsecureByDeploymentIdPredicate
    implements Predicate {
        private String deploymentId;

        private UnsecureByDeploymentIdPredicate(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public boolean evaluate(Object object) {
            ProcessAssetDesc pDesc;
            return object instanceof ProcessAssetDesc && (pDesc = (ProcessAssetDesc)object).getDeploymentId().equals(this.deploymentId);
        }
    }

    private class SecurePredicate
    extends ActiveOnlyPredicate {
        private List<String> roles;
        private boolean skipActivCheck;

        private SecurePredicate(List<String> roles, boolean skipActivCheck) {
            this.roles = roles;
            this.skipActivCheck = skipActivCheck;
        }

        @Override
        public boolean evaluate(Object object) {
            boolean isActive;
            if (!this.skipActivCheck && !(isActive = super.evaluate(object))) {
                return false;
            }
            ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
            if (this.roles == null || this.roles.isEmpty() || pDesc.getRoles() == null || pDesc.getRoles().isEmpty()) {
                return true;
            }
            return CollectionUtils.containsAny(this.roles, pDesc.getRoles());
        }
    }

    private class ByDeploymentIdProcessIdPredicate
    extends SecurePredicate {
        private String processId;
        private String depoymentId;

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles) {
            super(roles, false);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        private ByDeploymentIdProcessIdPredicate(String depoymentId, String processId, List<String> roles, boolean skipActiveCheck) {
            super(roles, skipActiveCheck);
            this.depoymentId = depoymentId;
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId) && pDesc.getDeploymentId().equals(this.depoymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByProcessIdPredicate
    extends SecurePredicate {
        private String processId;

        private ByProcessIdPredicate(String processId, List<String> roles) {
            super(roles, false);
            this.processId = processId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().equals(this.processId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ByDeploymentIdPredicate
    extends SecurePredicate {
        private String deploymentId;

        private ByDeploymentIdPredicate(String deploymentId, List<String> roles) {
            super(roles, false);
            this.deploymentId = deploymentId;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getDeploymentId().equals(this.deploymentId)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class RegExPredicate
    extends SecurePredicate {
        private String pattern;

        private RegExPredicate(String pattern, List<String> roles) {
            super(roles, false);
            this.pattern = pattern;
        }

        @Override
        public boolean evaluate(Object object) {
            if (object instanceof ProcessAssetDesc) {
                ProcessAssetDesc pDesc = (ProcessAssetDesc)object;
                boolean hasAccess = super.evaluate(object);
                if (!hasAccess) {
                    return false;
                }
                if (pDesc.getId().matches(this.pattern) || pDesc.getName().matches(this.pattern)) {
                    return true;
                }
            }
            return false;
        }
    }
}

