/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.Map;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Interceptor;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.NullPrecedence;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.internal.SessionFactoryOptionsState;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.QueryCacheFactory;
import org.hibernate.cfg.BaselineSessionEventsListenerBuilder;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.tuple.entity.EntityTuplizerFactory;

public class SessionFactoryOptionsImpl
implements SessionFactoryOptions {
    private final StandardServiceRegistry serviceRegistry;
    private final Object beanManagerReference;
    private final Object validatorFactoryReference;
    private final String sessionFactoryName;
    private final boolean sessionFactoryNameAlsoJndiName;
    private final boolean flushBeforeCompletionEnabled;
    private final boolean autoCloseSessionEnabled;
    private final boolean jtaTrackByThread;
    private final boolean preferUserTransaction;
    private final boolean statisticsEnabled;
    private final Interceptor interceptor;
    private final StatementInspector statementInspector;
    private final SessionFactoryObserver[] sessionFactoryObserverList;
    private final BaselineSessionEventsListenerBuilder baselineSessionEventsListenerBuilder;
    private final CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
    private final EntityNameResolver[] entityNameResolvers;
    private final EntityNotFoundDelegate entityNotFoundDelegate;
    private final boolean identifierRollbackEnabled;
    private final EntityMode defaultEntityMode;
    private final EntityTuplizerFactory entityTuplizerFactory;
    private boolean checkNullability;
    private final boolean initializeLazyStateOutsideTransactions;
    private final MultiTableBulkIdStrategy multiTableBulkIdStrategy;
    private final TempTableDdlTransactionHandling tempTableDdlTransactionHandling;
    private final BatchFetchStyle batchFetchStyle;
    private final int defaultBatchFetchSize;
    private final Integer maximumFetchDepth;
    private final NullPrecedence defaultNullPrecedence;
    private final boolean orderUpdatesEnabled;
    private final boolean orderInsertsEnabled;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private final Map querySubstitutions;
    private final boolean strictJpaQueryLanguageCompliance;
    private final boolean namedQueryStartupCheckingEnabled;
    private final boolean procedureParameterNullPassingEnabled;
    private final boolean secondLevelCacheEnabled;
    private final boolean queryCacheEnabled;
    private final QueryCacheFactory queryCacheFactory;
    private final String cacheRegionPrefix;
    private final boolean minimalPutsEnabled;
    private final boolean structuredCacheEntriesEnabled;
    private final boolean directReferenceCacheEntriesEnabled;
    private final boolean autoEvictCollectionCache;
    private final SchemaAutoTooling schemaAutoTooling;
    private final boolean getGeneratedKeysEnabled;
    private final int jdbcBatchSize;
    private final boolean jdbcBatchVersionedData;
    private final Integer jdbcFetchSize;
    private final boolean scrollableResultSetsEnabled;
    private final boolean commentsEnabled;
    private final PhysicalConnectionHandlingMode physicalConnectionHandlingMode;
    private final boolean wrapResultSetsEnabled;
    private final Map<String, SQLFunction> sqlFunctions;

    public SessionFactoryOptionsImpl(SessionFactoryOptionsState state) {
        this.serviceRegistry = state.getServiceRegistry();
        this.beanManagerReference = state.getBeanManagerReference();
        this.validatorFactoryReference = state.getValidatorFactoryReference();
        this.sessionFactoryName = state.getSessionFactoryName();
        this.sessionFactoryNameAlsoJndiName = state.isSessionFactoryNameAlsoJndiName();
        this.flushBeforeCompletionEnabled = state.isFlushBeforeCompletionEnabled();
        this.autoCloseSessionEnabled = state.isAutoCloseSessionEnabled();
        this.jtaTrackByThread = state.isJtaTrackByThread();
        this.preferUserTransaction = state.isPreferUserTransaction();
        this.statisticsEnabled = state.isStatisticsEnabled();
        this.interceptor = state.getInterceptor();
        this.statementInspector = state.getStatementInspector();
        this.sessionFactoryObserverList = state.getSessionFactoryObservers();
        this.baselineSessionEventsListenerBuilder = state.getBaselineSessionEventsListenerBuilder();
        this.customEntityDirtinessStrategy = state.getCustomEntityDirtinessStrategy();
        this.entityNameResolvers = state.getEntityNameResolvers();
        this.entityNotFoundDelegate = state.getEntityNotFoundDelegate();
        this.identifierRollbackEnabled = state.isIdentifierRollbackEnabled();
        this.defaultEntityMode = state.getDefaultEntityMode();
        this.entityTuplizerFactory = state.getEntityTuplizerFactory();
        this.checkNullability = state.isCheckNullability();
        this.initializeLazyStateOutsideTransactions = state.isInitializeLazyStateOutsideTransactionsEnabled();
        this.multiTableBulkIdStrategy = state.getMultiTableBulkIdStrategy();
        this.tempTableDdlTransactionHandling = state.getTempTableDdlTransactionHandling();
        this.batchFetchStyle = state.getBatchFetchStyle();
        this.defaultBatchFetchSize = state.getDefaultBatchFetchSize();
        this.maximumFetchDepth = state.getMaximumFetchDepth();
        this.defaultNullPrecedence = state.getDefaultNullPrecedence();
        this.orderUpdatesEnabled = state.isOrderUpdatesEnabled();
        this.orderInsertsEnabled = state.isOrderInsertsEnabled();
        this.multiTenancyStrategy = state.getMultiTenancyStrategy();
        this.currentTenantIdentifierResolver = state.getCurrentTenantIdentifierResolver();
        this.querySubstitutions = state.getQuerySubstitutions();
        this.strictJpaQueryLanguageCompliance = state.isStrictJpaQueryLanguageCompliance();
        this.namedQueryStartupCheckingEnabled = state.isNamedQueryStartupCheckingEnabled();
        this.procedureParameterNullPassingEnabled = state.isProcedureParameterNullPassingEnabled();
        this.secondLevelCacheEnabled = state.isSecondLevelCacheEnabled();
        this.queryCacheEnabled = state.isQueryCacheEnabled();
        this.queryCacheFactory = state.getQueryCacheFactory();
        this.cacheRegionPrefix = state.getCacheRegionPrefix();
        this.minimalPutsEnabled = state.isMinimalPutsEnabled();
        this.structuredCacheEntriesEnabled = state.isStructuredCacheEntriesEnabled();
        this.directReferenceCacheEntriesEnabled = state.isDirectReferenceCacheEntriesEnabled();
        this.autoEvictCollectionCache = state.isAutoEvictCollectionCache();
        this.schemaAutoTooling = state.getSchemaAutoTooling();
        this.physicalConnectionHandlingMode = state.getPhysicalConnectionHandlingMode();
        this.getGeneratedKeysEnabled = state.isGetGeneratedKeysEnabled();
        this.jdbcBatchSize = state.getJdbcBatchSize();
        this.jdbcBatchVersionedData = state.isJdbcBatchVersionedData();
        this.jdbcFetchSize = state.getJdbcFetchSize();
        this.scrollableResultSetsEnabled = state.isScrollableResultSetsEnabled();
        this.wrapResultSetsEnabled = state.isWrapResultSetsEnabled();
        this.commentsEnabled = state.isCommentsEnabled();
        this.sqlFunctions = state.getCustomSqlFunctionMap();
    }

    @Override
    public StandardServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public Object getBeanManagerReference() {
        return this.beanManagerReference;
    }

    @Override
    public Object getValidatorFactoryReference() {
        return this.validatorFactoryReference;
    }

    @Override
    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    @Override
    public boolean isSessionFactoryNameAlsoJndiName() {
        return this.sessionFactoryNameAlsoJndiName;
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public StatementInspector getStatementInspector() {
        return this.statementInspector;
    }

    @Override
    public BaselineSessionEventsListenerBuilder getBaselineSessionEventsListenerBuilder() {
        return this.baselineSessionEventsListenerBuilder;
    }

    @Override
    public SessionFactoryObserver[] getSessionFactoryObservers() {
        return this.sessionFactoryObserverList;
    }

    @Override
    public boolean isIdentifierRollbackEnabled() {
        return this.identifierRollbackEnabled;
    }

    @Override
    public EntityMode getDefaultEntityMode() {
        return this.defaultEntityMode;
    }

    @Override
    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    @Override
    public boolean isCheckNullability() {
        return this.checkNullability;
    }

    @Override
    public boolean isInitializeLazyStateOutsideTransactionsEnabled() {
        return this.initializeLazyStateOutsideTransactions;
    }

    @Override
    public MultiTableBulkIdStrategy getMultiTableBulkIdStrategy() {
        return this.multiTableBulkIdStrategy;
    }

    @Override
    public TempTableDdlTransactionHandling getTempTableDdlTransactionHandling() {
        return this.tempTableDdlTransactionHandling;
    }

    @Override
    public BatchFetchStyle getBatchFetchStyle() {
        return this.batchFetchStyle;
    }

    @Override
    public int getDefaultBatchFetchSize() {
        return this.defaultBatchFetchSize;
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.maximumFetchDepth;
    }

    @Override
    public NullPrecedence getDefaultNullPrecedence() {
        return this.defaultNullPrecedence;
    }

    @Override
    public boolean isOrderUpdatesEnabled() {
        return this.orderUpdatesEnabled;
    }

    @Override
    public boolean isOrderInsertsEnabled() {
        return this.orderInsertsEnabled;
    }

    @Override
    public MultiTenancyStrategy getMultiTenancyStrategy() {
        return this.multiTenancyStrategy;
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    @Override
    public boolean isJtaTrackByThread() {
        return this.jtaTrackByThread;
    }

    @Override
    public Map getQuerySubstitutions() {
        return this.querySubstitutions;
    }

    @Override
    public boolean isStrictJpaQueryLanguageCompliance() {
        return this.strictJpaQueryLanguageCompliance;
    }

    @Override
    public boolean isNamedQueryStartupCheckingEnabled() {
        return this.namedQueryStartupCheckingEnabled;
    }

    @Override
    public boolean isProcedureParameterNullPassingEnabled() {
        return this.procedureParameterNullPassingEnabled;
    }

    @Override
    public boolean isSecondLevelCacheEnabled() {
        return this.secondLevelCacheEnabled;
    }

    @Override
    public boolean isQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    @Override
    public QueryCacheFactory getQueryCacheFactory() {
        return this.queryCacheFactory;
    }

    @Override
    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    @Override
    public boolean isMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    @Override
    public boolean isStructuredCacheEntriesEnabled() {
        return this.structuredCacheEntriesEnabled;
    }

    @Override
    public boolean isDirectReferenceCacheEntriesEnabled() {
        return this.directReferenceCacheEntriesEnabled;
    }

    @Override
    public boolean isAutoEvictCollectionCache() {
        return this.autoEvictCollectionCache;
    }

    @Override
    public SchemaAutoTooling getSchemaAutoTooling() {
        return this.schemaAutoTooling;
    }

    @Override
    public int getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public boolean isJdbcBatchVersionedData() {
        return this.jdbcBatchVersionedData;
    }

    @Override
    public boolean isScrollableResultSetsEnabled() {
        return this.scrollableResultSetsEnabled;
    }

    @Override
    public boolean isWrapResultSetsEnabled() {
        return this.wrapResultSetsEnabled;
    }

    @Override
    public boolean isGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    @Override
    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    @Override
    public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
        return this.physicalConnectionHandlingMode;
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.physicalConnectionHandlingMode.getReleaseMode();
    }

    @Override
    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.customEntityDirtinessStrategy;
    }

    @Override
    public EntityNameResolver[] getEntityNameResolvers() {
        return this.entityNameResolvers;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    @Override
    public Map<String, SQLFunction> getCustomSqlFunctionMap() {
        return this.sqlFunctions;
    }

    @Override
    public void setCheckNullability(boolean enabled) {
        this.checkNullability = enabled;
    }

    @Override
    public boolean isPreferUserTransaction() {
        return this.preferUserTransaction;
    }
}

