/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.process.instance.impl.NoOpExecutionErrorHandler;
import org.jbpm.runtime.manager.impl.error.ExecutionErrorHandlerImpl;
import org.kie.internal.runtime.error.ExecutionErrorFilter;
import org.kie.internal.runtime.error.ExecutionErrorHandler;
import org.kie.internal.runtime.error.ExecutionErrorManager;
import org.kie.internal.runtime.error.ExecutionErrorStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionErrorManagerImpl
implements ExecutionErrorManager {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionErrorManagerImpl.class);
    private static ThreadLocal<ExecutionErrorHandler> handler = new ThreadLocal();
    private List<ExecutionErrorFilter> filters = new ArrayList<ExecutionErrorFilter>();
    private ExecutionErrorStorage storage;

    public ExecutionErrorManagerImpl(ExecutionErrorStorage storage) {
        ServiceLoader<ExecutionErrorFilter> discoveredFilters = ServiceLoader.load(ExecutionErrorFilter.class);
        discoveredFilters.forEach(filter -> this.filters.add((ExecutionErrorFilter)filter));
        this.filters.sort((f1, f2) -> f1.getPriority().compareTo(f2.getPriority()));
        logger.debug("Error handling filters {}", this.filters);
        this.storage = storage;
        logger.debug("Execution error storage {}", (Object)this.storage);
    }

    public ExecutionErrorHandler getHandler() {
        ExecutionErrorHandler activeHandler = handler.get();
        if (activeHandler == null) {
            activeHandler = new NoOpExecutionErrorHandler();
        }
        return activeHandler;
    }

    public ExecutionErrorStorage getStorage() {
        return this.storage;
    }

    public ExecutionErrorHandler createHandler() {
        if (handler.get() == null) {
            handler.set(new ExecutionErrorHandlerImpl(Collections.unmodifiableList(this.filters), this.storage));
        }
        return this.getHandler();
    }

    public void closeHandler() {
        handler.set(null);
    }
}

