/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.runtime.ChainableRunner;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.jpa.OptimisticLockRetryInterceptor;
import org.drools.persistence.jta.TransactionLockInterceptor;
import org.jbpm.runtime.manager.impl.error.ExecutionErrorHandlerInterceptor;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.SessionFactory;

public class JPASessionFactory
implements SessionFactory {
    private RuntimeEnvironment environment;

    public JPASessionFactory(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    public KieSession newKieSession() {
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.environment.getKieBase(), (KieSessionConfiguration)this.environment.getConfiguration(), (Environment)this.environment.getEnvironment());
        this.addInterceptors((KieSession)ksession);
        return ksession;
    }

    public KieSession findKieSessionById(Long sessionId) {
        if (sessionId == null) {
            return null;
        }
        StatefulKnowledgeSession ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((Long)sessionId, (KieBase)this.environment.getKieBase(), (KieSessionConfiguration)this.environment.getConfiguration(), (Environment)this.environment.getEnvironment());
        this.addInterceptors((KieSession)ksession);
        return ksession;
    }

    public void close() {
    }

    protected void addInterceptors(KieSession ksession) {
        PersistableRunner runner = (PersistableRunner)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
        runner.addInterceptor((ChainableRunner)new OptimisticLockRetryInterceptor());
        runner.addInterceptor((ChainableRunner)new TransactionLockInterceptor(ksession.getEnvironment()));
        runner.addInterceptor((ChainableRunner)new ExecutionErrorHandlerInterceptor(ksession.getEnvironment()));
    }
}

