/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPointNode
extends ObjectSource
implements Externalizable,
ObjectSink {
    private static final long serialVersionUID = 510L;
    protected static final transient Logger log = LoggerFactory.getLogger(EntryPointNode.class);
    private EntryPointId entryPoint;
    protected Map<ObjectType, ObjectTypeNode> objectTypeNodes;
    protected ObjectTypeNode queryNode;
    private ObjectTypeNode activationNode;

    public EntryPointNode() {
    }

    public EntryPointNode(int id, ObjectSource objectSource, BuildContext context) {
        this(id, context.getPartitionId(), context.getKnowledgeBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getCurrentEntryPoint());
    }

    public EntryPointNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, EntryPointId entryPoint) {
        super(id, partitionId, partitionsEnabled, objectSource, 999);
        this.entryPoint = entryPoint;
        this.objectTypeNodes = new ConcurrentHashMap<ObjectType, ObjectTypeNode>();
        this.hashcode = this.calculateHashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.entryPoint = (EntryPointId)in.readObject();
        this.objectTypeNodes = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.entryPoint);
        out.writeObject(this.objectTypeNodes);
    }

    @Override
    public short getType() {
        return 10;
    }

    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    void setEntryPoint(EntryPointId entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void assertQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("rete only");
    }

    public void retractQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("rete only");
    }

    public void modifyQuery(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("rete only");
    }

    public ObjectTypeNode getQueryNode() {
        if (this.queryNode == null) {
            this.queryNode = this.objectTypeNodes.get(ClassObjectType.DroolsQuery_ObjectType);
        }
        return this.queryNode;
    }

    public void assertActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.propagateAssert(factHandle, context, workingMemory);
        }
    }

    public void retractActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            this.activationNode.retractObject(factHandle, context, workingMemory);
        }
    }

    public void modifyActivation(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.activationNode == null) {
            this.activationNode = this.objectTypeNodes.get(ClassObjectType.Match_ObjectType);
        }
        if (this.activationNode != null) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(factHandle.detachLinkedTuples());
            this.activationNode.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
            modifyPreviousTuples.retractTuples(context, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        if (log.isTraceEnabled()) {
            log.trace("Insert {}", (Object)handle.toString());
        }
        if (this.partitionsEnabled) {
            PropagationEntry.Insert.execute(handle, context, workingMemory, objectTypeConf);
        } else {
            workingMemory.addPropagation(new PropagationEntry.Insert(handle, context, workingMemory, objectTypeConf));
        }
    }

    public void modifyObject(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        if (log.isTraceEnabled()) {
            log.trace("Update {}", (Object)handle.toString());
        }
        workingMemory.addPropagation(new PropagationEntry.Update(handle, pctx, objectTypeConf));
    }

    public static void propagateModify(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, InternalWorkingMemory wm) {
        EntryPointNode.propagateModify(handle, pctx, objectTypeConf, wm, new ModifyPreviousTuples(handle.detachLinkedTuples()));
    }

    public static void propagateModify(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, InternalWorkingMemory wm, ModifyPreviousTuples modifyPreviousTuples) {
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        int length = cachedNodes.length;
        for (int i = 0; i < length; ++i) {
            cachedNodes[i].modifyObject(handle, modifyPreviousTuples, pctx, wm);
            if (i >= cachedNodes.length - 1) continue;
            EntryPointNode.removeRightTuplesMatchingOTN(pctx, wm, modifyPreviousTuples, cachedNodes[i], 0);
        }
        modifyPreviousTuples.retractTuples(pctx, wm);
    }

    public static void removeRightTuplesMatchingOTN(PropagationContext pctx, InternalWorkingMemory wm, ModifyPreviousTuples modifyPreviousTuples, ObjectTypeNode node, int partition) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple(partition);
        while (rightTuple != null && ((BaseNode)rightTuple.getTupleSink()).getObjectTypeNode() == node) {
            modifyPreviousTuples.removeRightTuple(partition);
            modifyPreviousTuples.doRightDelete(pctx, wm, rightTuple);
            rightTuple = modifyPreviousTuples.peekRightTuple(partition);
        }
        while (true) {
            LeftTuple leftTuple = modifyPreviousTuples.peekLeftTuple(partition);
            ObjectTypeNode otn = null;
            if (leftTuple != null) {
                LeftTupleSink leftTupleSink = (LeftTupleSink)leftTuple.getTupleSink();
                if (leftTupleSink instanceof LeftTupleSource) {
                    otn = leftTupleSink.getLeftTupleSource().getObjectTypeNode();
                } else if (leftTupleSink instanceof RuleTerminalNode) {
                    otn = ((RuleTerminalNode)leftTupleSink).getObjectTypeNode();
                }
            }
            if (otn != node) break;
            modifyPreviousTuples.removeLeftTuple(partition);
            modifyPreviousTuples.doDeleteObject(pctx, wm, leftTuple);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        if (log.isTraceEnabled()) {
            log.trace("Delete {}", (Object)handle.toString());
        }
        workingMemory.addPropagation(new PropagationEntry.Delete(this, handle, context, objectTypeConf));
    }

    public void propagateRetract(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        if (cachedNodes == null) {
            return;
        }
        for (ObjectTypeNode cachedNode : cachedNodes) {
            cachedNode.retractObject(handle, context, workingMemory);
        }
        if (handle.isEvent()) {
            ((EventFactHandle)handle).unscheduleAllJobs(workingMemory);
        }
    }

    @Override
    public void addObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    @Override
    public void removeObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.remove(node.getObjectType());
    }

    public void removeObjectType(ObjectType objectType) {
        this.objectTypeNodes.remove(objectType);
    }

    public void attach() {
        this.attach(null);
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            workingMemory.updateEntryPointsCache();
        }
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        return false;
    }

    public Map<ObjectType, ObjectTypeNode> getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    private int calculateHashCode() {
        return this.entryPoint.hashCode();
    }

    public boolean equals(Object object) {
        return this == object || this.internalEquals(object);
    }

    @Override
    protected boolean internalEquals(Object object) {
        return object instanceof EntryPointNode && this.hashCode() == object.hashCode() && this.entryPoint.equals(((EntryPointNode)object).entryPoint);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode node = (ObjectTypeNode)sink;
        ObjectType newObjectType = node.getObjectType();
        WorkingMemoryEntryPoint wmEntryPoint = workingMemory.getWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId());
        for (ObjectTypeConf objectTypeConf : wmEntryPoint.getObjectTypeConfigurationRegistry().values()) {
            if (objectTypeConf.getConcreteObjectTypeNode() == null || !newObjectType.isAssignableFrom(objectTypeConf.getConcreteObjectTypeNode().getObjectType())) continue;
            objectTypeConf.resetCache();
            ObjectTypeNode sourceNode = objectTypeConf.getConcreteObjectTypeNode();
            Iterator<InternalFactHandle> it = workingMemory.getNodeMemory(sourceNode).iterator();
            while (it.hasNext()) {
                sink.assertObject(it.next(), context, workingMemory);
            }
        }
    }

    @Override
    public String toString() {
        return "[EntryPointNode(" + this.id + ") " + this.entryPoint + " ]";
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitMask calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }
}

